/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal.zone;

import com.simsilica.ethereal.zone.StateBlock;
import com.simsilica.ethereal.zone.ZoneKey;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Zone {
    static Logger log = LoggerFactory.getLogger(Zone.class);
    private final ZoneKey key;
    private final Set<Long> children = new HashSet<Long>();
    private StateBlock current;
    private final StateBlock[] history;
    private int historyIndex = 0;

    public Zone(ZoneKey key, int historyBacklog) {
        this.key = key;
        this.history = new StateBlock[historyBacklog];
    }

    public void beginUpdate(long time) {
        if (log.isTraceEnabled()) {
            log.trace(this.key + ":beginUpdate(" + time + ")");
        }
        this.current = new StateBlock(time, this.key);
    }

    public void update(Long parent, Long id, Vec3d pos, Quatd rotation) {
        if (log.isTraceEnabled()) {
            log.trace(this.key + ":update(" + id + ", " + pos + ")");
        }
        this.current.addUpdate(parent, id, pos, rotation);
    }

    public void addChild(Long id) {
        if (log.isTraceEnabled()) {
            log.trace(this.key + ":addChild(" + id + ")");
        }
        if (!this.children.add(id)) {
            log.warn("Zone already had a body child for id:" + id);
        }
    }

    public void removeChild(Long id) {
        if (log.isTraceEnabled()) {
            log.trace(this.key + ":removeChild(" + id + ")");
        }
        if (!this.children.remove(id)) {
            log.warn("Zone did not have child to remove for id:" + id);
        }
        this.current.removeEntity(id);
    }

    public final boolean isEmpty() {
        return this.children.isEmpty();
    }

    public boolean commitUpdate() {
        if (log.isTraceEnabled()) {
            log.trace(this.key + ":commitUpdate() empty:" + this.current.isEmpty() + "   children:" + this.children);
        }
        if (this.current.isEmpty()) {
            this.current = null;
            return this.historyIndex != 0;
        }
        this.history[this.historyIndex++] = this.current;
        this.current = null;
        return true;
    }

    public StateBlock[] purgeHistory() {
        StateBlock[] result = new StateBlock[this.historyIndex];
        System.arraycopy(this.history, 0, result, 0, this.historyIndex);
        for (int i = 0; i < this.historyIndex; ++i) {
            this.history[i] = null;
        }
        this.historyIndex = 0;
        return result;
    }

    public String toString() {
        return "Zone[" + this.key + ", child.size=" + this.children.size() + "]";
    }
}

