/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.config;

import com.google.common.base.MoreObjects;
import com.jme3.asset.AssetManager;
import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.material.MaterialDef;
import com.jme3.material.RenderState;
import com.jme3.shader.VarType;
import com.simsilica.mblock.config.MaterialRegistry;
import com.simsilica.mblock.config.TextureConfig;
import com.simsilica.mblock.geom.GeomPart;
import com.simsilica.mblock.geom.GeomReq;
import com.simsilica.mblock.geom.MaterialType;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialConfig
implements Serializable {
    static Logger log = LoggerFactory.getLogger(MaterialConfig.class);
    static final long serialVersionUID = 42L;
    private String name;
    private String j3md;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private RenderState renderState = new RenderState();
    private List<String> inherit = null;
    private EnumSet<GeomReq> geomReqs = EnumSet.noneOf(GeomReq.class);
    private Integer layer;
    private transient MaterialDef matDef;

    public MaterialConfig(String name, String j3md) {
        this.name = name;
        this.j3md = j3md;
    }

    public MaterialConfig(String name, MaterialConfig inherit) {
        this.name = name;
        this.j3md = inherit.j3md;
        this.renderState = inherit.renderState != null ? inherit.renderState.clone() : null;
        this.properties.putAll(inherit.properties);
    }

    public MaterialType createMaterialType() {
        log.info("createMaterialType(" + this.name + ") reqs:" + this.geomReqs);
        return new MaterialType(this.name, this.layer, this.geomReqs);
    }

    public MaterialType getMaterialType() {
        return this.createMaterialType().internalize();
    }

    public String getName() {
        return this.name;
    }

    public String getJ3md() {
        return this.j3md;
    }

    public RenderState getRenderState() {
        return this.renderState;
    }

    public void addGeomReq(GeomReq req) {
        this.geomReqs.add(req);
    }

    public EnumSet<GeomReq> getGeomReqs() {
        return this.geomReqs;
    }

    public EnumSet<GeomReq> getImpliedReqs() {
        return GeomReq.expandImplied(this.geomReqs);
    }

    public boolean canRender(GeomPart part) {
        EnumSet<GeomReq> caps = part.calculateGeomCaps();
        return caps.containsAll(this.getImpliedReqs());
    }

    public EnumSet<GeomReq> getMissingReqs(GeomPart part) {
        EnumSet<GeomReq> caps = part.calculateGeomCaps();
        Object result = this.getImpliedReqs().clone();
        ((AbstractSet)result).removeAll(caps);
        return result;
    }

    public Object get(Object key) {
        return this.properties.get(key);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.properties.entrySet();
    }

    public Object put(String key, Object value) {
        return this.properties.put(key, value);
    }

    private static Object toValue(AssetManager assets, VarType type, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof TextureConfig) {
            value = ((TextureConfig)value).create(assets);
        }
        switch (type) {
            case Float: {
                if (value instanceof Float) {
                    return value;
                }
                if (value instanceof Number) {
                    return Float.valueOf(((Number)value).floatValue());
                }
                throw new IllegalArgumentException("Type mismatch for var type:" + type + ", value type:" + value.getClass());
            }
            case Int: {
                if (value instanceof Integer) {
                    return value;
                }
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                throw new IllegalArgumentException("Type mismatch for var type:" + type + ", value type:" + value.getClass());
            }
        }
        return value;
    }

    protected void applyConfig(AssetManager assets, MaterialRegistry materials, Material target, Set<MaterialConfig> visited) {
        log.info("Applying material config:" + this.getName());
        if (!visited.add(this)) {
            log.info("  already visited:" + this.getName());
            return;
        }
        EnumSet<GeomReq> implied = this.getImpliedReqs();
        for (MaterialConfig materialConfig : materials.getConfigs(this.getName())) {
            if (visited.contains(materialConfig) || !implied.containsAll(materialConfig.getImpliedReqs())) continue;
            log.info("inheriting sibling parameters from:" + materialConfig.getMaterialType());
            materialConfig.applyConfig(assets, materials, target, visited);
        }
        for (String string : this.getInherit()) {
            MaterialConfig materialConfig = materials.findConfig(string, this.getMaterialType());
            if (materialConfig == null) {
                throw new RuntimeException("Inherited material not found:" + string + " + " + this.getMaterialType());
            }
            materialConfig.applyConfig(assets, materials, target, visited);
        }
        MaterialDef md = target.getMaterialDef();
        for (Map.Entry<String, Object> entry : this.entrySet()) {
            MatParam mp = md.getMaterialParam(entry.getKey());
            if (mp == null) {
                throw new RuntimeException("Paramer not found:" + entry.getKey());
            }
            log.info("  set parameter:" + entry.getKey());
            target.setParam(entry.getKey(), mp.getVarType(), MaterialConfig.toValue(assets, mp.getVarType(), entry.getValue()));
        }
        RenderState renderState2 = new RenderState();
        renderState2 = target.getAdditionalRenderState().copyMergedTo(this.renderState, renderState2);
        target.getAdditionalRenderState().set(renderState2);
    }

    public Material createMaterial(AssetManager assets, MaterialRegistry materials) {
        assert (assets != null) : "Asset manager is null";
        Material result = new Material(assets, this.j3md);
        result.setName(this.name);
        log.info("createMaterial(" + this.name + ")");
        this.applyConfig(assets, materials, result, new HashSet<MaterialConfig>());
        return result;
    }

    public void updateMaterial(Material mat, AssetManager assets, MaterialRegistry materials) {
        log.info("updateMaterial(" + this.name + ")");
        this.applyConfig(assets, materials, mat, new HashSet<MaterialConfig>());
    }

    public void setInherit(String ... names) {
        if (names == null) {
            this.inherit = null;
            return;
        }
        this.setInherit(Arrays.asList(names));
    }

    public void setInherit(Collection<String> names) {
        if (names == null) {
            this.inherit = null;
            return;
        }
        if (this.inherit == null) {
            this.inherit = new ArrayList<String>();
        }
        this.inherit.addAll(names);
    }

    public void addInherit(String ... names) {
        this.addInherit(Arrays.asList(names));
    }

    public void addInherit(Collection<String> names) {
        if (this.inherit == null) {
            this.inherit = new ArrayList<String>();
        }
        this.inherit.addAll(names);
    }

    public List<String> getInherit() {
        if (this.inherit != null) {
            return this.inherit;
        }
        List<String> empty = Collections.emptyList();
        return empty;
    }

    public void setLayer(Integer layer) {
        this.layer = layer;
    }

    public Integer getLayer() {
        return this.layer;
    }

    public MaterialDef getMatDef(AssetManager assets) {
        if (this.matDef == null) {
            this.matDef = new MaterialDef(assets, this.j3md);
        }
        return this.matDef;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).omitNullValues().add("name", (Object)this.name).add("j3md", (Object)this.j3md).add("geomReqs", this.geomReqs).add("properties", this.properties).add("inherit", this.inherit).toString();
    }
}

