/*
 * Decompiled with CFR 0.152.
 */
package mythruna.mblock;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.DirectionMasks;
import com.simsilica.mblock.geom.BlockFactory;
import com.simsilica.mblock.geom.BoundaryShape;
import com.simsilica.mblock.geom.BoundaryShapes;
import com.simsilica.mblock.geom.GeomPart;
import com.simsilica.mblock.geom.GeomPartBuffer;
import com.simsilica.mblock.geom.MaterialType;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlameBlockFactory
implements BlockFactory {
    static final long serialVersionUID = 42L;
    static Logger log = LoggerFactory.getLogger(FlameBlockFactory.class);
    private MaterialType mt1;
    private MaterialType mt2;
    private double scale;
    private int count;
    private Vec3d min;
    private Vec3d max;

    public FlameBlockFactory(MaterialType mt1, MaterialType mt2, double scale, int count) {
        this.mt1 = mt1;
        this.mt2 = mt2;
        this.scale = scale;
        this.count = count;
        if (count <= 1) {
            double half = scale * 0.3;
            this.min = new Vec3d(0.5 - half, 0.5 - half, 0.0);
            this.max = new Vec3d(0.5 + half, 0.5 + half, 0.8 * scale);
        } else {
            double half = scale * 0.49;
            this.min = new Vec3d(0.5 - half, 0.5 - half, 0.0);
            this.max = new Vec3d(0.5 + half, 0.5 + half, 0.7 * scale);
        }
    }

    private double lerp(double s, double min, double max) {
        return (1.0 - s) * min + s * max;
    }

    public int addGeometryToBuffer(GeomPartBuffer buffer, int i, int j, int k, int xWorld, int yWorld, int zWorld, int sideMask, CellData cells, BlockType type) {
        double yOffset = -0.05;
        if (this.count <= 1) {
            GeomPart part = this.createFlame(this.mt1, 0.5, this.scale * 0.5 + yOffset, 0.5, this.scale);
            buffer.addPart(i, j, k, part);
            part = this.createFlame(this.mt2, 0.5, this.scale * 0.25 + yOffset, 0.5, this.scale);
            buffer.addPart(i, j, k, part);
            return 2;
        }
        for (int f = 0; f < this.count; ++f) {
            double localScale = this.lerp(buffer.nextRandom(), 0.5 * this.scale, this.scale);
            double xMin = 0.0;
            double zMin = 0.0;
            double xMax = 1.0;
            double zMax = 1.0;
            if (!DirectionMasks.hasNorth((int)sideMask)) {
                zMin += localScale * 0.35;
            }
            if (!DirectionMasks.hasSouth((int)sideMask)) {
                zMax -= localScale * 0.35;
            }
            if (!DirectionMasks.hasEast((int)sideMask)) {
                xMax -= localScale * 0.35;
            }
            if (!DirectionMasks.hasWest((int)sideMask)) {
                xMin += localScale * 0.35;
            }
            double xOffset = this.lerp(buffer.nextRandom(), xMin, xMax);
            double zOffset = this.lerp(buffer.nextRandom(), zMin, zMax);
            GeomPart part = this.createFlame(this.mt1, xOffset, localScale * 0.5 + yOffset, zOffset, localScale);
            buffer.addPart(i, j, k, part);
            part = this.createFlame(this.mt2, xOffset, localScale * 0.25 + yOffset, zOffset, localScale);
            buffer.addPart(i, j, k, part);
        }
        return this.count * 2;
    }

    protected GeomPart createFlame(MaterialType mt, double x, double y, double z, double size) {
        float halfScale = (float)(size * 0.5);
        GeomPart part = new GeomPart(mt, -1, true);
        double test = 0.0;
        part.setCoords(new float[]{(float)(x - test), (float)(y - test), (float)z, (float)(x + test), (float)(y - test), (float)z, (float)(x + test), (float)(y + test), (float)z, (float)(x - test), (float)(y + test), (float)z});
        part.setTexCoords(new float[]{-halfScale, -halfScale * 1.1f, halfScale, -halfScale * 1.1f, halfScale, halfScale * 1.4f, -halfScale, halfScale * 1.4f});
        part.setIndexes(new int[]{0, 1, 2, 0, 2, 3});
        return part;
    }

    public BoundaryShape getShape(Direction dir) {
        return BoundaryShapes.NULL_SHAPE;
    }

    public boolean isSolid(Direction dir) {
        return false;
    }

    public boolean isSolid() {
        return false;
    }

    public double getTransparency(Direction dir) {
        return 1.0;
    }

    public boolean isTransparent() {
        return true;
    }

    public double getVolume() {
        double x = this.getMax().x - this.getMin().x;
        double y = this.getMax().y - this.getMin().y;
        double z = this.getMax().z - this.getMin().z;
        return x * y * z;
    }

    public Vec3d getMin() {
        return this.min;
    }

    public Vec3d getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        FlameBlockFactory other = (FlameBlockFactory)o;
        if (!Objects.equals(other.mt1, this.mt1)) {
            return false;
        }
        if (!Objects.equals(other.mt2, this.mt2)) {
            return false;
        }
        if (other.count != this.count) {
            return false;
        }
        return other.scale == this.scale;
    }

    public int hashCode() {
        return Objects.hash(this.mt1, this.mt2, this.count, this.scale);
    }

    public BlockFactory rotate(int dirDelta) {
        return this;
    }
}

