/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.Entity;
import com.simsilica.es.Name;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.SequenceModels;
import com.simsilica.lemur.Spinner;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.text.DocumentModel;
import com.simsilica.lemur.text.DocumentModelFilter;
import com.simsilica.lemur.text.TextFilters;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterEditor
extends Container {
    static Logger log = LoggerFactory.getLogger(CharacterEditor.class);
    private List<String> genderOptions = Arrays.asList("Male", "Female");
    private List<String> raceOptions = Arrays.asList("Human", "Goedwin");
    private TextField name;
    private Spinner<String> gender;
    private Spinner<String> race;
    private Runnable done;

    public CharacterEditor() {
        Container properties = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Even, FillMode.Last)), new Object[0]);
        DocumentModelFilter nameModel = new DocumentModelFilter(TextFilters.charFilter((Predicate)Predicates.or((Predicate)TextFilters.isLetterOrDigit(), (Predicate)TextFilters.isInChars((char[])new char[]{' ', '_', '-', '.', '\'', ','}))), null);
        properties.addChild((Node)new Label("Name:", new ElementId("property.label")), new Object[0]);
        this.name = (TextField)properties.addChild((Node)new TextField((DocumentModel)nameModel), new Object[]{1});
        properties.addChild((Node)new Label("Race:", new ElementId("property.label")), new Object[0]);
        this.race = (Spinner)properties.addChild((Node)new Spinner(SequenceModels.listSequence(this.raceOptions)), new Object[]{1});
        properties.addChild((Node)new Label("Gender:", new ElementId("property.label")), new Object[0]);
        this.gender = (Spinner)properties.addChild((Node)new Spinner(SequenceModels.listSequence(this.genderOptions)), new Object[]{1});
        Container buttons = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "create")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "cancel")), new Object[0]);
    }

    public String getName() {
        return this.name.getText();
    }

    public String getRace() {
        return (String)this.race.getValue();
    }

    public String getGender() {
        return (String)this.gender.getValue();
    }

    public void editCharacter(Entity e, Runnable done) {
        this.done = done;
        if (e == null) {
            this.name.setText("");
        } else {
            this.name.setText(((Name)e.get(Name.class)).getName());
        }
        GuiGlobals.getInstance().getPopupState().centerInGui((Spatial)this);
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f));
    }

    protected void create() {
        GuiGlobals.getInstance().getPopupState().closePopup((Spatial)this);
        if (this.done != null) {
            this.done.run();
        }
    }

    protected void cancel() {
        GuiGlobals.getInstance().getPopupState().closePopup((Spatial)this);
    }
}

