/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.TabbedPanel;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.style.ElementId;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpMenuState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(HelpMenuState.class);
    private Container window;
    private TabbedPanel tabs;

    public HelpMenuState() {
        this.setEnabled(false);
    }

    public void toggleEnabled() {
        this.setEnabled(!this.isEnabled());
    }

    public void close() {
        ((GameSessionState)this.getState(GameSessionState.class)).trigger("returnToGame");
    }

    protected void initialize(Application app) {
        this.window = new Container();
        this.window.setLocalScale(1.5f);
        this.window.addChild((Node)new Label("In Game Help", new ElementId("window.title")), new Object[0]);
        Container help = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        Container col1 = (Container)help.addChild((Node)new Container(), new Object[0]);
        col1.setInsets(new Insets3f(10.0f, 10.0f, 10.0f, 10.0f));
        Container col2 = (Container)help.addChild((Node)new Container(), new Object[0]);
        col2.setInsets(new Insets3f(10.0f, 10.0f, 10.0f, 10.0f));
        String left = "What can I do?\n    Currently, you can walk around the world and\n    build things including custom objects.\n    More exciting things to come in future updates.\n\nWhat are the controls?\n    WASD moves and Mouse looks. Shift runs.\n    Space jumps.  'Q' flies up.\n    Left mouse deletes a block.\n    Right mouse places a block.\n    'C' selects the block type under the cursor.\n    'E' opens the block type selector menu.\n    Mouse wheel changes block rotation.\n    Tab opens/closes the player menu with the map.\n    'I' opens the inventory view.\n    Esc opens the in-game menu with the settings\n      menu, exit button, etc.\n    Enter/return opens the chat bar/command console\n      which in single player doesn't do much.\n    F5 toggles third person view.\n    F10 toggles detailed JME frame stats.\n\n    PrtScr will save a screen shot.\n\nIf you take some cool screen shots and post them\n@ me and I'll repost them!";
        String right = "Why are things so slow when I first start?\n    When a new world is created, the far buildings have to be\n    generated. This is currently kind of slow.\n    You can tell if this is happening by looking at the upper\n    right debug panel at 'Low:' with 'Queued' and 'Active'. \n    These indicate how many tiles are in progress with detailed\n    progress on the active items in the lower right of the screen.\n    Once this generation completes it is saved and won't have\n    to do it again for this world. Crossing a new tile boundary\n    will add 5 new tasks as it generates the newly discovered\n    tiles.\n\nIs lighting correct?\n    There are some bugs in the lighting updates as there are\n    some differences in how dynamic lighting is calculated\n    versus the whole world initial calculation.\n    Holding the control key and left clicking a block will \n    regenerate the lighting for an area.\n    (Note: it's actually the full world generation that is most\n     wrong though.)";
        col1.addChild((Node)new Label(left), new Object[0]);
        col2.addChild((Node)new Label(right), new Object[0]);
        Container buttons = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new Label(""), new Object[0]);
        ActionButton button = (ActionButton)buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "close")), new Object[0]);
        button.setTextHAlignment(HAlignment.Center);
        buttons.addChild((Node)new Label(""), new Object[0]);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.getApplication().enqueue(() -> {
            ((GuiState)this.getState(GuiState.class)).center((Panel)this.window);
            GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.window, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.75f));
        });
    }

    public void update(float tpf) {
    }

    protected void onDisable() {
        this.window.removeFromParent();
    }
}

