/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.geom;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.DirectionMasks;
import com.simsilica.mblock.FluidSlope;
import com.simsilica.mblock.FluidType;
import com.simsilica.mblock.FluidUtils;
import com.simsilica.mblock.geom.FluidFactory;
import com.simsilica.mblock.geom.GeomPart;
import com.simsilica.mblock.geom.GeomPartBuffer;
import com.simsilica.mblock.geom.MaterialType;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiquidFactory
implements FluidFactory {
    static final long serialVersionUID = 42L;
    static Logger log = LoggerFactory.getLogger(LiquidFactory.class);
    public static boolean DEBUG = false;
    private MaterialType topType;
    private MaterialType sideType;

    public LiquidFactory(MaterialType materialType) {
        this(materialType, materialType);
    }

    public LiquidFactory(MaterialType topType, MaterialType sideType) {
        this.topType = topType;
        this.sideType = sideType;
    }

    public MaterialType getTopMaterialType() {
        return this.topType;
    }

    public MaterialType getSideMaterialType() {
        return this.sideType;
    }

    private static float toCornerY(int level) {
        return (float)(level - 1) / 7.0f;
    }

    @Override
    public int addGeometryToBuffer(GeomPartBuffer buffer, int i, int j, int k, int xWorld, int yWorld, int zWorld, int sideMask, int level, CellData cells, CellData fluid, FluidType type) {
        int count = 0;
        Vec3d min = new Vec3d();
        Vec3d max = new Vec3d(1.0, (double)level / 8.0, 1.0);
        int value = fluid.getCell(i, j, k);
        FluidSlope slope = new FluidSlope().setBits(FluidUtils.getSlopeBits(value));
        if (log.isTraceEnabled()) {
            log.trace("part slope:" + slope);
        }
        float nw = LiquidFactory.toCornerY(slope.nw);
        float ne = LiquidFactory.toCornerY(slope.ne);
        float se = LiquidFactory.toCornerY(slope.se);
        float sw = LiquidFactory.toCornerY(slope.sw);
        if (DEBUG) {
            ne = nw = LiquidFactory.toCornerY(level);
            se = nw;
            sw = nw;
        }
        if (DirectionMasks.hasUp(sideMask) || level < 8) {
            GeomPart part;
            float center = LiquidFactory.toCornerY(level);
            if (center == 0.0f) {
                center += 0.071428575f;
            }
            float avg1 = (ne + sw) * 0.5f;
            float avg2 = (nw + se) * 0.5f;
            if (center > avg1 && center > avg2) {
                double xMid = (min.x + max.x) * 0.5;
                double zMid = (min.z + max.z) * 0.5;
                part = new GeomPart(this.topType, Direction.Up.ordinal(), false);
                part.setCoords((float)min.x, sw, (float)max.z, (float)max.x, se, (float)max.z, (float)max.x, ne, (float)min.z, (float)min.x, nw, (float)min.z, (float)xMid, center, (float)zMid);
                part.setIndexes(0, 1, 4, 1, 2, 4, 2, 3, 4, 3, 0, 4);
                part.setTexCoords(0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.5f, 0.5f);
            } else if (avg1 < avg2) {
                part = GeomPart.createQuad(min, max, this.topType, Direction.Up);
                float[] coords = part.getCoords();
                coords[1] = sw;
                coords[4] = se;
                coords[7] = ne;
                coords[10] = nw;
                part.setIndexes(0, 1, 3, 1, 2, 3);
            } else {
                part = GeomPart.createQuad(min, max, this.topType, Direction.Up);
                float[] coords = part.getCoords();
                coords[1] = sw;
                coords[4] = se;
                coords[7] = ne;
                coords[10] = nw;
            }
            if (!this.topType.needsIndexedNormals()) {
                if (this.topType.needsNormals()) {
                    part.generateNormals(Direction.Up);
                }
                if (this.topType.needsTangents()) {
                    part.generateTangents(Direction.Up);
                }
            }
            buffer.addPart(i, j, k, part);
            ++count;
            if (nw <= 0.0f && ne <= 0.0f) {
                sideMask &= 0xFFFFFFFE;
            }
            if (ne <= 0.0f && se <= 0.0f) {
                sideMask &= 0xFFFFFFFB;
            }
            if (se <= 0.0f && sw <= 0.0f) {
                sideMask &= 0xFFFFFFFD;
            }
            if (nw <= 0.0f && sw <= 0.0f) {
                sideMask &= 0xFFFFFFF7;
            }
        }
        for (Direction dir : Direction.values()) {
            if (dir == Direction.Up || (sideMask & dir.getBitMask()) == 0) continue;
            MaterialType materialType = this.sideType;
            GeomPart part = GeomPart.createQuad(min, max, materialType, dir);
            float[] coords = part.getCoords();
            float[] uvs = part.getTexCoords();
            switch (dir) {
                case North: {
                    coords[7] = nw;
                    coords[10] = ne;
                    break;
                }
                case South: {
                    coords[7] = se;
                    coords[10] = sw;
                    break;
                }
                case East: {
                    coords[7] = ne;
                    coords[10] = se;
                    break;
                }
                case West: {
                    coords[7] = sw;
                    coords[10] = nw;
                    break;
                }
            }
            buffer.addPart(i, j, k, part);
            ++count;
        }
        return count;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        LiquidFactory other = (LiquidFactory)o;
        if (!Objects.equals(this.topType, other.topType)) {
            return false;
        }
        return Objects.equals(this.sideType, other.sideType);
    }

    public int hashCode() {
        return Objects.hash(this.topType, this.sideType);
    }
}

