/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal;

import com.jme3.network.Client;
import com.jme3.network.service.AbstractClientService;
import com.jme3.network.service.ClientServiceManager;
import com.jme3.network.util.ObjectMessageDelegator;
import com.simsilica.ethereal.LocalZoneIndex;
import com.simsilica.ethereal.SharedObjectListener;
import com.simsilica.ethereal.SharedObjectSpace;
import com.simsilica.ethereal.TimeSource;
import com.simsilica.ethereal.net.ObjectStateProtocol;
import com.simsilica.ethereal.net.StateReceiver;
import com.simsilica.ethereal.zone.ZoneGrid;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mathd.bits.QuatBits;
import com.simsilica.mathd.bits.Vec3Bits;

public class EtherealClient
extends AbstractClientService {
    private ZoneGrid grid;
    private StateReceiver stateReceiver;
    private ObjectMessageDelegator<Client> delegator;
    private ObjectStateProtocol objectProtocol;
    private Vec3i clientZoneExtents;
    private SharedObjectSpace space;

    public EtherealClient() {
        this(new ObjectStateProtocol(8, 64, new Vec3Bits(-10.0f, 42.0f, 16), new QuatBits(12)), new ZoneGrid(32), new Vec3i(1, 1, 1));
    }

    public EtherealClient(ZoneGrid grid) {
        this(new ObjectStateProtocol(8, 64, new Vec3Bits(-10.0f, 42.0f, 16), new QuatBits(12)), grid, new Vec3i(1, 1, 1));
    }

    public EtherealClient(ObjectStateProtocol objectProtocol, ZoneGrid grid, Vec3i clientZoneExtents) {
        this.objectProtocol = objectProtocol;
        this.grid = grid;
        this.clientZoneExtents = clientZoneExtents;
    }

    public TimeSource getTimeSource() {
        return this.stateReceiver.getTimeSource();
    }

    public void addObjectListener(SharedObjectListener l) {
        this.space.addObjectListener(l);
    }

    public void removeObjectListener(SharedObjectListener l) {
        this.space.removeObjectListener(l);
    }

    protected void onInitialize(ClientServiceManager s) {
        this.space = new SharedObjectSpace(this.objectProtocol);
        this.stateReceiver = new StateReceiver(this.getClient(), new LocalZoneIndex(this.grid, this.clientZoneExtents), this.space);
        this.delegator = new ObjectMessageDelegator((Object)this.stateReceiver, true);
        this.getClient().addMessageListener(this.delegator, this.delegator.getMessageTypes());
    }

    public void terminate(ClientServiceManager serviceManager) {
        this.getClient().removeMessageListener(this.delegator, this.delegator.getMessageTypes());
    }
}

