/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.morph;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.db.SpoolingObjectDb;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import com.simsilica.mworld.tile.morph.MorphologyLayer;
import com.simsilica.mworld.tile.morph.MorphologyLayerProtocol;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphologyLayerDb
extends SpoolingObjectDb<TileId, MorphologyLayer> {
    static Logger log = LoggerFactory.getLogger(MorphologyLayerDb.class);
    private File root;
    private MorphologyLayerProtocol protocol;

    public MorphologyLayerDb(File root, MorphologyLayerProtocol protocol) {
        this.root = root;
        this.protocol = protocol;
    }

    @Override
    public void initialize() {
        this.protocol.initialize();
        super.initialize();
    }

    public MorphologyLayerProtocol getProtocol() {
        return this.protocol;
    }

    public TileFunction getLoadFunction() {
        return new TileFunction(){

            @Override
            public void accept(Tile tile) {
                MorphologyLayer layer = tile.get(MorphologyLayer.class);
                if (layer != null) {
                    throw new IllegalStateException("Tile:" + tile.getId() + " already has morphology layer");
                }
                layer = (MorphologyLayer)MorphologyLayerDb.this.get(tile.getId());
                tile.put(MorphologyLayer.class, layer);
            }
        };
    }

    public TileFunction getSaveFunction() {
        return new TileFunction(){

            @Override
            public void accept(Tile tile) {
                MorphologyLayer layer = tile.get(MorphologyLayer.class);
                if (layer.getVersion().isChanged()) {
                    log.info("Storing:" + layer);
                    MorphologyLayerDb.this.update(layer.getTileId(), layer);
                }
            }
        };
    }

    protected File toFile(TileId id) {
        Vec3i sedectile = id.getSedectileId().getCell(null);
        String path = sedectile.x + "/" + sedectile.z;
        File dir = new File(this.root, path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String name = id.getId() + ".morph";
        return new File(dir, name);
    }

    @Override
    protected MorphologyLayer loadObject(TileId id) {
        File file = this.toFile(id);
        if (file.exists()) {
            return this.readObjectFile(id, file);
        }
        return new MorphologyLayer(id, new DataVersion(0L, -1L));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MorphologyLayer readObjectFile(TileId id, File file) {
        try (BufferedInputStream in = new BufferedInputStream(new GZIPInputStream(new FileInputStream(file)));){
            MorphologyLayer result = this.protocol.read(in);
            assert (id.equals(result.getTileId()));
            MorphologyLayer morphologyLayer = result;
            return morphologyLayer;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading object:" + id + " from:" + file, e);
        }
    }

    @Override
    protected void storeObject(TileId id, MorphologyLayer value) {
        File file = this.toFile(id);
        this.writeObjectFile(id, file, value);
        value.getVersion().resetChanged(System.currentTimeMillis());
    }

    protected void writeObjectFile(TileId id, File file, MorphologyLayer value) {
        long start = System.nanoTime();
        try (BufferedOutputStream out = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file)));){
            this.protocol.write(value, out);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing object:" + id + " to:" + file, e);
        }
        long end = System.nanoTime();
        log.info("Wrote [" + id + "] in " + (double)(end - start) / 1000000.0 + " ms");
    }
}

