/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.fx.sky;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.asset.AssetManager;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import com.simsilica.fx.LightingState;
import com.simsilica.fx.geom.TruncatedDome;
import com.simsilica.fx.sky.AtmosphericParameters;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.core.VersionedReference;

public class SkyState
extends BaseAppState {
    private Node rootNode;
    private Geometry sky;
    private Geometry sun;
    private float domeInnerRadius = 2000.0f;
    private float domeOuterRadius = 2050.0f;
    private Geometry groundDisc;
    private boolean showGround = true;
    private boolean flat = false;
    private ColorRGBA skyColor;
    private ColorRGBA sunColor;
    private ColorRGBA lightingColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private Material flatMaterial;
    private Material atmosphericMaterial;
    private ColorRGBA groundColor = new ColorRGBA(0.25f, 0.25f, 0.3f, 1.0f);
    private Material groundMaterial;
    private AtmosphericParameters atmosphericParms;
    private VersionedReference<Vector3f> lightDir;

    public SkyState() {
        this(null, false);
    }

    public SkyState(ColorRGBA groundColor) {
        this(groundColor, groundColor != null);
    }

    public SkyState(boolean showGroundDisc) {
        this(null, showGroundDisc);
    }

    public SkyState(ColorRGBA groundColor, boolean showGroundDisc) {
        this.showGround = showGroundDisc;
        if (groundColor != null) {
            this.groundColor.set(groundColor);
        }
        this.sunColor = new ColorRGBA(1.0f, 1.0f, 0.9f, 1.0f);
        this.skyColor = new ColorRGBA(0.5f, 0.5f, 1.0f, 1.0f);
        float earthRadius = 6378100.0f;
        this.domeInnerRadius = 2000.0f;
        this.domeOuterRadius = 2050.0f;
        this.atmosphericParms = new AtmosphericParameters();
        this.atmosphericParms.setSkyDomeRadius(this.domeOuterRadius);
        this.atmosphericParms.setPlanetRadius(earthRadius * 0.01f);
    }

    public AtmosphericParameters getAtmosphericParameters() {
        return this.atmosphericParms;
    }

    public void setSkyParent(Node node) {
        this.rootNode = node;
    }

    public Node getSkyParent() {
        return this.rootNode;
    }

    public void setFlatShaded(boolean b) {
        if (this.flat == b) {
            return;
        }
        this.flat = b;
        this.resetMaterials();
    }

    public boolean isFlatShaded() {
        return this.flat;
    }

    public void setShowGroundDisc(boolean b) {
        if (this.showGround == b) {
            return;
        }
        this.showGround = b;
        this.resetGround();
    }

    public boolean getShowGroundDisc() {
        return this.showGround;
    }

    public Material getGroundDiscMaterial() {
        return this.groundMaterial;
    }

    public ColorRGBA getGroundColor() {
        return this.groundColor;
    }

    public ColorRGBA getLightingColor() {
        return this.lightingColor;
    }

    protected void resetMaterials() {
        if (this.flat) {
            if (this.sky != null) {
                this.sky.setMaterial(this.flatMaterial);
                this.sun.setCullHint(Spatial.CullHint.Inherit);
                this.groundMaterial.setBoolean("UseScattering", false);
            }
        } else if (this.sky != null) {
            this.sky.setMaterial(this.atmosphericMaterial);
            this.sun.setCullHint(Spatial.CullHint.Never);
            this.groundMaterial.setBoolean("UseScattering", true);
        }
    }

    protected void resetGround() {
        if (this.groundDisc == null) {
            return;
        }
        if (this.isEnabled()) {
            if (this.showGround) {
                this.rootNode.attachChild((Spatial)this.groundDisc);
            } else {
                this.groundDisc.removeFromParent();
            }
        }
    }

    protected void initialize(Application app) {
        if (this.rootNode == null) {
            this.rootNode = ((SimpleApplication)app).getRootNode();
        }
        this.lightDir = ((LightingState)this.getState(LightingState.class)).getLightDirRef();
        this.atmosphericParms.setLightDirection((Vector3f)this.lightDir.get());
        Sphere orb = new Sphere(6, 12, 50.0f);
        this.sun = new Geometry("Sun", (Mesh)orb);
        Material mat = GuiGlobals.getInstance().createMaterial(this.sunColor, false).getMaterial();
        this.sun.setMaterial(mat);
        this.sun.move(((Vector3f)this.lightDir.get()).mult(-900.0f));
        TruncatedDome skyDome = new TruncatedDome(this.domeInnerRadius, this.domeOuterRadius, 100, 50, true);
        this.sky = new Geometry("Sky", (Mesh)skyDome);
        this.sky.setModelBound((BoundingVolume)new BoundingSphere(Float.POSITIVE_INFINITY, Vector3f.ZERO));
        this.flatMaterial = GuiGlobals.getInstance().createMaterial(this.skyColor, false).getMaterial();
        this.sky.setMaterial(this.flatMaterial);
        this.atmosphericMaterial = this.atmosphericParms.getSkyMaterial(app.getAssetManager());
        this.sky.setMaterial(this.atmosphericMaterial);
        this.sky.setQueueBucket(RenderQueue.Bucket.Sky);
        this.sky.setCullHint(Spatial.CullHint.Never);
        AssetManager assets = app.getAssetManager();
        TruncatedDome ground = new TruncatedDome(this.domeInnerRadius, this.domeOuterRadius, 100, 50, true);
        this.groundDisc = new Geometry("ground", (Mesh)ground);
        this.groundDisc.rotate((float)Math.PI, 0.0f, 0.0f);
        this.groundDisc.setQueueBucket(RenderQueue.Bucket.Sky);
        this.groundDisc.setCullHint(Spatial.CullHint.Never);
        this.groundMaterial = mat = new Material(assets, "MatDefs/GroundAtmospherics.j3md");
        mat.setColor("GroundColor", this.groundColor);
        mat.setBoolean("FollowCamera", true);
        mat.setBoolean("UseScattering", true);
        mat.setFloat("GroundScale", 10.0f);
        this.groundDisc.setMaterial(mat);
        this.atmosphericParms.applyGroundParameters(mat, true);
        this.atmosphericParms.calculateGroundColor(ColorRGBA.White, Vector3f.UNIT_X, 1.0f, 0.0f, this.lightingColor);
    }

    protected void cleanup(Application app) {
    }

    public void update(float tpf) {
        if (this.lightDir.update()) {
            this.sun.setLocalTranslation(((Vector3f)this.lightDir.get()).mult(-900.0f));
            this.atmosphericParms.setLightDirection((Vector3f)this.lightDir.get());
            this.atmosphericParms.calculateGroundColor(ColorRGBA.White, Vector3f.UNIT_X, 1.0f, 0.0f, this.lightingColor);
        }
        if (this.flat) {
            this.sky.setLocalTranslation(this.getApplication().getCamera().getLocation());
        }
    }

    protected void onEnable() {
        this.rootNode.attachChild((Spatial)this.sky);
        this.resetMaterials();
        this.resetGround();
    }

    protected void onDisable() {
        this.sky.removeFromParent();
        this.groundDisc.removeFromParent();
    }
}

