/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.net.server;

import com.jme3.network.HostedConnection;
import com.jme3.network.service.AbstractHostedConnectionService;
import com.jme3.network.service.HostedServiceManager;
import com.jme3.network.service.rmi.RmiHostedService;
import com.jme3.network.service.rmi.RmiRegistry;
import com.simsilica.net.ChatSession;
import com.simsilica.net.ChatSessionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatHostedService
extends AbstractHostedConnectionService {
    static Logger log = LoggerFactory.getLogger(ChatHostedService.class);
    private static final String ATTRIBUTE_SESSION = ChatHostedService.class.getName();
    private RmiHostedService rmiService;
    private int channel;
    private List<ChatSessionImpl> players = new CopyOnWriteArrayList<ChatSessionImpl>();

    public ChatHostedService() {
        this(-2);
    }

    public ChatHostedService(int channel) {
        this.channel = channel;
        this.setAutoHost(false);
    }

    protected ChatSessionImpl getChatSession(HostedConnection conn) {
        return (ChatSessionImpl)conn.getAttribute(ATTRIBUTE_SESSION);
    }

    protected void onInitialize(HostedServiceManager s) {
        this.rmiService = (RmiHostedService)this.getService(RmiHostedService.class);
        if (this.rmiService == null) {
            throw new RuntimeException("ChatHostedService requires an RMI service.");
        }
    }

    public void startHostingOnConnection(HostedConnection conn, String playerName) {
        log.debug("startHostingOnConnection(" + conn + ")");
        ChatSessionImpl session = new ChatSessionImpl(conn, playerName);
        conn.setAttribute(ATTRIBUTE_SESSION, (Object)session);
        RmiRegistry rmi = this.rmiService.getRmiRegistry(conn);
        rmi.share((byte)this.channel, (Object)session, ChatSession.class);
        this.players.add(session);
        for (ChatSessionImpl chatter : this.players) {
            if (chatter == session) continue;
            chatter.playerJoined(conn.getId(), playerName);
        }
    }

    public void startHostingOnConnection(HostedConnection conn) {
        this.startHostingOnConnection(conn, "Client:" + conn.getId());
    }

    public void stopHostingOnConnection(HostedConnection conn) {
        log.debug("stopHostingOnConnection(" + conn + ")");
        ChatSessionImpl player = this.getChatSession(conn);
        if (player != null) {
            conn.setAttribute(ATTRIBUTE_SESSION, null);
            this.players.remove(player);
            for (ChatSessionImpl chatter : this.players) {
                if (chatter == player) continue;
                chatter.playerLeft(player.conn.getId(), player.name);
            }
        }
    }

    protected void postMessage(ChatSessionImpl from, String message) {
        log.info("chat> " + from.name + " said:" + message);
        for (ChatSessionImpl chatter : this.players) {
            chatter.newMessage(from.conn.getId(), from.name, message);
        }
    }

    private class ChatSessionImpl
    implements ChatSession,
    ChatSessionListener {
        private HostedConnection conn;
        private ChatSessionListener callback;
        private String name;

        public ChatSessionImpl(HostedConnection conn, String name) {
            this.conn = conn;
            this.name = name;
        }

        protected ChatSessionListener getCallback() {
            if (this.callback == null) {
                RmiRegistry rmi = ChatHostedService.this.rmiService.getRmiRegistry(this.conn);
                this.callback = (ChatSessionListener)rmi.getRemoteObject(ChatSessionListener.class);
                if (this.callback == null) {
                    throw new RuntimeException("Unable to locate client callback for ChatSessionListener");
                }
            }
            return this.callback;
        }

        @Override
        public void sendMessage(String message) {
            ChatHostedService.this.postMessage(this, message);
        }

        @Override
        public List<String> getPlayerNames() {
            ArrayList<String> results = new ArrayList<String>();
            for (ChatSessionImpl chatter : ChatHostedService.this.players) {
                results.add(chatter.name);
            }
            return results;
        }

        @Override
        public void playerJoined(int clientId, String playerName) {
            this.getCallback().playerJoined(clientId, playerName);
        }

        @Override
        public void newMessage(int clientId, String playerName, String message) {
            this.getCallback().newMessage(clientId, playerName, message);
        }

        @Override
        public void playerLeft(int clientId, String playerName) {
            this.getCallback().playerLeft(clientId, playerName);
        }
    }
}

