/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import mythruna.world.WorldManager;
import mythruna.world.WorldTime;
import mythruna.world.WorldTimeSource;
import mythruna.world.es.WorldAge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldTimeService
extends AbstractGameSystem
implements WorldTimeSource {
    static Logger log = LoggerFactory.getLogger(WorldTimeService.class);
    private static final EntityId SIM_ID = new EntityId(-1L);
    private EntityData ed;
    private EntityId worldEntity;
    private WorldTime worldTime = new WorldTime();
    private long nextTime = 0L;
    private long updateInterval = 1000000000L;

    @Override
    public long getSimTime() {
        return this.worldTime.getRealTimeNanos();
    }

    @Override
    public double getGameTime() {
        return this.worldTime.getGameTime();
    }

    protected void initialize() {
        WorldAge offset;
        this.ed = (EntityData)this.getSystem(EntityData.class, true);
        this.worldEntity = ((WorldManager)this.getSystem(WorldManager.class, true)).getWorldEntity();
        WorldAge age = (WorldAge)this.ed.getComponent(SIM_ID, WorldAge.class);
        if (age != null) {
            log.info("initializing start time to:" + age.getAge());
            this.getManager().getStepTime().setCurrentTime(age.getAge());
        }
        if ((offset = (WorldAge)this.ed.getComponent(this.worldEntity, WorldAge.class)) != null) {
            log.info("Setting base offset to:" + offset.getAge());
            this.worldTime.setBaseOffset(offset.getAge());
        } else {
            log.warn("No base offset for world entity:" + this.worldEntity);
        }
    }

    protected void terminate() {
    }

    public void start() {
    }

    public void update(SimTime time) {
        long rawTime = time.getTime();
        this.worldTime.setRealTimeNanos(rawTime);
        if (rawTime > this.nextTime) {
            WorldAge age = new WorldAge(rawTime);
            this.ed.setComponent(SIM_ID, (EntityComponent)age);
            this.nextTime = rawTime + this.updateInterval;
        }
    }

    public void stop() {
    }
}

