/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import com.simsilica.mworld.tile.tree.AtlasCell;
import com.simsilica.mworld.tile.tree.Tree;
import com.simsilica.mworld.tile.tree.TreeLayer;
import com.simsilica.mworld.tile.tree.TreeType;
import com.simsilica.mworld.tile.tree.TreeTypeIndex;
import java.util.Random;
import mythruna.world.WorldFractal;
import mythruna.world.tree.ChristmasTreeType;
import mythruna.world.tree.PineTreeType;
import mythruna.world.tree.ScrubTreeType;
import mythruna.world.tree.SimpleTreeType;
import mythruna.world.tree.UmbrellaTreeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeGenerator
implements TileFunction {
    static Logger log = LoggerFactory.getLogger(TreeGenerator.class);
    private TreeTypeIndex treeTypes;
    private String atlasName = "Textures/tree-atlas.png";
    private TreeType simple = new SimpleTreeType("simple", new AtlasCell(this.atlasName, 0));
    private TreeType umbrella = new UmbrellaTreeType("umbrella", new AtlasCell(this.atlasName, 2));
    private TreeType scrub = new ScrubTreeType("scrub", new AtlasCell(this.atlasName, 3));
    private TreeType pine = new PineTreeType("pine1", new AtlasCell(this.atlasName, 4));
    private TreeType smallPine = new PineTreeType("pine2", new AtlasCell(this.atlasName, 4), 0, 3, 4, 3);
    private TreeType scrubPine = new PineTreeType("pine3", new AtlasCell(this.atlasName, 4), 4, 3, 3, 6);
    private TreeType simple2 = new PineTreeType("simple2", new AtlasCell(this.atlasName, 4), 4, 3, 3, 6);
    private TreeType xmas = new ChristmasTreeType("xmas", new AtlasCell(this.atlasName, 4), 4, 3, 3, 6);
    private TreeType[] baseTypes = new TreeType[]{this.simple, this.simple, this.simple, this.simple, this.simple, this.simple, this.simple, this.simple, this.umbrella, this.umbrella, this.umbrella, this.umbrella, this.scrub, this.scrub, this.smallPine, this.smallPine, this.scrubPine};
    private TreeType[] rockyTypes = new TreeType[]{this.simple, this.simple, this.scrub, this.scrub, this.scrub, this.scrubPine, this.scrubPine, this.scrubPine, this.pine, this.pine, this.pine, this.pine, this.pine, this.pine, this.pine, this.pine, this.pine};
    private TreeType[] highTypes = new TreeType[]{this.simple, this.simple, this.simple, this.simple, this.scrubPine, this.pine, this.pine, this.pine, this.pine, this.pine, this.umbrella, this.umbrella, this.scrub, this.scrub, this.pine, this.pine, this.pine};
    private TreeType[] coldTypes = new TreeType[]{this.simple, this.scrub, this.scrubPine, this.scrubPine, this.scrubPine, this.scrubPine, this.scrubPine, this.scrubPine, this.smallPine, this.smallPine, this.smallPine, this.pine, this.pine, this.pine, this.pine, this.pine, this.pine, this.pine, this.pine, this.pine, this.pine, this.pine, this.pine};
    private WorldFractal fractal;

    public TreeGenerator(WorldFractal fractal) {
        this(fractal, TreeTypeIndex.getInstance());
    }

    public TreeGenerator(WorldFractal fractal, TreeTypeIndex treeTypes) {
        this.fractal = fractal;
        this.treeTypes = treeTypes;
        treeTypes.registerType(this.simple);
        treeTypes.registerType(this.umbrella);
        treeTypes.registerType(this.scrub);
        treeTypes.registerType(this.pine);
        treeTypes.registerType(this.smallPine);
        treeTypes.registerType(this.scrubPine);
        treeTypes.registerType(this.simple2);
        treeTypes.registerType(this.xmas);
        treeTypes.initialize();
    }

    public void accept(Tile tile) {
        TreeLayer trees = (TreeLayer)tile.get(TreeLayer.class);
        if (trees.getVersion().getLoadVersion() >= 0L) {
            return;
        }
        log.info("Generating trees for tile:" + tile);
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        TileId id = tile.getTileId();
        Vec3i world = id.getWorld(null);
        double xCorner = world.x;
        double zCorner = world.z;
        long mapId = id.getId();
        Random rand = new Random(mapId);
        int seaLevel = 128;
        short treeLine = 500;
        int spacing = 1;
        boolean[][] used = new boolean[1024][1024];
        for (int x = 1; x < 1023; x += spacing) {
            for (int z = 1; z < 1023; z += spacing) {
                double r;
                if (used[x][z]) continue;
                double xp = xCorner + (double)x;
                double zp = zCorner + (double)z;
                byte type = terrain.getType(x, z);
                short y = terrain.getElevation(x, z);
                double yp = y;
                if (y < fluid.getElevation(x, z)) continue;
                int foliageLevel = (type & 0x18) >> 3;
                int wetnessLevel = (type & 0x60) >> 5;
                int frozen = type & 0x80;
                double ecology = this.fractal.getEcology(xp, yp, zp) / 0.82;
                boolean test = false;
                double t = 0.0;
                switch (foliageLevel) {
                    case 0: {
                        break;
                    }
                    case 3: {
                        t = 0.2;
                        break;
                    }
                    case 2: {
                        t = ecology;
                        break;
                    }
                    case 1: {
                        t = 0.01 * ecology;
                    }
                }
                if (t == 0.0) continue;
                if (y > treeLine) {
                    t = 1.0E-4 * ecology;
                }
                if ((r = rand.nextDouble()) >= t) continue;
                TreeType[] types = this.baseTypes;
                if (frozen > 0 || y > treeLine) {
                    types = this.coldTypes;
                } else if (type > treeLine / 2) {
                    types = this.highTypes;
                }
                int index = rand.nextInt(types.length);
                TreeType treeType = types[index];
                Tree tree = treeType.createTree((short)x, y, (short)z, terrain, rand);
                if (tree == null || x - tree.radius < 0 || z - tree.radius < 0 || x + tree.radius > 1023 || z + tree.radius > 1023) continue;
                trees.addTree(tree);
                tree.type.markTree(tree, used);
            }
        }
    }
}

