/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.input.InputManager;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.style.ElementId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import mythruna.client.GuiState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlyOverState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(FlyOverState.class);
    private InputManager inputManager;
    private Vector2f lastCursor = new Vector2f();
    private float stationaryTime = 0.0f;
    private float flyOverTimeout = 1.0f;
    private boolean checked = false;
    private List<Function<Vector2f, String>> hitFunctions = new ArrayList<Function<Vector2f, String>>();
    private Vector2f popupPos = new Vector2f();
    private Container popup;
    private Label label;
    private float scale = 1.5f;
    private boolean active = false;
    private float hideTime = 0.0f;

    public FlyOverState() {
        this.setEnabled(false);
    }

    public void addHitFunction(Function<Vector2f, String> f) {
        this.hitFunctions.add(f);
        this.setEnabled(!this.hitFunctions.isEmpty());
    }

    public void removeHitFunction(Function<Vector2f, String> f) {
        this.hitFunctions.remove(f);
        this.setEnabled(!this.hitFunctions.isEmpty());
    }

    public void clear() {
        this.hideFlyOver();
        this.hideTime = 1.0f;
    }

    protected void initialize(Application app) {
        this.inputManager = app.getInputManager();
        ElementId base = new ElementId("flyover");
        this.popup = new Container(base.child("container"));
        this.popup.setLocalScale(this.scale);
        this.label = (Label)this.popup.addChild((Node)new Label("Text", base.child("label")), new Object[0]);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.lastCursor.set(-100.0f, -100.0f);
        this.active = false;
        this.stationaryTime = 0.0f;
        this.checked = false;
    }

    protected void onDisable() {
        this.popup.removeFromParent();
    }

    public void update(float tpf) {
        Vector2f pos = this.inputManager.getCursorPosition();
        if (this.active) {
            if (pos.distanceSquared(this.popupPos) > 25.0f) {
                this.hideFlyOver();
                this.lastCursor.set(pos);
                this.checked = false;
            }
        } else if (this.popup.getParent() != null) {
            this.hideTime += tpf;
            if (this.hideTime > this.flyOverTimeout) {
                this.popup.removeFromParent();
                this.lastCursor.set(pos);
            }
        } else if (pos.distanceSquared(this.lastCursor) > 0.0f) {
            this.lastCursor.set(pos);
            this.stationaryTime = 0.0f;
            this.checked = false;
        } else {
            this.stationaryTime += tpf;
            if (!this.checked && this.stationaryTime > this.flyOverTimeout) {
                this.checkHit(pos);
                this.checked = true;
            }
        }
    }

    protected void showFlyOver(String text, Vector2f pos) {
        log.info("Flyover:" + text);
        if (this.active && Objects.equals(text, this.label.getText())) {
            return;
        }
        this.popupPos.set(pos);
        this.active = true;
        this.label.setText(text);
        Vector3f pref = this.popup.getPreferredSize().mult(this.scale);
        this.popup.setLocalTranslation(pos.x - pref.x * 0.5f, pos.y + pref.y * 0.85f, 100.0f);
        ((GuiState)this.getState(GuiState.class)).getGuiRoot().attachChild((Spatial)this.popup);
    }

    protected void hideFlyOver() {
        this.active = false;
        this.hideTime = 0.0f;
    }

    protected void checkHit(Vector2f pos) {
        log.info("Check hit:" + pos);
        for (Function<Vector2f, String> f : this.hitFunctions) {
            String s = f.apply(pos);
            if (s == null) continue;
            this.showFlyOver(s, pos);
            return;
        }
    }
}

