/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.scene.Spatial;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.bpos.ChildPositionTransition3d;
import com.simsilica.crig.CharacterRig;
import com.simsilica.crig.es.AnimationConfig;
import com.simsilica.crig.es.LayerConfig;
import com.simsilica.crig.jme.AnimComposerRig;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.ethereal.TimeSource;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.trans.TransitionBuffer;
import mythruna.client.GameSessionState;
import mythruna.client.view.ModelViewState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterAnimationState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(CharacterAnimationState.class);
    private EntityData ed;
    private TimeSource timeSource;
    private CharacterContainer characters;

    protected void initialize(Application app) {
        this.ed = ((GameSessionState)this.getState(GameSessionState.class, true)).getEntityData();
        this.timeSource = ((GameSessionState)this.getState(GameSessionState.class, true)).getTimeSource();
        this.characters = new CharacterContainer(this.ed);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.characters.start();
    }

    public void update(float tpf) {
        long time = this.timeSource.getTime();
        this.characters.update();
        for (AnimatedMob mob : this.characters.getArray()) {
            mob.update(time);
        }
    }

    protected void onDisable() {
        this.characters.stop();
    }

    private class CharacterContainer
    extends EntityContainer<AnimatedMob> {
        public CharacterContainer(EntityData ed) {
            super(ed, new Class[]{BodyPosition.class, AnimationConfig.class});
        }

        public AnimatedMob[] getArray() {
            return (AnimatedMob[])super.getArray();
        }

        protected AnimatedMob addObject(Entity e) {
            AnimatedMob am = new AnimatedMob(e);
            log.info("addObject(" + e.getId() + ")");
            this.updateObject(am, e);
            return am;
        }

        protected void updateObject(AnimatedMob object, Entity e) {
            object.update((AnimationConfig)e.get(AnimationConfig.class));
        }

        protected void removeObject(AnimatedMob object, Entity e) {
            log.info("removeObject(" + e.getId() + ")");
        }
    }

    private class AnimatedMob {
        private Entity animEntity;
        private AnimationConfig config;
        private BodyPosition bpos;
        private TransitionBuffer<ChildPositionTransition3d> buffer;
        private Vec3d times = new Vec3d();
        private Quatd mixes = new Quatd();
        private Spatial model;
        private Spatial test;
        private CharacterRig rig;

        public AnimatedMob(Entity animEntity) {
            this.animEntity = animEntity;
            this.config = (AnimationConfig)animEntity.get(AnimationConfig.class);
            this.bpos = (BodyPosition)animEntity.get(BodyPosition.class);
            this.bpos.initialize(animEntity.getId(), 12);
            this.buffer = this.bpos.getBuffer();
        }

        protected void retrieveRig() {
            this.model = ((ModelViewState)CharacterAnimationState.this.getState(ModelViewState.class, true)).getModel(this.config.getTarget());
            if (this.model == null) {
                log.warn("Model not found for:" + this.config.getTarget());
                return;
            }
            this.rig = AnimComposerRig.createRig((Spatial)this.model);
        }

        public void update(AnimationConfig config) {
            this.config = config;
            this.times.set(-1.0, -1.0, -1.0);
            this.mixes.set(-1.0, -1.0, -1.0, -1.0);
        }

        public void update(long time) {
            ChildPositionTransition3d trans;
            if (this.rig == null) {
                this.retrieveRig();
                if (this.rig == null) {
                    return;
                }
            }
            if ((trans = (ChildPositionTransition3d)this.buffer.getTransition(time)) != null) {
                Quatd quat = trans.getRotation(time, true);
                this.updateMixes(quat);
                Vec3d start = trans.getStartPosition();
                if (start == null) {
                    return;
                }
                Vec3d end = trans.getEndPosition();
                for (int i = 0; i < 3; ++i) {
                    double v2;
                    double v1 = start.get(i);
                    if (v1 == (v2 = end.get(i)) || !(Math.abs(v2 - v1) > 0.5)) continue;
                    start.set(i, v2);
                }
                Vec3d pos = trans.getPosition(time, true);
                this.updateTimes(pos);
            }
        }

        protected void updateMixes(Quatd q) {
            int mixIndex = 0;
            for (LayerConfig layer : this.config.getLayers()) {
                double val = q.get(mixIndex);
                if (this.mixes.get(mixIndex) != val) {
                    this.mixes.set(mixIndex, val);
                    String action = layer.getAction(val);
                    log.info("Setting layer action:" + action);
                    this.rig.setLayerAction(layer.getLayer(), action);
                }
                ++mixIndex;
            }
        }

        protected void updateTimes(Vec3d v) {
            int layerIndex = 0;
            for (LayerConfig layer : this.config.getLayers()) {
                double val = v.get(layerIndex);
                double orig = this.rig.getTime(layer.getLayer());
                this.times.set(layerIndex, val);
                this.rig.setTime(layer.getLayer(), val);
            }
        }
    }
}

