/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.tree;

import com.simsilica.mworld.tile.tree.TreeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeTypeIndex {
    static Logger log = LoggerFactory.getLogger(TreeTypeIndex.class);
    private static TreeTypeIndex instance = new TreeTypeIndex();
    private Map<String, TreeType> nameIndex = new HashMap<String, TreeType>();
    private List<TreeType> typeList = new ArrayList<TreeType>();
    private TreeType[] types;

    private TreeTypeIndex() {
    }

    public static TreeTypeIndex getInstance() {
        return instance;
    }

    public boolean isInitialized() {
        return this.types != null;
    }

    protected void checkInitialized(boolean desiredState) {
        if (desiredState == (this.types != null)) {
            return;
        }
        if (this.types != null) {
            throw new IllegalStateException("Type list already initialized");
        }
        throw new IllegalStateException("Type list not initialized");
    }

    public synchronized void registerType(TreeType type) {
        this.checkInitialized(false);
        TreeType existing = this.nameIndex.get(type.getName());
        if (existing != null) {
            throw new IllegalArgumentException("Type already exists for name:" + type.getName());
        }
        if (this.typeList.size() >= Short.MAX_VALUE) {
            throw new IllegalStateException("Type list exceeds maximum size:32767");
        }
        type.setIndex((short)this.typeList.size());
        log.info("registeredType:" + type + "  at index:" + this.typeList.size());
        this.typeList.add(type);
    }

    public synchronized void initialize() {
        log.info("intialize()");
        this.checkInitialized(false);
        this.types = this.typeList.toArray(new TreeType[0]);
        assert (this.types.length != 0) : "Cannot initialize the tree type index with no tree types";
        for (TreeType type : this.types) {
            type.initialize(this);
        }
        log.info("initialized with:" + this.types.length + " types");
    }

    public TreeType getType(int index) {
        return this.getType((short)index);
    }

    public TreeType getType(short index) {
        this.checkInitialized(true);
        return this.types[index];
    }

    public int size() {
        return this.types != null ? this.types.length : this.typeList.size();
    }

    public TreeType[] getTypes() {
        return this.types;
    }
}

