/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.style.ElementId;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpPopup {
    static Logger log = LoggerFactory.getLogger(HelpPopup.class);
    private static Set<String> visited = new HashSet<String>();
    private Spatial parent;
    private Vector3f min = new Vector3f();
    private Vector3f max = new Vector3f();
    private String title;
    private String text;
    private Container window;
    private Label titleLabel;
    private Label textLabel;
    private Function<Vector3f, Vector3f> worldToUi;
    private Button activator;
    private boolean showHelp;

    public HelpPopup(Spatial parent, Function<Vector3f, Vector3f> worldToUi, String title) {
        this.parent = parent;
        this.worldToUi = worldToUi;
        this.title = title;
        this.activator = new Button("Help"){

            public void updateLogicalState(float tpf) {
                HelpPopup.this.resetActivatorLocation();
                super.updateLogicalState(tpf);
            }
        };
        this.activator.addClickCommands(b -> this.open());
        ElementId base = new ElementId("helpPopup");
        this.window = new Container((GuiLayout)new BorderLayout());
        this.window.setBorder((GuiComponent)new QuadBackgroundComponent(new ColorRGBA(0.0f, 0.0f, 0.2f, 0.9f)));
        this.window.setLocalScale(1.5f);
        this.titleLabel = (Label)this.window.addChild((Node)new Label(title, base.child("window.title")), new Object[]{BorderLayout.Position.North});
        this.textLabel = (Label)this.window.addChild((Node)new Label("", base.child("label")), new Object[]{BorderLayout.Position.Center});
        this.window.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "close")), new Object[]{BorderLayout.Position.South});
    }

    public void attach() {
        Node gui = GuiGlobals.getInstance().getPopupState().getGuiNode();
        gui.attachChild((Spatial)this.activator);
        if (visited.add(this.title)) {
            this.showHelp = true;
        }
    }

    public void detach() {
        this.close();
        this.activator.removeFromParent();
    }

    public void setText(String text) {
        this.text = text;
        this.textLabel.setText(text);
    }

    public void setText(String ... lines) {
        this.text = String.join((CharSequence)"\n", lines);
        this.textLabel.setText(this.text);
    }

    public String getText() {
        return this.text;
    }

    public void release() {
        this.activator.removeFromParent();
    }

    public void open() {
        this.showHelp = true;
    }

    public void close() {
        this.window.removeFromParent();
    }

    protected boolean updateMinMax() {
        if (this.parent == null) {
            this.min.set(this.worldToUi.apply(new Vector3f()));
            this.max.set(this.min);
            return true;
        }
        BoundingVolume bounds = this.parent.getWorldBound();
        Vector3f center = bounds.getCenter();
        boolean changed = false;
        if (bounds instanceof BoundingBox) {
            BoundingBox bb = (BoundingBox)bounds;
            Vector3f v1 = this.worldToUi.apply(bb.getMin(null));
            Vector3f v2 = this.worldToUi.apply(bb.getMax(null));
            this.min.set(v1).minLocal(v2);
            this.max.set(v1).maxLocal(v2);
            changed = true;
        } else if (bounds instanceof BoundingSphere) {
            BoundingSphere bs = (BoundingSphere)bounds;
            float radius = bs.getRadius();
            Vector3f v1 = this.worldToUi.apply(center.subtract(radius, radius, radius));
            Vector3f v2 = this.worldToUi.apply(center.add(radius, radius, radius));
            this.min.set(v1).minLocal(v2);
            this.max.set(v1).maxLocal(v2);
            changed = true;
        } else {
            log.warn("Incompatible bounding volume:" + bounds);
        }
        return changed;
    }

    protected void resetActivatorLocation() {
        this.updateMinMax();
        Vector3f size = this.activator.getSize();
        float z = 0.0f;
        this.activator.setLocalTranslation(this.max.x - size.x, this.max.y + size.y, z);
        if (this.showHelp) {
            this.showHelp = false;
            Node gui = GuiGlobals.getInstance().getPopupState().getGuiNode();
            gui.attachChild((Spatial)this.window);
        }
        if (this.window.getParent() != null) {
            Vector2f guiSize = GuiGlobals.getInstance().getPopupState().getGuiSize();
            Vector3f pref = this.window.getPreferredSize();
            pref = pref.mult(1.5f);
            float x = Math.min(guiSize.x - pref.x, this.max.x);
            float y = Math.max(pref.y, this.max.y + size.y);
            this.window.setLocalTranslation(x, y, z);
        }
    }
}

