/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.tree;

import com.simsilica.mworld.tile.tree.AtlasCell;
import com.simsilica.mworld.tile.tree.Tree;
import com.simsilica.mworld.tile.tree.TreeType;
import com.simsilica.mworld.tile.tree.TreeTypeIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTreeType
implements TreeType {
    static Logger log = LoggerFactory.getLogger(AbstractTreeType.class);
    private String name;
    private short index;
    private AtlasCell atlasCell;

    protected AbstractTreeType(String name, AtlasCell atlasCell) {
        this.name = name;
        this.atlasCell = atlasCell;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public void setIndex(short index) {
        this.index = index;
    }

    @Override
    public final short getIndex() {
        return this.index;
    }

    @Override
    public AtlasCell getAtlasCell(Tree tree) {
        return this.atlasCell;
    }

    @Override
    public void initialize(TreeTypeIndex treeTypes) {
    }

    @Override
    public boolean markTree(Tree tree, boolean[][] used) {
        int xMin = Math.max(0, tree.x - 1);
        int zMin = Math.max(0, tree.z - 1);
        int xMax = Math.min(1023, tree.x + 1);
        int zMax = Math.min(1023, tree.z + 1);
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                used[x][z] = true;
            }
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name:" + this.name + ", index:" + this.index + "]";
    }
}

