/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.tree;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.db.SpoolingObjectDb;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import com.simsilica.mworld.tile.tree.TreeLayer;
import com.simsilica.mworld.tile.tree.TreeLayerProtocol;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeLayerDb
extends SpoolingObjectDb<TileId, TreeLayer> {
    static Logger log = LoggerFactory.getLogger(TreeLayerDb.class);
    private File root;
    private TreeLayerProtocol protocol;

    public TreeLayerDb(File root, TreeLayerProtocol protocol) {
        this.root = root;
        this.protocol = protocol;
    }

    public TileFunction getLoadFunction() {
        return new TileFunction(){

            @Override
            public void accept(Tile tile) {
                TreeLayer layer = tile.get(TreeLayer.class);
                if (layer != null) {
                    throw new IllegalStateException("Tile:" + tile.getId() + " already has tree layer");
                }
                layer = (TreeLayer)TreeLayerDb.this.get(tile.getId());
                tile.put(TreeLayer.class, layer);
            }
        };
    }

    public TileFunction getSaveFunction() {
        return new TileFunction(){

            @Override
            public void accept(Tile tile) {
                TreeLayer layer = tile.get(TreeLayer.class);
                if (layer.getVersion().isChanged()) {
                    log.info("Storing:" + layer);
                    TreeLayerDb.this.update(layer.getTileId(), layer);
                }
            }
        };
    }

    protected File toFile(TileId id) {
        Vec3i sedectile = id.getSedectileId().getCell(null);
        String path = sedectile.x + "/" + sedectile.z;
        File dir = new File(this.root, path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String name = id.getId() + ".trees";
        return new File(dir, name);
    }

    @Override
    protected TreeLayer loadObject(TileId id) {
        File file = this.toFile(id);
        if (file.exists()) {
            return this.readObjectFile(id, file);
        }
        return new TreeLayer(id, new DataVersion(0L, -1L));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected TreeLayer readObjectFile(TileId id, File file) {
        try (BufferedInputStream in = new BufferedInputStream(new GZIPInputStream(new FileInputStream(file)));){
            TreeLayer result = this.protocol.read(in);
            assert (id.equals(result.getTileId()));
            TreeLayer treeLayer = result;
            return treeLayer;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading object:" + id + " from:" + file, e);
        }
    }

    @Override
    protected void storeObject(TileId id, TreeLayer value) {
        File file = this.toFile(id);
        this.writeObjectFile(id, file, value);
        value.getVersion().resetChanged(System.currentTimeMillis());
    }

    protected void writeObjectFile(TileId id, File file, TreeLayer value) {
        long start = System.nanoTime();
        try (BufferedOutputStream out = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file)));){
            this.protocol.write(value, out);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing object:" + id + " to:" + file, e);
        }
        long end = System.nanoTime();
        log.info("Wrote [" + id + "] in " + (double)(end - start) / 1000000.0 + " ms");
    }
}

