/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.style;

import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.style.Styles;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class StyleLoader {
    private List<CompiledScript> api = new ArrayList<CompiledScript>();
    private Map<CompiledScript, Object> sources = new HashMap<CompiledScript, Object>();
    private ScriptEngine engine;
    private Compilable compiler;
    private Bindings bindings;
    private Styles styles;
    private boolean initialized = false;

    public StyleLoader() {
        this(GuiGlobals.getInstance(), GuiGlobals.getInstance().getStyles(), "/com/simsilica/lemur/style/StyleApi.groovy");
    }

    public StyleLoader(Styles styles) {
        this(GuiGlobals.getInstance(), styles, "/com/simsilica/lemur/style/StyleApi.groovy");
    }

    public StyleLoader(GuiGlobals globals, Styles styles, Object ... apiScripts) {
        this.styles = styles;
        ScriptEngineManager factory = new ScriptEngineManager();
        this.engine = factory.getEngineByName("groovy");
        if (this.engine == null) {
            throw new RuntimeException("Groovy scripting engine not available.");
        }
        this.compiler = (Compilable)((Object)this.engine);
        this.bindings = this.engine.createBindings();
        this.bindings.put("styles", (Object)styles);
        this.bindings.put("gui", (Object)globals);
        this.compileApi(apiScripts);
    }

    protected void compileApi(Object ... apiScripts) {
        for (Object o : apiScripts) {
            try {
                if (o instanceof String) {
                    this.compileApiResource((String)o);
                    continue;
                }
                if (!(o instanceof File)) continue;
                this.compileApiFile((File)o);
            }
            catch (ScriptException e) {
                throw new RuntimeException("Error compiling script:" + o, e);
            }
        }
    }

    protected void addApiScript(CompiledScript script, String source) {
        this.api.add(script);
        this.sources.put(script, source);
    }

    protected void compileApiResource(String s) throws ScriptException {
        InputStream rawIn = this.getClass().getResourceAsStream(s);
        if (rawIn == null) {
            throw new ScriptException("Script resource not found for:" + s);
        }
        InputStreamReader in = new InputStreamReader(rawIn);
        this.addApiScript(this.compiler.compile(in), "resource:" + s);
    }

    protected void compileApiFile(File f) throws ScriptException {
        try {
            FileReader in = new FileReader(f);
            this.addApiScript(this.compiler.compile(in), "file:" + f);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    public void setBinding(String name, Object value) {
        this.bindings.put(name, value);
    }

    public Object getBinding(String name) {
        return this.bindings.get(name);
    }

    public void initializeApi() {
        for (CompiledScript script : this.api) {
            try {
                script.eval(this.bindings);
            }
            catch (ScriptException e) {
                throw new RuntimeException("Error running:" + script + " from:" + this.sources.get(script), e);
            }
        }
        this.initialized = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadStyleResource(String s) {
        if (!this.initialized) {
            this.initializeApi();
        }
        try {
            InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream(s));
            CompiledScript script = this.compiler.compile(in);
            int before = this.bindings.size();
            Object result = script.eval(this.bindings);
            if (before == this.bindings.size()) return;
        }
        catch (ScriptException e) {
            throw new RuntimeException("Error running resource:" + s, e);
        }
    }

    public void loadStyle(URL u) {
        try {
            this.loadStyle(u.toString(), new InputStreamReader(u.openStream()));
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening stream for:" + u, e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadStyle(String name, Reader in) {
        if (!this.initialized) {
            this.initializeApi();
        }
        try {
            CompiledScript script = this.compiler.compile(in);
            int before = this.bindings.size();
            Object result = script.eval(this.bindings);
            if (before == this.bindings.size()) return;
        }
        catch (ScriptException e) {
            throw new RuntimeException("Error running resource:" + name, e);
        }
    }
}

