/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.action;

import com.simsilica.action.ActionEnvironment;
import com.simsilica.action.ObjectAction;
import com.simsilica.action.ObjectType;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionContext<A, T> {
    static Logger log = LoggerFactory.getLogger(ActionContext.class);
    private ObjectType<A, T> type;
    private T target;

    public ActionContext(ObjectType<A, T> type, T target) {
        this.type = type;
        this.target = target;
    }

    public ObjectType<A, T> getType() {
        return this.type;
    }

    public T getTarget() {
        return this.target;
    }

    protected ObjectAction<A, T> resolveAction(boolean failFast, String actionName, Object ... args) {
        ObjectAction<A, T> action = this.type.findAction(actionName, args);
        if (action == null && failFast) {
            throw new IllegalArgumentException("Action not found for:" + actionName + ", args:" + Arrays.asList(args) + "\nSimilar actions:" + this.type.findNamedActions(actionName));
        }
        return action;
    }

    public boolean canRun(ActionEnvironment<A, T> env, String actionName, Object ... args) {
        ObjectAction<A, T> action = this.resolveAction(false, actionName, args);
        if (action == null) {
            return false;
        }
        return action.canRun(env, this, args);
    }

    public boolean run(ActionEnvironment<A, T> env, String actionName, Object ... args) {
        ObjectAction<A, T> action = this.resolveAction(true, actionName, args);
        return action.run(env, this, args);
    }

    public boolean runIfExists(ActionEnvironment<A, T> env, String actionName, Object ... args) {
        ObjectAction<A, T> action = this.resolveAction(false, actionName, args);
        if (action == null) {
            return false;
        }
        return action.run(env, this, args);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[type:" + this.type + ", target:" + this.target + "]";
    }
}

