/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.action;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.simsilica.action.ObjectAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectType<A, T> {
    static Logger log = LoggerFactory.getLogger(ObjectType.class);
    private String name;
    private ListMultimap<String, ObjectAction<A, T>> actionIndex;
    private Map<String, Object> vars = new HashMap<String, Object>();

    @SafeVarargs
    public ObjectType(String name, ObjectAction<A, T> ... actions) {
        this(name, Arrays.asList(actions));
    }

    public ObjectType(String name, List<ObjectAction<A, T>> actions) {
        this.name = name;
        this.actionIndex = MultimapBuilder.linkedHashKeys().arrayListValues().build();
        for (ObjectAction<A, T> action : actions) {
            this.actionIndex.put((Object)action.getName(), action);
        }
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getActionNames() {
        return Collections.unmodifiableSet(this.actionIndex.keySet());
    }

    public void setTypeVar(String name, Object value) {
        this.vars.put(name, value);
    }

    public <T> T getTypeVar(String name, T defaultValue) {
        Object result = this.vars.get(name);
        return (T)(result == null ? defaultValue : result);
    }

    public List<ObjectAction<A, T>> getContextActions() {
        ArrayList<ObjectAction<A, T>> results = new ArrayList<ObjectAction<A, T>>();
        Object[] noArgs = new Object[]{};
        for (ObjectAction action : this.actionIndex.values()) {
            if (!this.matches(action.getParamTypes(), noArgs) || !Character.isUpperCase(action.getName().charAt(0))) continue;
            results.add(action);
        }
        return results;
    }

    public ObjectAction<A, T> findAction(String name, Object ... args) {
        for (ObjectAction action : this.actionIndex.get((Object)name)) {
            if (!this.matches(action.getParamTypes(), args)) continue;
            return action;
        }
        return null;
    }

    public List<ObjectAction<A, T>> findNamedActions(String name) {
        List results = this.actionIndex.get((Object)name);
        return Collections.unmodifiableList(results);
    }

    public List<ObjectAction<A, T>> findTypedActions(Object ... args) {
        ArrayList<ObjectAction<A, T>> results = new ArrayList<ObjectAction<A, T>>();
        for (ObjectAction action : this.actionIndex.values()) {
            if (!this.matches(action.getParamTypes(), args)) continue;
            results.add(action);
        }
        return results;
    }

    protected boolean matches(Class[] types, Object[] args) {
        if (types.length != args.length) {
            return false;
        }
        int count = types.length;
        for (int i = 0; i < count; ++i) {
            if (args[i] == null || types[i].isInstance(args[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name:" + this.name + "]";
    }
}

