/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.sim;

import com.simsilica.sim.GameSystemManager;
import com.simsilica.sim.LegacyLoopSleepStrategy;
import com.simsilica.sim.LoopSleepStrategy;
import com.simsilica.sim.SimTime;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameLoop {
    public static final long FPS_60 = 16666667L;
    static Logger log = LoggerFactory.getLogger(GameLoop.class);
    private final GameSystemManager systems;
    private final Runner loop = new Runner();
    private long updateRate;
    private LoopSleepStrategy sleepStrategy = new LegacyLoopSleepStrategy(16666667L);
    private AtomicLong lastStepTime = new AtomicLong();
    private SimTime safeTime = new SimTime();

    public GameLoop(GameSystemManager systems) {
        this(systems, 16666667L);
    }

    public GameLoop(GameSystemManager systems, long updateRateNanos) {
        this(systems, updateRateNanos, null);
    }

    public GameLoop(GameSystemManager systems, long updateRateNanos, Long idleSleepTime) {
        this.systems = systems;
        this.updateRate = updateRateNanos;
        this.sleepStrategy.setUpdateRateNanos(updateRateNanos);
        this.setIdleSleepTime(idleSleepTime);
    }

    public GameSystemManager getGameSystemManager() {
        return this.systems;
    }

    public SimTime getStepTime() {
        if (this.safeTime.getTime() != this.lastStepTime.get()) {
            this.safeTime.setCurrentTime(this.lastStepTime.get());
        }
        return this.safeTime;
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean wait) {
        this.loop.start();
        if (wait) {
            this.loop.waitForInitialized();
        }
    }

    public void stop() {
        this.loop.close();
    }

    @Deprecated
    public final void setIdleSleepTime(Long millis) {
        long idleSleepTime = millis == null ? (this.updateRate > 16666667L ? 1L : 0L) : millis;
        if (this.sleepStrategy instanceof LegacyLoopSleepStrategy) {
            ((LegacyLoopSleepStrategy)this.sleepStrategy).setIdleSleepTime(idleSleepTime);
        } else {
            log.warn("Directly setting idleSleepTime only works with legacy sleep strategy");
        }
    }

    public Long getIdleSleepTime() {
        if (this.sleepStrategy instanceof LegacyLoopSleepStrategy) {
            return ((LegacyLoopSleepStrategy)this.sleepStrategy).getIdleSleepTime();
        }
        return null;
    }

    public void setLoopSleepStrategy(LoopSleepStrategy sleepStrategy) {
        if (sleepStrategy == null) {
            throw new IllegalArgumentException("Sleep strategy cannot be null");
        }
        this.sleepStrategy = sleepStrategy;
        sleepStrategy.setUpdateRateNanos(this.updateRate);
    }

    public LoopSleepStrategy getLoopSleepStrategy() {
        return this.sleepStrategy;
    }

    protected class Runner
    extends Thread {
        private final AtomicBoolean go = new AtomicBoolean(true);
        private Throwable startupFailure;
        private boolean initialized;

        public Runner() {
            this.setName("GameLoopThread");
        }

        public void close() {
            this.go.set(false);
            try {
                this.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for game loop thread to complete.", e);
            }
        }

        public synchronized void waitForInitialized() {
            while (!this.initialized && this.startupFailure == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted waiting for initialize", e);
                }
            }
            if (this.startupFailure != null) {
                throw new RuntimeException("Failed to initialize game loop thread", this.startupFailure);
            }
        }

        protected synchronized void initialized() {
            this.initialized = true;
            this.notifyAll();
        }

        protected synchronized void failed(Throwable t) {
            this.startupFailure = t;
            this.notifyAll();
        }

        @Override
        public void run() {
            try {
                if (!GameLoop.this.systems.isInitialized()) {
                    GameLoop.this.systems.initialize();
                }
                if (!GameLoop.this.systems.isStarted()) {
                    GameLoop.this.systems.start();
                }
                this.initialized();
            }
            catch (RuntimeException e) {
                log.error("Error starting game loop", (Throwable)e);
                this.failed(e);
                return;
            }
            long lastTime = System.nanoTime();
            long lastUpdateDelta = 0L;
            while (this.go.get()) {
                long time = System.nanoTime();
                long delta = time - lastTime;
                if (delta >= GameLoop.this.updateRate) {
                    lastTime = time;
                    GameLoop.this.systems.update();
                    lastUpdateDelta = System.nanoTime() - time;
                    GameLoop.this.lastStepTime.set(GameLoop.this.systems.getStepTime().getTime());
                    continue;
                }
                try {
                    GameLoop.this.sleepStrategy.loopSleep(time, delta, lastTime, lastUpdateDelta);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted sleeping", e);
                }
            }
            GameLoop.this.systems.stop();
            GameLoop.this.systems.terminate();
        }
    }
}

