/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.net.client;

import com.jme3.network.service.AbstractClientService;
import com.jme3.network.service.ClientServiceManager;
import com.jme3.network.service.rmi.RmiClientService;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.CellChangeEvent;
import com.simsilica.mworld.CellChangeListener;
import com.simsilica.mworld.Coordinates;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafChangeEvent;
import com.simsilica.mworld.LeafChangeListener;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.LightData;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.base.LeafChangeListenerSupport;
import com.simsilica.mworld.net.WorldDataListener;
import com.simsilica.mworld.net.WorldDataSession;
import com.simsilica.mworld.net.client.RemoteWorldData;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.TileChangeEvent;
import com.simsilica.mworld.tile.TileListener;
import com.simsilica.mworld.tile.pc.PointCloudLayer;
import com.simsilica.mworld.tile.tree.TreeLayer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldClientService
extends AbstractClientService
implements World {
    static Logger log = LoggerFactory.getLogger(WorldClientService.class);
    private RmiClientService rmiService;
    private int channel;
    private WorldDataSession delegate;
    private RemoteWorldData remoteDb;
    private WorldSessionCallback sessionCallback = new WorldSessionCallback();
    private List<CellChangeListener> cellListeners = new ArrayList<CellChangeListener>();
    private CellChangeListener[] cellListenerArray;
    private CellChangeListener[] emptyCellListenerArray = new CellChangeListener[0];
    private LeafChangeListenerSupport leafListeners = new LeafChangeListenerSupport();
    private CopyOnWriteArrayList<TileListener> tileListeners = new CopyOnWriteArrayList();

    public WorldClientService() {
        this(-2);
    }

    public WorldClientService(int channel) {
        this.channel = channel;
        this.remoteDb = new RemoteWorldData();
    }

    @Override
    public void addLeafChangeListener(LeafChangeListener l) {
        this.leafListeners.add(l);
    }

    @Override
    public void removeLeafChangeListener(LeafChangeListener l) {
        this.leafListeners.remove(l);
    }

    @Override
    public void addCellChangeListener(CellChangeListener l) {
        this.cellListeners.add(l);
        this.cellListenerArray = null;
    }

    @Override
    public void removeCellChangeListener(CellChangeListener l) {
        this.cellListeners.remove(l);
        this.cellListenerArray = null;
    }

    protected CellChangeListener[] getCellListenerArray() {
        if (this.cellListenerArray == null) {
            this.cellListenerArray = this.cellListeners.toArray(this.emptyCellListenerArray);
        }
        return this.cellListenerArray;
    }

    protected void fireCellChanged(CellChangeEvent event) {
        if (log.isTraceEnabled()) {
            log.trace("fireCellChanged(" + event + ")");
        }
        for (CellChangeListener l : this.getCellListenerArray()) {
            l.cellChanged(event);
        }
    }

    protected void fireTileChanged(TileChangeEvent event) {
        for (TileListener l : this.tileListeners) {
            l.tileChanged(event);
        }
    }

    @Override
    public int getMaxY() {
        return this.remoteDb.getMaxY();
    }

    @Override
    public int setWorldCell(Vec3d world, int cellType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getWorldCell(Vec3d world) {
        if (world.y >= (double)this.getMaxY()) {
            return 0;
        }
        LeafId id = LeafId.fromWorld(world);
        LeafData leaf = this.getLeaf(id);
        if (leaf == null) {
            return -1;
        }
        int x = Coordinates.worldToCell(world.x) - leaf.getInfo().location.x;
        int y = Coordinates.worldToCell(world.y) - leaf.getInfo().location.y;
        int z = Coordinates.worldToCell(world.z) - leaf.getInfo().location.z;
        return leaf.getCell(x, y, z);
    }

    @Override
    public LeafData getWorldLeaf(Vec3d worldLocation) {
        return this.getLeaf(LeafId.fromWorld(worldLocation));
    }

    @Override
    public LeafData getLeaf(LeafId leafId) {
        Vec3i loc = leafId.getWorld(null);
        if (loc.y >= this.getMaxY()) {
            return null;
        }
        return this.remoteDb.getLeaf(leafId);
    }

    @Override
    public LightData getLight(LeafId leafId) {
        Vec3i loc = leafId.getWorld(null);
        if (loc.y >= this.getMaxY()) {
            return null;
        }
        return this.remoteDb.getLight(leafId);
    }

    @Override
    public FluidData getFluid(LeafId leafId) {
        Vec3i loc = leafId.getWorld(null);
        if (loc.y >= this.getMaxY()) {
            return null;
        }
        return this.remoteDb.getFluid(leafId);
    }

    @Override
    public TerrainImage getTerrainImage(TileId id, TerrainImageType type, Resolution res) {
        return this.remoteDb.loadTerrainImage(id, type, res);
    }

    @Override
    public TreeLayer getTrees(TileId id, Resolution res) {
        return this.remoteDb.loadTrees(id, res);
    }

    @Override
    public PointCloudLayer getPointCloudLayer(TileId id, Resolution res) {
        return this.remoteDb.getPointCloudLayer(id, res);
    }

    @Override
    public void addTileListener(TileListener l) {
        this.tileListeners.add(l);
    }

    @Override
    public void removeTileListener(TileListener l) {
        this.tileListeners.remove(l);
    }

    protected void onInitialize(ClientServiceManager s) {
        log.debug("onInitialize(" + s + ") channel:" + this.channel);
        this.rmiService = (RmiClientService)this.getService(RmiClientService.class);
        if (this.rmiService == null) {
            throw new RuntimeException("WorldClientService requires RMI service");
        }
        log.debug("Sharing session callback.");
        this.rmiService.share((byte)this.channel, (Object)this.sessionCallback, WorldDataListener.class);
    }

    public void start() {
        log.debug("start()");
        super.start();
        this.remoteDb.start(this.getDelegate());
    }

    private WorldDataSession getDelegate() {
        if (this.delegate == null) {
            this.delegate = (WorldDataSession)this.rmiService.getRemoteObject(WorldDataSession.class);
            log.debug("delegate:" + this.delegate);
            if (this.delegate == null) {
                throw new RuntimeException("No chat session found");
            }
        }
        return this.delegate;
    }

    private class WorldSessionCallback
    implements WorldDataListener {
        private WorldSessionCallback() {
        }

        @Override
        public void cellChanged(long leafId, byte[] eventData) {
            CellChangeEvent event = WorldClientService.this.remoteDb.cellChanged(leafId, eventData);
            if (event != null) {
                WorldClientService.this.fireCellChanged(event);
            }
        }

        @Override
        public void leafChanged(long leafId, long leafVersion) {
            LeafChangeEvent event = new LeafChangeEvent(new LeafId(leafId), leafVersion);
            log.info("leafChanged(" + event + ")");
            WorldClientService.this.remoteDb.applyChange(event);
            WorldClientService.this.leafListeners.fireLeafChanged(event);
        }

        @Override
        public void tileChanged(Class dataType, long tileId, long dataVersion, Resolution res) {
            TileChangeEvent event = WorldClientService.this.remoteDb.tileChanged(dataType, tileId, dataVersion, res);
            if (event != null) {
                WorldClientService.this.fireTileChanged(event);
            }
        }

        @Override
        public void partReceived(long requestId, byte part, byte total, byte[] data) {
            WorldClientService.this.remoteDb.partReceived(requestId, part, total, data);
        }
    }
}

