/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.net.server;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.jme3.network.HostedConnection;
import com.jme3.network.serializing.Serializer;
import com.jme3.network.serializing.serializers.EnumSerializer;
import com.jme3.network.serializing.serializers.FieldSerializer;
import com.jme3.network.service.AbstractHostedConnectionService;
import com.jme3.network.service.HostedServiceManager;
import com.jme3.network.service.rmi.RmiHostedService;
import com.jme3.network.service.rmi.RmiRegistry;
import com.simsilica.mworld.CellChangeEvent;
import com.simsilica.mworld.CellChangeListener;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafChangeEvent;
import com.simsilica.mworld.LeafChangeListener;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.LightData;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.io.ProtocolSerializers;
import com.simsilica.mworld.net.WorldDataListener;
import com.simsilica.mworld.net.WorldDataSession;
import com.simsilica.mworld.net.msg.NullSerializer;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.TileChangeEvent;
import com.simsilica.mworld.tile.TileListener;
import com.simsilica.mworld.tile.pc.PointCloudLayer;
import com.simsilica.mworld.tile.tree.TreeLayer;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldHostedService
extends AbstractHostedConnectionService {
    static Logger log = LoggerFactory.getLogger(WorldHostedService.class);
    private static final String ATTRIBUTE_SESSION = "world.session";
    private RmiHostedService rmiService;
    private int channel;
    private World world;
    private ThreadPoolExecutor workers;
    private ProtocolSerializers protocols = new ProtocolSerializers();

    public WorldHostedService(World world) {
        this(world, -2);
    }

    public WorldHostedService(World world, int channel) {
        this.channel = channel;
        this.world = world;
        Serializer.registerClass(CellChangeEvent.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(LeafChangeEvent.class, (Serializer)new FieldSerializer());
        Serializer.registerClass(TerrainImageType.class, (Serializer)new EnumSerializer());
        Serializer.registerClass(Resolution.class, (Serializer)new EnumSerializer());
        Serializer.registerClass(TerrainImage.class, (Serializer)NullSerializer.INSTANCE);
        Serializer.registerClass(PointCloudLayer.class, (Serializer)NullSerializer.INSTANCE);
        this.workers = this.createThreadPool(1000, 4);
    }

    protected ThreadPoolExecutor createThreadPool(int maxRequests, int poolSize) {
        LinkedBlockingDeque<Runnable> queue = new LinkedBlockingDeque<Runnable>(maxRequests);
        ThreadFactory tf = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("world-host-pool-%d").setUncaughtExceptionHandler((t, e) -> log.error("uncaught exception", e)).build();
        return new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, queue, tf, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    protected WorldDataSessionImpl getWorldSession(HostedConnection conn) {
        return (WorldDataSessionImpl)conn.getAttribute(ATTRIBUTE_SESSION);
    }

    protected void onInitialize(HostedServiceManager s) {
        this.rmiService = (RmiHostedService)this.getService(RmiHostedService.class);
        if (this.rmiService == null) {
            throw new RuntimeException("WorldHostedService requires an RMI service.");
        }
    }

    public void startHostingOnConnection(HostedConnection conn) {
        log.debug("startHostingOnConnection(" + conn + ") channel:" + this.channel);
        WorldDataSessionImpl session = new WorldDataSessionImpl(conn);
        conn.setAttribute(ATTRIBUTE_SESSION, (Object)session);
        RmiRegistry rmi = this.rmiService.getRmiRegistry(conn);
        rmi.share((byte)this.channel, (Object)session, WorldDataSession.class);
    }

    public void stopHostingOnConnection(HostedConnection conn) {
        log.debug("stopHostingOnConnection(" + conn + ")");
        WorldDataSessionImpl session = this.getWorldSession(conn);
        if (session != null) {
            conn.setAttribute(ATTRIBUTE_SESSION, null);
            session.cleanup();
        }
    }

    private class WorldDataSessionImpl
    implements WorldDataSession,
    CellChangeListener,
    LeafChangeListener,
    TileListener {
        private HostedConnection conn;
        private WorldDataListener callback;

        public WorldDataSessionImpl(HostedConnection conn) {
            this.conn = conn;
        }

        public void cleanup() {
            WorldHostedService.this.world.removeCellChangeListener(this);
        }

        protected WorldDataListener getCallback() {
            if (this.callback == null) {
                RmiRegistry rmi = WorldHostedService.this.rmiService.getRmiRegistry(this.conn);
                this.callback = (WorldDataListener)rmi.getRemoteObject(WorldDataListener.class);
                if (this.callback == null) {
                    throw new RuntimeException("Unable to locate client callback for WorldDataListener");
                }
                WorldHostedService.this.world.addCellChangeListener(this);
                WorldHostedService.this.world.addLeafChangeListener(this);
                WorldHostedService.this.world.addTileListener(this);
            }
            return this.callback;
        }

        @Override
        public int getMaxY() {
            return WorldHostedService.this.world.getMaxY();
        }

        @Override
        public void requestLeafData(long requestId, long leafId) {
            if (log.isTraceEnabled()) {
                log.trace("requestLeafData(" + requestId + ", " + leafId + ")");
            }
            WorldHostedService.this.workers.execute(() -> {
                LeafData leaf = WorldHostedService.this.world.getLeaf(new LeafId(leafId));
                if (leaf == null) {
                    this.partReceived(requestId, (byte)0, (byte)1, null);
                    return;
                }
                List<byte[]> data = WorldHostedService.this.protocols.toPackets(leaf, 32000, true);
                byte part = 0;
                byte total = (byte)data.size();
                for (byte[] packet : data) {
                    byte by = part;
                    part = (byte)(part + 1);
                    this.partReceived(requestId, by, total, packet);
                }
            });
        }

        @Override
        public void requestLightData(long requestId, long leafId) {
            if (log.isTraceEnabled()) {
                log.trace("requestLightData(" + requestId + ", " + leafId + ")");
            }
            WorldHostedService.this.workers.execute(() -> {
                LightData value = WorldHostedService.this.world.getLight(new LeafId(leafId));
                if (value == null) {
                    this.partReceived(requestId, (byte)0, (byte)1, null);
                    return;
                }
                List<byte[]> data = WorldHostedService.this.protocols.toPackets(value, 32000, true);
                byte part = 0;
                byte total = (byte)data.size();
                for (byte[] packet : data) {
                    byte by = part;
                    part = (byte)(part + 1);
                    this.partReceived(requestId, by, total, packet);
                }
            });
        }

        @Override
        public void requestFluidData(long requestId, long leafId) {
            if (log.isTraceEnabled()) {
                log.trace("requestFluidData(" + requestId + ", " + leafId + ")");
            }
            WorldHostedService.this.workers.execute(() -> {
                FluidData value = WorldHostedService.this.world.getFluid(new LeafId(leafId));
                if (value == null) {
                    this.partReceived(requestId, (byte)0, (byte)1, null);
                    return;
                }
                List<byte[]> data = WorldHostedService.this.protocols.toPackets(value, 32000, true);
                byte part = 0;
                byte total = (byte)data.size();
                for (byte[] packet : data) {
                    byte by = part;
                    part = (byte)(part + 1);
                    this.partReceived(requestId, by, total, packet);
                }
            });
        }

        @Override
        public void requestTerrainImage(long requestId, long tileId, TerrainImageType type, Resolution res) {
            if (log.isTraceEnabled()) {
                log.trace("requestTerrainImage(" + requestId + ", " + tileId + ", " + (Object)((Object)type) + ", " + (Object)((Object)res) + ")");
            }
            WorldHostedService.this.workers.execute(() -> {
                TerrainImage value = WorldHostedService.this.world.getTerrainImage(new TileId(tileId), type, res);
                if (value == null) {
                    this.partReceived(requestId, (byte)0, (byte)1, null);
                    return;
                }
                List<byte[]> data = WorldHostedService.this.protocols.toPackets(value, 32000, true);
                byte part = 0;
                byte total = (byte)data.size();
                for (byte[] packet : data) {
                    byte by = part;
                    part = (byte)(part + 1);
                    this.partReceived(requestId, by, total, packet);
                }
            });
        }

        @Override
        public void requestTrees(long requestId, long tileId, Resolution res) {
            if (log.isTraceEnabled()) {
                log.trace("requestTrees(" + requestId + ", " + tileId + ", " + (Object)((Object)res) + ")");
            }
            WorldHostedService.this.workers.execute(() -> {
                TreeLayer value = WorldHostedService.this.world.getTrees(new TileId(tileId), res);
                if (value == null) {
                    this.partReceived(requestId, (byte)0, (byte)1, null);
                    return;
                }
                List<byte[]> data = WorldHostedService.this.protocols.toPackets(value, 32000, true);
                byte part = 0;
                byte total = (byte)data.size();
                for (byte[] packet : data) {
                    byte by = part;
                    part = (byte)(part + 1);
                    this.partReceived(requestId, by, total, packet);
                }
            });
        }

        @Override
        public void requestPointCloudLayer(long requestId, long tileId, Resolution res) {
            if (log.isTraceEnabled()) {
                log.trace("requestPointCloudLayer(" + requestId + ", " + tileId + ", " + (Object)((Object)res) + ")");
            }
            WorldHostedService.this.workers.execute(() -> {
                PointCloudLayer value = WorldHostedService.this.world.getPointCloudLayer(new TileId(tileId), res);
                if (value == null) {
                    this.partReceived(requestId, (byte)0, (byte)1, null);
                    return;
                }
                List<byte[]> data = WorldHostedService.this.protocols.toPackets(value, 32000, true);
                byte part = 0;
                byte total = (byte)data.size();
                for (byte[] packet : data) {
                    byte by = part;
                    part = (byte)(part + 1);
                    this.partReceived(requestId, by, total, packet);
                }
            });
        }

        protected void partReceived(long requestId, byte part, byte total, byte[] data) {
            this.getCallback().partReceived(requestId, part, total, data);
        }

        @Override
        public void cellChanged(CellChangeEvent event) {
            if (log.isTraceEnabled()) {
                log.trace(this.conn + "->" + event);
            }
            log.info("cellChanged(" + event + ")");
            try {
                byte[] data = WorldHostedService.this.protocols.toBytes(event, false);
                this.getCallback().cellChanged(event.getLeafId().getId(), data);
            }
            catch (IOException e) {
                throw new RuntimeException("Error serializing event data for:" + event.getLeafId().getId(), e);
            }
        }

        @Override
        public void leafChanged(LeafChangeEvent event) {
            if (log.isTraceEnabled()) {
                log.trace(this.conn + "->" + event);
            }
            log.info("leafChanged(" + event + ")");
            this.getCallback().leafChanged(event.getLeafId().getId(), event.getLeafVersion());
        }

        @Override
        public void tileChanged(TileChangeEvent event) {
            log.info("tileChanged(" + event + ")");
            this.getCallback().tileChanged(event.getDataType(), event.getTileId().getId(), event.getDataVersion(), event.getResolution());
        }
    }
}

