/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.TabbedPanel;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.props.PropertyPanel;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.PostProcessingState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameSettingsState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(GameSettingsState.class);
    private Container window;
    private TabbedPanel tabs;
    private PropertyPanel rendering;
    private Container debugPanel;
    private boolean centered = true;
    private VersionedReference<TabbedPanel.Tab> currentTabRef;
    private VersionedHolder<Boolean> invertY = new VersionedHolder((Object)Boolean.FALSE);

    public GameSettingsState() {
        this.setEnabled(false);
    }

    public void setCentered(boolean centered) {
        if (this.centered == centered) {
            return;
        }
        this.centered = centered;
        this.resetPosition();
    }

    public boolean isCentered() {
        return this.centered;
    }

    public Container getDebugPanel() {
        return this.debugPanel;
    }

    public void setInvertY(boolean f) {
        this.invertY.setObject((Object)f);
    }

    public boolean getInvertY() {
        return (Boolean)this.invertY.getObject();
    }

    public VersionedReference<Boolean> createInvertYRef() {
        return this.invertY.createReference();
    }

    protected void back() {
        if (this.getState(GameSessionState.class) != null) {
            ((GameSessionState)this.getState(GameSessionState.class)).trigger("returnToGame");
        } else {
            this.setEnabled(false);
        }
    }

    protected void initialize(Application app) {
        this.window = new Container();
        this.window.setLocalScale(1.5f);
        this.tabs = (TabbedPanel)this.window.addChild((Node)new TabbedPanel(), new Object[0]);
        this.currentTabRef = this.tabs.getSelectionModel().createReference();
        this.window.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "back")), new Object[0]);
        PropertyPanel props = (PropertyPanel)this.tabs.addTab("Controls", (Panel)new PropertyPanel(null));
        props.addBooleanProperty("Invert Y", (Object)this, "invertY");
        this.tabs.addTab("Sound", (Panel)new Label("TBD"));
        this.rendering = (PropertyPanel)this.tabs.addTab("Rendering", (Panel)new PropertyPanel(null));
        PostProcessingState post = (PostProcessingState)this.getState(PostProcessingState.class, true);
        this.rendering.getContainer().addChild((Node)new Label("Post Processing:"), new Object[0]);
        this.rendering.addBooleanProperty("Enabled", (Object)post, "enabled");
        this.rendering.addFloatProperty("Bloom Intensity", (Object)post.getBloomFilter(), "bloomIntensity", 0.0f, 5.0f, 0.1f);
        this.rendering.addFloatProperty("Blur Scale", (Object)post.getBloomFilter(), "blurScale", 0.0f, 5.0f, 0.1f);
        this.rendering.addFloatProperty("Down Sampling", (Object)post.getBloomFilter(), "downSamplingFactor", 0.0f, 5000.0f, 0.1f);
        this.rendering.addFloatProperty("Exposure Cut-off", (Object)post.getBloomFilter(), "exposureCutOff", 0.0f, 1.0f, 0.1f);
        this.rendering.addFloatProperty("Exposure Power", (Object)post.getBloomFilter(), "exposurePower", 0.0f, 10.0f, 0.1f);
        this.debugPanel = (Container)this.tabs.addTab("Debug", (Panel)new Container());
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.getApplication().enqueue(() -> {
            this.resetPosition();
            GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.window, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.01f));
        });
    }

    public void update(float tpf) {
        if (this.currentTabRef.update()) {
            this.resetPosition();
        }
    }

    protected void onDisable() {
        this.window.removeFromParent();
    }

    protected void resetPosition() {
        log.info("resetPosition() centered:" + this.centered);
        if (this.centered) {
            ((GuiState)this.getState(GuiState.class)).center((Panel)this.window);
        } else {
            float height = ((GuiState)this.getState(GuiState.class)).getGuiSize().y;
            this.window.setLocalTranslation(20.0f, height - 20.0f, 0.0f);
        }
    }
}

