/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import mythruna.client.net.ConnectionState;
import mythruna.client.net.TimeState;
import mythruna.net.AccountSession;
import mythruna.world.WorldTime;
import mythruna.world.WorldTimeSource;
import mythruna.world.es.WorldAge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldTimeState
extends BaseAppState
implements WorldTimeSource {
    static Logger log = LoggerFactory.getLogger(WorldTimeState.class);
    private TimeState timeState;
    private EntityData ed;
    private EntityId worldEntity;
    private WorldTime worldTime = new WorldTime();

    public long getSimTime() {
        return this.worldTime.getRealTimeNanos();
    }

    public double getGameTime() {
        return this.worldTime.getGameTime();
    }

    public WorldTime getWorldTime() {
        return this.worldTime.clone();
    }

    protected void initialize(Application app) {
        this.timeState = (TimeState)this.getState(TimeState.class, true);
        this.ed = ((ConnectionState)this.getState(ConnectionState.class, true)).getEntityData();
        AccountSession as = ((ConnectionState)this.getState(ConnectionState.class, true)).getService(AccountSession.class);
        this.worldEntity = as.getWorldEntity();
        WorldAge offset = (WorldAge)this.ed.getComponent(this.worldEntity, WorldAge.class);
        if (offset != null) {
            log.info("Setting base offset to:" + offset.getAge());
            this.worldTime.setBaseOffset(offset.getAge());
        } else {
            log.warn("No offset time for world entity:" + this.worldEntity);
        }
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    public void update(float tpf) {
        this.worldTime.setRealTimeNanos(this.timeState.getTime());
    }
}

