/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.simsilica.crig.CharacterRig;
import com.simsilica.crig.RigShape;
import com.simsilica.crig.sim.AnimPump;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.AbstractControlDriver;
import com.simsilica.mphys.Contact;
import com.simsilica.mphys.RigidBody;
import mythruna.GameConstants;
import mythruna.es.MovementInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerDriver
extends AbstractControlDriver<EntityId, MBlockShape> {
    static Logger log = LoggerFactory.getLogger(PlayerDriver.class);
    private EntityData ed;
    private EntityId player;
    private Vec3d vTemp = new Vec3d();
    private double walkSpeed = 3.5;
    private double runSpeed = 3.25;
    private double groundImpulse = 200.0;
    private Vec3d desiredVelocity = new Vec3d();
    private Vec3d forward = new Vec3d();
    private Vec3d sideways = new Vec3d();
    private Quatd facing = new Quatd();
    private Quatd flatFacing = new Quatd();
    private Vec3d flatDir = new Vec3d();
    private boolean jump;
    private boolean running;
    private Vec3d walkVelocity = new Vec3d();
    private double averageWalkSpeed = 0.0;
    private double upThreshold = 0.7;
    private double verticalThreshold = 0.42;
    private double jumpForce = 9.0;
    private boolean shortJumps = true;
    private boolean autoBounce = true;
    private int groundContactCount = 0;
    private Vec3d groundVelocity = new Vec3d();
    private EntityId groundEntity;
    private boolean canJump = false;
    private boolean isJumping = false;
    private boolean autoclimbEnabled = true;
    private double climbForce;
    private double highestSideContact;
    private boolean autoclimb;
    private boolean isClimbing;
    private Vec3d force;
    private double[] angles;
    private boolean noGravity;
    private boolean enabled;
    private RigShape rigShape;
    private AnimPump animPump;
    private long nextSpawnUpdateTime;
    private long updateInterval;

    public PlayerDriver(EntityData ed, EntityId player) {
        this.climbForce = 4.0 + -GameConstants.DEFAULT_GRAVITY.y;
        this.highestSideContact = 0.0;
        this.autoclimb = false;
        this.isClimbing = false;
        this.force = new Vec3d();
        this.angles = new double[3];
        this.noGravity = false;
        this.enabled = true;
        this.nextSpawnUpdateTime = 0L;
        this.updateInterval = 5000000000L;
        this.ed = ed;
        this.player = player;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void initialize(RigidBody<EntityId, MBlockShape> body) {
        super.initialize(body);
        log.info("initialize(" + body + ")");
        if (this.noGravity) {
            body.setLinearAcceleration(new Vec3d(0.0, 0.0, 0.0));
        }
        body.setLinearDamping(0.2);
        if (body.shape instanceof RigShape) {
            this.rigShape = (RigShape)body.shape;
            this.animPump = new AnimPump((CharacterRig)this.rigShape, null);
            this.animPump.setCurrentAction("Idle", 1.0);
            this.rigShape.update();
            log.info("rig shape:" + this.rigShape);
        }
    }

    public void applyMovementInput(MovementInput input) {
        double flatRads;
        if (log.isTraceEnabled()) {
            log.trace("applyInput(" + input + ")");
        }
        this.jump = input.isJumping();
        Vec3d move = input.getMove();
        double up = move.y;
        this.running = false;
        this.forward.set(0.0, 0.0, move.z);
        if (Math.abs(move.z) > 0.001) {
            input.getFacing().mult(this.forward, this.forward);
            this.forward.y = 0.0;
            this.forward.normalizeLocal().multLocal(Math.abs(move.z));
            if (Math.abs(move.z) > 1.0) {
                this.running = true;
            }
        }
        this.sideways.set(move.x, 0.0, 0.0);
        if (Math.abs(move.x) > 0.001) {
            input.getFacing().mult(this.sideways, this.sideways);
            this.sideways.y = 0.0;
            this.sideways.normalizeLocal().multLocal(Math.abs(move.x));
            if (Math.abs(move.x) > 1.0) {
                this.running = true;
            }
        }
        if (Math.abs(move.y) > 1.0) {
            this.running = true;
        }
        if (this.running) {
            this.forward.multLocal(this.runSpeed);
            this.sideways.multLocal(this.runSpeed);
            up *= this.runSpeed;
        } else {
            this.forward.multLocal(this.walkSpeed);
            this.sideways.multLocal(this.walkSpeed);
            up *= this.walkSpeed;
        }
        this.desiredVelocity.set(this.forward).addLocal(this.sideways);
        this.desiredVelocity.y += up;
        this.facing.set(input.getFacing());
        Vec3d dir = input.getFacing().mult(Vec3d.UNIT_Z);
        if (this.forward.lengthSq() > 0.0 || this.sideways.lengthSq() > 0.0) {
            Vec3d flatMove = this.forward.add(this.sideways).normalizeLocal();
            if (this.forward.dot(dir) < 0.0) {
                flatMove = flatMove.mult(-1.0);
            }
            dir = flatMove;
        }
        if (Double.isNaN(flatRads = Math.atan2(dir.x, dir.z)) || Double.isInfinite(flatRads)) {
            flatRads = 0.0;
        }
        this.flatFacing.fromAngles(0.0, flatRads, 0.0);
        this.flatDir = this.flatFacing.mult(Vec3d.UNIT_Z, this.flatDir);
    }

    public void newContact(Contact<EntityId, MBlockShape> contact) {
        double upness = Vec3d.UNIT_Y.dot(contact.contactNormal);
        if (upness < this.upThreshold) {
            contact.friction = 0.0;
            double dot = this.desiredVelocity.dot(contact.contactNormal);
            if (dot < 0.0) {
                double yRelative = contact.contactPoint.y - this.getBody().position.y;
                this.highestSideContact = Math.max(yRelative, this.highestSideContact);
                this.autoclimb = this.autoclimbEnabled;
            }
            return;
        }
        if (contact.body1 == this.getBody()) {
            this.canJump = upness > this.verticalThreshold ? true : this.autoclimbEnabled;
            if (contact.body2 instanceof RigidBody) {
                this.groundVelocity.addLocal(((RigidBody)contact.body2).getLinearVelocity());
                ++this.groundContactCount;
                this.groundEntity = (EntityId)contact.body2.id;
            }
        }
    }

    protected void calculateCollisionData() {
        if (this.groundContactCount > 0) {
            this.groundVelocity.multLocal(1.0 / (double)this.groundContactCount);
            log.info("walk: groundVelocity:" + this.groundVelocity);
        }
    }

    protected void invalidateCollisionData() {
        this.groundEntity = null;
        this.groundContactCount = 0;
        this.groundVelocity.set(0.0, 0.0, 0.0);
        this.canJump = false;
        this.highestSideContact = 0.0;
        this.autoclimb = false;
        this.isClimbing = false;
    }

    protected void killVerticalRotation(RigidBody<EntityId, MBlockShape> body) {
        body.orientation.toAngles(this.angles);
        if (this.angles[0] != 0.0 || this.angles[2] != 0.0) {
            this.angles[0] = 0.0;
            this.angles[2] = 0.0;
            body.orientation.fromAngles(this.angles);
        }
        Vec3d rot = body.getRotationalVelocity();
        if (rot.x != 0.0 || rot.z != 0.0) {
            rot.x = 0.0;
            rot.z = 0.0;
            body.setRotationalVelocity(rot);
        }
    }

    public void update(long frameTime, double step) {
        if (!this.enabled) {
            return;
        }
        RigidBody body = this.getBody();
        if (log.isTraceEnabled()) {
            log.trace("update(" + step + ")  temperature:" + body.getTemperature());
        }
        this.calculateCollisionData();
        this.killVerticalRotation((RigidBody<EntityId, MBlockShape>)body);
        body.orientation.set(this.flatFacing);
        Vec3d velocity = body.getLinearVelocity();
        double verticalVelocity = velocity.y - this.groundVelocity.y;
        if (this.desiredVelocity.lengthSq() > 0.0) {
            this.force.set(this.desiredVelocity).subtractLocal(velocity);
            this.force.addLocal(this.groundVelocity);
            if (this.desiredVelocity.y == 0.0) {
                this.force.y = 0.0;
            }
            this.force.multLocal(this.groundImpulse * 10.0);
            if (!this.isJumping && this.autoclimb && this.highestSideContact <= 0.0) {
                double mass = 1.0 / body.getInverseMass();
                this.force.y += this.climbForce * mass;
                this.isClimbing = true;
            }
            body.addForce(this.force);
        } else if (this.noGravity) {
            body.getLinearVelocity().set(0.0, 0.0, 0.0);
        }
        if (this.jump) {
            if ((this.isClimbing || this.canJump) && !this.isJumping) {
                log.info("walk: -------------------JUMP!   velocity.y:" + velocity.y);
                velocity.y = this.groundVelocity.y;
                velocity.y += this.jumpForce;
                this.isJumping = true;
            }
        } else {
            if (this.shortJumps && this.isJumping && verticalVelocity > 0.0) {
                log.info("walk: ---------------KILL JUMP!");
                velocity.y = Math.min(velocity.y, this.groundVelocity.y + 2.0);
            }
            this.isJumping = false;
        }
        if (this.isJumping) {
            log.info("walk:  y velocity:" + verticalVelocity);
        }
        if (this.autoBounce && this.isJumping && verticalVelocity <= 0.0) {
            this.isJumping = false;
            log.info("walk: ---------------Jump done, faling.");
        }
        if (this.animPump != null && step > 0.0) {
            double effectiveSpeed;
            String action = "Idle";
            double animSpeed = 1.0;
            if (Math.abs(verticalVelocity) > 0.01) {
                effectiveSpeed = 0.0;
            } else {
                this.walkVelocity.set(velocity);
                this.walkVelocity.subtractLocal(this.groundVelocity);
                this.walkVelocity.y = 0.0;
                effectiveSpeed = this.walkVelocity.length();
                if (this.walkVelocity.dot(this.flatDir) < 0.0) {
                    effectiveSpeed = -effectiveSpeed;
                }
            }
            this.averageWalkSpeed = effectiveSpeed != 0.0 && this.averageWalkSpeed == 0.0 ? effectiveSpeed : (this.averageWalkSpeed + effectiveSpeed) / 2.0;
            double moveThreshold = Math.abs(this.averageWalkSpeed);
            if (!(moveThreshold < 0.001)) {
                if (moveThreshold < 1.8) {
                    action = "Walk";
                    animSpeed = 9.0 * (this.averageWalkSpeed / 2.0);
                } else {
                    action = "Jog";
                    animSpeed = this.averageWalkSpeed;
                }
            }
            if (action != null) {
                this.animPump.setCurrentAction(action, animSpeed);
                this.animPump.update(step);
                this.rigShape.update();
            }
        }
        body.wakeUp(true);
        this.invalidateCollisionData();
        if (frameTime > this.nextSpawnUpdateTime) {
            this.nextSpawnUpdateTime = frameTime + this.updateInterval;
            this.ed.setComponent(this.player, (EntityComponent)new SpawnPosition(GameConstants.PHYSICS_GRID, body.position, body.orientation));
        }
    }
}

