/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.tree;

import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.tree.AbstractTreeType;
import com.simsilica.mworld.tile.tree.AtlasCell;
import com.simsilica.mworld.tile.tree.TileColumnCells;
import com.simsilica.mworld.tile.tree.Tree;
import com.simsilica.mworld.tile.tree.TreeType;
import com.simsilica.mworld.tile.tree.TreeTypeIndex;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTreeType
extends AbstractTreeType {
    static Logger log = LoggerFactory.getLogger(SimpleTreeType.class);
    private int typeTrunk1;
    private int typeTrunk2;
    private int typeLeaves1;
    private int typeLeaves2;
    private AtlasCell altCell;

    public SimpleTreeType(String name, AtlasCell atlasCell) {
        super(name, atlasCell);
        this.altCell = new AtlasCell(atlasCell.getAtlasName(), atlasCell.getIndex() + 1);
    }

    public void initialize(TreeTypeIndex treeTypes) {
        this.typeLeaves1 = BlockTypeIndex.findType((BlockName)new BlockName("leaves", "leaf")) | TREE_BITS;
        this.typeLeaves2 = BlockTypeIndex.findType((BlockName)new BlockName("leaves2", "leaf")) | TREE_BITS;
        this.typeTrunk1 = BlockTypeIndex.findType((BlockName)new BlockName("trunk", "vcyl")) | TREE_BITS;
        this.typeTrunk2 = BlockTypeIndex.findType((BlockName)new BlockName("trunk", "vcyl25")) | TREE_BITS;
    }

    public AtlasCell getAtlasCell(Tree tree) {
        if (tree.height < 6) {
            return super.getAtlasCell(tree);
        }
        return this.altCell;
    }

    public Tree createTree(short x, short y, short z, TerrainImage terrain, Random rand) {
        int height = rand.nextInt(4) + 4;
        return new Tree(x, y, z, (byte)(++height), 2, (TreeType)this);
    }

    public boolean markTree(Tree tree, boolean[][] used) {
        if (tree.height < 5) {
            return super.markTree(tree, used);
        }
        short i = tree.x;
        short k = tree.z;
        int w = 2;
        for (int x = i - w; x <= i + w; ++x) {
            for (int z = k - w; z <= k + w; ++z) {
                if (x == i && z == k || x == i - w && z == k - w || x == i + w && z == k - w || x == i - w && z == k + w || x == i + w && z == k + w) continue;
                used[x][z] = true;
            }
        }
        return true;
    }

    public boolean insertTree(Tree tree, TileColumnCells cells, Random rand) {
        int low;
        int height = tree.height - 1;
        int start = tree.y;
        int end = tree.y + height;
        int trunkType = this.typeTrunk1;
        int leafType = this.typeLeaves1;
        if (height < 6) {
            trunkType = this.typeTrunk2;
        }
        if (height < 5) {
            leafType = this.typeLeaves2;
        }
        short i = tree.x;
        short k = tree.z;
        cells.setCell((int)i, end, (int)k, leafType);
        cells.setCell((int)i, end - 1, (int)k, leafType);
        for (int z = start; z < end - 1; ++z) {
            cells.setCell((int)i, z, (int)k, trunkType);
        }
        if (height < 5) {
            low = start + Math.max(1, height / 3);
            short w = 1;
            for (int y = end - 1; y >= low; --y) {
                for (int x = i - w; x <= i + w; ++x) {
                    for (int z = k - w; z <= k + w; ++z) {
                        if (x == i && z == k) continue;
                        cells.setCell(x, y, z, leafType);
                    }
                }
            }
        } else {
            low = start + height * 2 / 3;
            if (trunkType == this.typeTrunk1) {
                --low;
            }
            int w = 1;
            for (int y = end; y >= low; --y) {
                if (y == low) {
                    w = 1;
                } else if (y < end) {
                    w = 2;
                }
                for (int x = i - w; x <= i + w; ++x) {
                    for (int z = k - w; z <= k + w; ++z) {
                        if (x == i && z == k || w == 2 && (x == i - w && z == k - w || x == i + w && z == k - w || x == i - w && z == k + w || x == i + w && z == k + w)) continue;
                        cells.setCell(x, y, z, leafType);
                    }
                }
            }
        }
        return true;
    }

    public boolean insertTree(Tree tree, TerrainImage terrain) {
        short i = tree.x;
        short k = tree.z;
        int w = 2;
        for (int x = i - w; x <= i + w; ++x) {
            for (int z = k - w; z <= k + w; ++z) {
                if (x == i && z == k) {
                    terrain.setLight(x, z, (byte)-15);
                    continue;
                }
                if (x == i - w && z == k - w || x == i + w && z == k - w || x == i - w && z == k + w || x == i + w && z == k + w) continue;
                terrain.setLight(x, z, (byte)-7);
            }
        }
        return true;
    }
}

