/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.simsilica.lemur.component.AbstractGuiComponent;
import com.simsilica.lemur.component.ColoredComponent;
import com.simsilica.lemur.core.GuiControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapComponent
extends AbstractGuiComponent
implements ColoredComponent {
    static Logger log = LoggerFactory.getLogger(MapComponent.class);
    private AssetManager assets;
    private Texture mapTexture;
    private Texture fluidTexture;
    private Vector2f textureOffset = new Vector2f();
    private Geometry geometry;
    private Material material;
    private ColorRGBA color;
    private float alpha;

    public MapComponent(AssetManager assets, Texture mapTexture, Texture fluidTexture) {
        this.assets = assets;
        this.mapTexture = mapTexture;
        this.fluidTexture = fluidTexture;
    }

    public void attach(GuiControl parent) {
        super.attach(parent);
    }

    public void detach(GuiControl parent) {
        if (this.geometry != null) {
            this.getNode().detachChild((Spatial)this.geometry);
        }
        super.detach(parent);
    }

    public void setColor(ColorRGBA c) {
        this.color = c;
        this.resetColor();
    }

    protected void resetColor() {
        if (this.material == null) {
            return;
        }
        if (this.alpha >= 1.0f) {
            this.material.setColor("Color", this.color);
        } else {
            ColorRGBA adjusted = this.color != null ? this.color.clone() : ColorRGBA.White.clone();
            adjusted.a *= this.alpha;
            this.material.setColor("Color", adjusted);
        }
    }

    public ColorRGBA getColor() {
        return this.color;
    }

    public void setAlpha(float f) {
        if (this.alpha == f) {
            return;
        }
        this.alpha = f;
        this.resetColor();
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setMapTexture(Texture t) {
        if (this.mapTexture == t) {
            return;
        }
        this.mapTexture = t;
        if (this.material != null) {
            this.material.setTexture("TerrainMap", this.mapTexture);
        }
    }

    public Texture getMapTexture() {
        return this.mapTexture;
    }

    public void setFluidTexture(Texture t) {
        if (this.mapTexture == t) {
            return;
        }
        this.mapTexture = t;
        if (this.material != null) {
            this.material.setTexture("FluidMap", this.mapTexture);
        }
    }

    public Texture getFluidTexture() {
        return this.mapTexture;
    }

    public void setTextureOffset(double x, double y) {
        this.textureOffset.set((float)x, (float)y);
    }

    public Vector2f getTextureOffset() {
        return this.textureOffset;
    }

    public void calculatePreferredSize(Vector3f size) {
    }

    public void reshape(Vector3f pos, Vector3f size) {
        this.refreshBackground(size.y);
        this.geometry.setLocalTranslation(pos.x, pos.y - size.y, pos.z);
        size.x -= size.y;
        size.y -= size.y;
    }

    protected void createMaterial() {
        this.material = new Material(this.assets, "MatDefs/Map.j3md");
        if (this.mapTexture != null) {
            this.material.setTexture("TerrainMap", this.mapTexture);
        }
        if (this.fluidTexture != null) {
            this.material.setTexture("FluidMap", this.fluidTexture);
        }
        this.material.setVector2("TextureOffset", this.textureOffset);
        this.material.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.material.setFloat("AlphaDiscardThreshold", 0.1f);
    }

    protected void refreshBackground(float size) {
        log.info("refreshBackground(" + size + ")");
        if (this.geometry == null) {
            Quad q = new Quad(size, size);
            float tileSize = 0.0625f;
            float halfTile = tileSize * 0.5f;
            q.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{tileSize + halfTile, halfTile, 1.0f - halfTile, halfTile, 1.0f - halfTile, 1.0f - tileSize - halfTile, tileSize + halfTile, 1.0f - tileSize - halfTile});
            this.geometry = new Geometry("map", (Mesh)q);
            if (this.material == null) {
                this.createMaterial();
            }
            this.geometry.setMaterial(this.material);
            this.getNode().attachChild((Spatial)this.geometry);
        } else {
            Quad q = (Quad)this.geometry.getMesh();
            if (size != q.getWidth() || size != q.getHeight()) {
                q.updateGeometry(size, size);
                q.clearCollisionData();
            }
        }
    }
}

