/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.objects;

import com.jme3.scene.plugins.fbx.SceneLoader;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.objects.FbxObject;

public class FbxAnimCurve
extends FbxObject {
    public long[] keyTimes;
    public float[] keyValues;
    public float defaultValue = 0.0f;

    public FbxAnimCurve(SceneLoader scene, FbxElement element) {
        super(scene, element);
        for (FbxElement e : element.children) {
            switch (e.id) {
                case "KeyTime": {
                    this.keyTimes = (long[])e.properties.get(0);
                    break;
                }
                case "KeyValueFloat": {
                    this.keyValues = (float[])e.properties.get(0);
                    break;
                }
                case "Default": {
                    this.defaultValue = ((Number)e.properties.get(0)).floatValue();
                }
            }
        }
    }

    public float getValue(long time) {
        for (int i = 0; i < this.keyTimes.length; ++i) {
            if (this.keyTimes[i] == time) {
                return this.keyValues[i];
            }
            if (this.keyTimes[i] <= time) continue;
            if (i == 0) {
                return this.defaultValue;
            }
            float dt = this.keyTimes[i] - this.keyTimes[i - 1];
            float dtInt = time - this.keyTimes[i - 1];
            float dv = this.keyValues[i] - this.keyValues[i - 1];
            return this.keyValues[i - 1] + dv * (dtInt / dt);
        }
        return this.defaultValue;
    }
}

