/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net.server;

import com.google.common.collect.Iterables;
import com.simsilica.action.AbstractObjectAction;
import com.simsilica.action.ActionContext;
import com.simsilica.action.ActionEnvironment;
import com.simsilica.action.ObjectAction;
import com.simsilica.action.ObjectType;
import com.simsilica.action.ObjectTypeRegistry;
import com.simsilica.action.Option;
import com.simsilica.action.PromptType;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.CreatedBy;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Rayd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.phys.BlockColliderIterator;
import com.simsilica.mblock.phys.MBlockCollisionSystem;
import com.simsilica.mworld.BlockIterator;
import com.simsilica.mworld.World;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import mythruna.GameConstants;
import mythruna.es.BlueprintInfo;
import mythruna.es.BlueprintSource;
import mythruna.es.ContainedIn;
import mythruna.es.Holding;
import mythruna.es.ObjectFocus;
import mythruna.es.ObjectName;
import mythruna.sim.Activator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryObjectSetup {
    static Logger log = LoggerFactory.getLogger(TemporaryObjectSetup.class);

    protected static Set<EntityId> findPlayerBlueprints(EntityData ed, EntityId player) {
        EntityId parent = player;
        ComponentFilter filter = Filters.fieldEquals(BlueprintInfo.class, (String)"parent", (Object)parent);
        return ed.findEntities(filter, new Class[]{BlueprintInfo.class});
    }

    protected static String name(EntityData ed, EntityId id, String defaultName) {
        if (id == null) {
            return defaultName;
        }
        ObjectName on = (ObjectName)ed.getComponent(id, ObjectName.class);
        if (on != null) {
            return on.getName(ed);
        }
        Name n = (Name)ed.getComponent(id, Name.class);
        if (n != null) {
            return n.getName();
        }
        return defaultName;
    }

    public static void setupTypes(final World world, final ObjectTypeRegistry<Activator, EntityId> objectTypes, final EntityData ed, final Function<String, CellArray> storage, final MBlockCollisionSystem<EntityId> collisionSystem) {
        AbstractObjectAction<Activator, EntityId> look = new AbstractObjectAction<Activator, EntityId>("Look", new Class[0]){

            public boolean run(ActionEnvironment<Activator, EntityId> env, ActionContext<Activator, EntityId> context, Object ... args) {
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                EntityId id = (EntityId)context.getTarget();
                StringBuilder sb = new StringBuilder();
                sb.append(TemporaryObjectSetup.name(ed, id, "Unknown"));
                sb.append("\n");
                CreatedBy creator = (CreatedBy)ed.getComponent(id, CreatedBy.class);
                String creatorName = creator == null ? null : TemporaryObjectSetup.name(ed, creator.getCreatorId(), "Unknown");
                String desc = (String)context.getType().getTypeVar("description", (Object)null);
                if (desc != null) {
                    desc.replaceAll("\\$\\{id\\}", String.valueOf(id.getId()));
                    if (creatorName != null) {
                        desc.replaceAll("\\$\\{creator\\}", creatorName);
                    }
                    sb.append(desc);
                } else {
                    sb.append("ID:" + id.getId());
                    sb.append("\n");
                    if (creatorName != null) {
                        sb.append("Created by:" + creatorName);
                        sb.append("\n");
                    }
                }
                env.showPrompt((Object)id, PromptType.Dialog, sb.toString());
                env.showOptions((Object)id, new ArrayList());
                return true;
            }
        };
        ObjectType defaultType = new ObjectType("Default", Arrays.asList(look));
        objectTypes.setDefaultType(defaultType);
        AbstractObjectAction<Activator, EntityId> equip = new AbstractObjectAction<Activator, EntityId>("Equip", new Class[0]){

            public boolean run(ActionEnvironment<Activator, EntityId> env, ActionContext<Activator, EntityId> context, Object ... args) {
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                EntityId actor = ((Activator)env.getActivator()).getId();
                ContainedIn in = (ContainedIn)ed.getComponent((EntityId)context.getTarget(), ContainedIn.class);
                log.info("  root:" + in.getRoot() + "  activator:" + actor);
                if (!Objects.equals(in.getRoot(), actor)) {
                    return false;
                }
                String manipulator = (String)context.getType().getTypeVar("manipulator", (Object)"Default");
                ed.setComponents(actor, new EntityComponent[]{Holding.create((EntityId)context.getTarget(), manipulator, ed)});
                return true;
            }
        };
        ArrayList<AbstractObjectAction> actions = new ArrayList<AbstractObjectAction>();
        actions.add(equip);
        actions.add(look);
        actions.add(new AbstractObjectAction<Activator, EntityId>("startDigging", new Class[0]){

            public boolean run(ActionEnvironment<Activator, EntityId> env, ActionContext<Activator, EntityId> context, Object ... args) {
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                return true;
            }
        });
        actions.add(new AbstractObjectAction<Activator, EntityId>("stopDigging", new Class[0]){

            public boolean run(ActionEnvironment<Activator, EntityId> env, ActionContext<Activator, EntityId> context, Object ... args) {
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                Iterator<BlockIterator.Intersection> it = ((Activator)env.getActivator()).pick();
                if (it.hasNext()) {
                    BlockIterator.Intersection intersect = it.next();
                    world.setWorldCell(intersect.getBlock().toVec3d(), 0);
                }
                return true;
            }
        });
        actions.add(new AbstractObjectAction<Activator, EntityId>("startFilling", new Class[0]){

            public boolean run(ActionEnvironment<Activator, EntityId> env, ActionContext<Activator, EntityId> context, Object ... args) {
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                return true;
            }
        });
        actions.add(new AbstractObjectAction<Activator, EntityId>("stopFilling", new Class[0]){

            public boolean run(ActionEnvironment<Activator, EntityId> env, ActionContext<Activator, EntityId> context, Object ... args) {
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                Integer selected = (Integer)env.getVar("selectedType", (Object)1);
                Iterator<BlockIterator.Intersection> it = ((Activator)env.getActivator()).pick();
                if (it.hasNext()) {
                    BlockIterator.Intersection intersect = it.next();
                    Vec3d pos = intersect.getBlock().toVec3d();
                    pos.addLocal(intersect.getNormal());
                    world.setWorldCell(pos, selected.intValue());
                }
                return true;
            }
        });
        actions.add(new AbstractObjectAction<Activator, EntityId>("selectType", new Class[]{Integer.class}){

            public boolean run(ActionEnvironment<Activator, EntityId> env, ActionContext<Activator, EntityId> context, Object ... args) {
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                env.setVar("selectedType", (Object)((Integer)args[0]));
                ObjectFocus focus = ObjectFocus.blockType((Integer)args[0]);
                ed.setComponent((EntityId)context.getTarget(), (EntityComponent)focus);
                return true;
            }
        });
        actions.add(new AbstractObjectAction<Activator, EntityId>("rotate", new Class[]{Integer.class}){

            public boolean run(ActionEnvironment<Activator, EntityId> env, ActionContext<Activator, EntityId> context, Object ... args) {
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                return true;
            }
        });
        ObjectType type = objectTypes.registerType(new ObjectType("BuildWand", actions));
        type.setTypeVar("handleLocation", (Object)new Vec3d(1.5, 1.5, 3.0));
        type.setTypeVar("manipulator", (Object)"Digger");
        type.setTypeVar("description", (Object)"The Build Wand is used for placing and removing blocks.\n\nThe right mouse button will place the current block type\nand the left mouse button will remove the block under the\ncursor (highlighted yellow).\n\nPress 'e' to open the block type selector menu.\nPress 'c' to select the block under the cursor as the\ncurrent type.\n\nThe selected block will appear in the bottom center of the\nscreen.  If the block supports multiple rotations then the\nmouse wheel will change the block rotation.");
        actions = new ArrayList();
        actions.add(equip);
        actions.add(look);
        objectTypes.registerType(new ObjectType("BaseItem", actions));
        type = objectTypes.registerType(new ObjectType("Axe", actions));
        type.setTypeVar("handleLocation", (Object)new Vec3d(6.0, 0.0, 5.0));
        type = objectTypes.registerType(new ObjectType("Sword", actions));
        type.setTypeVar("handleLocation", (Object)new Vec3d(3.0, 0.0, 4.0));
        type = objectTypes.registerType(new ObjectType("Book", actions));
        type.setTypeVar("handleLocation", (Object)new Vec3d(0.0, 4.0, 1.0));
        type.setTypeVar("handleRotation", (Object)new Quatd().fromAngles(1.5707963267948966, Math.PI, 0.0));
        actions = new ArrayList();
        actions.add(new AbstractObjectAction<Activator, EntityId>("Equip", new Class[0], (ObjectAction)equip, ed){
            final /* synthetic */ ObjectAction val$equip;
            final /* synthetic */ EntityData val$ed;
            {
                this.val$equip = objectAction;
                this.val$ed = entityData;
                super(arg0, arg1);
            }

            public boolean run(ActionEnvironment<Activator, EntityId> env, ActionContext<Activator, EntityId> context, Object ... args) {
                log.info(context + ".subclass." + this.getName() + "(" + Arrays.asList(args) + ")");
                this.val$equip.run(env, context, args);
                EntityId player = ((Activator)env.getActivator()).getId();
                TreeSet<EntityId> bps = new TreeSet<EntityId>(TemporaryObjectSetup.findPlayerBlueprints(this.val$ed, player));
                if (bps.isEmpty()) {
                    this.val$ed.removeComponent((EntityId)context.getTarget(), ObjectFocus.class);
                    return true;
                }
                ObjectFocus focus = (ObjectFocus)this.val$ed.getComponent((EntityId)context.getTarget(), ObjectFocus.class);
                if (focus != null && focus.getEntityId() != null && bps.contains(focus.getEntityId())) {
                    env.setVar("selectedBlueprint", (Object)focus.getEntityId());
                    return true;
                }
                focus = ObjectFocus.entity((EntityId)Iterables.getFirst(bps, null));
                this.val$ed.setComponent((EntityId)context.getTarget(), (EntityComponent)focus);
                env.setVar("selectedBlueprint", (Object)focus.getEntityId());
                return true;
            }
        });
        actions.add(look);
        actions.add(new AbstractObjectAction<Activator, EntityId>("place", new Class[]{Vec3d.class}){

            public boolean run(ActionEnvironment<Activator, EntityId> env, ActionContext<Activator, EntityId> context, Object ... args) {
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                EntityId player = ((Activator)env.getActivator()).getId();
                EntityId bp = (EntityId)env.getVar("selectedBlueprint", (Object)null);
                if (bp == null) {
                    log.warn("We have no selected blueprint somehow.");
                    bp = (EntityId)Iterables.getFirst(TemporaryObjectSetup.findPlayerBlueprints(ed, player), null);
                    if (bp != null) {
                        env.setVar("selectedBlueprint", (Object)bp);
                    }
                }
                if (bp == null) {
                    log.error("No blueprint found.");
                    return false;
                }
                log.info("Create object at:" + args[0] + " with blueprint:" + bp);
                ShapeInfo shape = (ShapeInfo)ed.getComponent(bp, ShapeInfo.class);
                String shapeName = shape.getShapeName(ed);
                CellArray cells = (CellArray)storage.apply(shapeName);
                Vec3d size = cells.getSize().toVec3d();
                size.y = 0.0;
                size.multLocal(0.5).multLocal(shape.getScale());
                Vec3d loc = (Vec3d)args[0];
                loc.subtractLocal(size);
                SpawnPosition pos = new SpawnPosition(GameConstants.PHYSICS_GRID, loc, new Quatd());
                ObjectName name = (ObjectName)ed.getComponent(bp, ObjectName.class);
                EntityId object = ed.createEntity();
                ed.setComponents(object, new EntityComponent[]{pos, shape, new BlueprintSource(bp), name, new CreatedBy(player)});
                return true;
            }
        });
        actions.add(new AbstractObjectAction<Activator, EntityId>("dragStart", new Class[]{EntityId.class, Vec3d.class, Quatd.class, Vec3d.class}){

            public boolean run(ActionEnvironment<Activator, EntityId> env, ActionContext<Activator, EntityId> context, Object ... args) {
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                EntityId id = (EntityId)args[0];
                env.setVar("draggedObject", (Object)id);
                ShapeInfo shape = (ShapeInfo)ed.getComponent(id, ShapeInfo.class);
                String shapeName = shape.getShapeName(ed);
                CellArray cells = (CellArray)storage.apply(shapeName);
                Vec3d size = cells.getSize().toVec3d();
                size.y = 0.0;
                size.multLocal(0.5).multLocal(shape.getScale());
                env.setVar("draggedOffset", (Object)size);
                return true;
            }
        });
        actions.add(new AbstractObjectAction<Activator, EntityId>("drag", new Class[]{EntityId.class, Vec3d.class, Quatd.class, Vec3d.class}){

            public boolean run(ActionEnvironment<Activator, EntityId> env, ActionContext<Activator, EntityId> context, Object ... args) {
                EntityId id = (EntityId)args[0];
                Vec3d v = (Vec3d)args[1];
                Quatd q = (Quatd)args[2];
                Vec3d xAxis = q.mult(new Vec3d(1.0, 0.0, 0.0));
                double rads = Math.atan2(-xAxis.z, xAxis.x);
                q = new Quatd().fromAngles(0.0, rads, 0.0);
                Vec3d offset = (Vec3d)env.getVar("draggedOffset", null);
                if (offset == null) {
                    offset = new Vec3d();
                }
                q.mult(offset, offset);
                Vec3d loc = v.add(offset);
                Rayd ray = new Rayd(loc.add(0.0, 1.0, 0.0), new Vec3d(0.0, -1.0, 0.0));
                BlockColliderIterator it = collisionSystem.rayIterator(ray, 1.0);
                if (it.hasNext()) {
                    BlockIterator.Intersection hit = (BlockIterator.Intersection)it.next();
                    if (v.y < hit.getPoint().y) {
                        v.y = hit.getPoint().y;
                    }
                }
                SpawnPosition pos = new SpawnPosition(GameConstants.PHYSICS_GRID, v, q);
                ed.setComponent(id, (EntityComponent)pos);
                return true;
            }
        });
        actions.add(new AbstractObjectAction<Activator, EntityId>("dragEnd", new Class[]{EntityId.class}){

            public boolean run(ActionEnvironment<Activator, EntityId> env, ActionContext<Activator, EntityId> context, Object ... args) {
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                env.setVar("draggedObject", null);
                env.setVar("draggedOffset", null);
                return true;
            }
        });
        actions.add(new AbstractObjectAction<Activator, EntityId>("contextAction", new Class[]{EntityId.class, Vec3d.class}){

            public boolean run(ActionEnvironment<Activator, EntityId> env, ActionContext<Activator, EntityId> context, Object ... args) {
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                EntityId player = ((Activator)env.getActivator()).getId();
                EntityId object = (EntityId)args[0];
                String name = null;
                ObjectName objectName = (ObjectName)ed.getComponent(object, ObjectName.class);
                if (objectName == null) {
                    log.warn("Object is missing a name... looking at its blueprint.");
                    BlueprintSource bpSource = (BlueprintSource)ed.getComponent(object, BlueprintSource.class);
                    if (bpSource != null) {
                        objectName = (ObjectName)ed.getComponent(bpSource.getBlueprintId(), ObjectName.class);
                    }
                }
                name = objectName != null ? objectName.getName(ed) : "Unknown";
                CreatedBy creator = (CreatedBy)ed.getComponent(object, CreatedBy.class);
                log.info("Player:" + player + "  creator:" + creator.getCreatorId());
                ArrayList<Option> options = new ArrayList<Option>();
                options.add(new Option("Look", new Object[0]));
                options.add(new Option((Object)((EntityId)context.getTarget()), "copyBlueprint", new Object[]{object}));
                if (Objects.equals(creator.getCreatorId(), player)) {
                    options.add(new Option((Object)((EntityId)context.getTarget()), "deleteObject", new Object[]{object}));
                }
                env.showPrompt((Object)object, PromptType.List, name);
                env.showOptions((Object)object, options);
                return true;
            }
        });
        actions.add(new AbstractObjectAction<Activator, EntityId>("copyBlueprint", new Class[]{EntityId.class}){

            public boolean run(ActionEnvironment<Activator, EntityId> env, ActionContext<Activator, EntityId> context, Object ... args) {
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                EntityId player = ((Activator)env.getActivator()).getId();
                EntityId object = (EntityId)args[0];
                log.info("Need to copy:" + object);
                String name = null;
                ObjectName objectName = (ObjectName)ed.getComponent(object, ObjectName.class);
                CreatedBy creator = null;
                BlueprintSource bpSource = null;
                if (objectName == null) {
                    log.warn("Object is missing a name... looking at its blueprint.");
                    bpSource = (BlueprintSource)ed.getComponent(object, BlueprintSource.class);
                    if (bpSource != null) {
                        objectName = (ObjectName)ed.getComponent(bpSource.getBlueprintId(), ObjectName.class);
                        creator = (CreatedBy)ed.getComponent(bpSource.getBlueprintId(), CreatedBy.class);
                    }
                }
                name = objectName != null ? objectName.getName(ed) : "Unknown";
                ShapeInfo shape = (ShapeInfo)ed.getComponent(object, ShapeInfo.class);
                String shapeName = shape.getShapeName(ed);
                CellArray cells = (CellArray)storage.apply(shapeName);
                Vec3i offset = cells.getSize();
                offset.y = 0;
                offset.x = 5 - offset.x / 2;
                offset.z = 5 - offset.z / 2;
                object = ed.createEntity();
                ed.setComponents(object, new EntityComponent[]{new BlueprintInfo(player, name + " Copy", offset), ObjectName.create(name, ed), shape, new CreatedBy(player)});
                if (bpSource != null) {
                    ed.setComponents(object, new EntityComponent[]{bpSource});
                }
                return true;
            }
        });
        actions.add(new AbstractObjectAction<Activator, EntityId>("deleteObject", new Class[]{EntityId.class}){

            public boolean run(ActionEnvironment<Activator, EntityId> env, ActionContext<Activator, EntityId> context, Object ... args) {
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                EntityId player = ((Activator)env.getActivator()).getId();
                EntityId object = (EntityId)args[0];
                log.info("Need to delete:" + object);
                ed.removeEntity(object);
                return true;
            }
        });
        actions.add(new AbstractObjectAction<Activator, EntityId>("rotate", new Class[]{Integer.class}){

            public boolean run(ActionEnvironment<Activator, EntityId> env, ActionContext<Activator, EntityId> context, Object ... args) {
                int index;
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                EntityId player = ((Activator)env.getActivator()).getId();
                ArrayList<EntityId> bps = new ArrayList<EntityId>(TemporaryObjectSetup.findPlayerBlueprints(ed, player));
                Collections.sort(bps);
                EntityId bp = (EntityId)env.getVar("selectedBlueprint", (Object)null);
                int nextIndex = 0;
                if (bp != null && (nextIndex = ((index = bps.indexOf(bp)) + (Integer)args[0]) % bps.size()) < 0) {
                    nextIndex += bps.size();
                }
                bp = (EntityId)bps.get(nextIndex);
                ObjectFocus focus = ObjectFocus.entity(bp);
                ed.setComponent((EntityId)context.getTarget(), (EntityComponent)focus);
                env.setVar("selectedBlueprint", (Object)bp);
                return true;
            }
        });
        type = objectTypes.registerType(new ObjectType("ObjectTool", actions));
        type.setTypeVar("manipulator", (Object)"Creator");
        type.setTypeVar("handleLocation", (Object)new Vec3d(0.0, 3.0, 0.0));
        type.setTypeVar("handleRotation", (Object)new Quatd().fromAngles(1.5707963267948966, 0.0, 0.0));
        type.setTypeVar("description", (Object)"The Object Tool is used for placing and updating objects.\n\nClicking the right mouse button in an open location will\nplace the current object type centered over that location.\n\nThe mouse wheel will switch the object type.  The current\nobject type is displayed in the bottom middle of the screen.\n\nClicking the right mouse button on an existing object will\nopen its action menu.\n\nPress the right mouse button down on an object and drag to\nmove it.\nWhile dragging an object, the mouse wheel will rotate the\nobject.\n\nNew object types can be created in the blueprint editor\naccessible from the player menu (tab).");
        actions = new ArrayList();
        actions.add(look);
        actions.add(new AbstractObjectAction<Activator, EntityId>("drop", new Class[]{EntityId.class, Integer.class, Integer.class}){

            public boolean run(ActionEnvironment<Activator, EntityId> env, ActionContext<Activator, EntityId> context, Object ... args) {
                EntityId item = (EntityId)args[0];
                int xSlot = (Integer)args[1];
                int ySlot = (Integer)args[2];
                log.info(context.getTarget() + ".drop(" + item + ", " + xSlot + ", " + ySlot + ")");
                ContainedIn in = (ContainedIn)ed.getComponent((EntityId)context.getTarget(), ContainedIn.class);
                ed.setComponent(item, (EntityComponent)new ContainedIn(in.getRoot(), (EntityId)context.getTarget(), xSlot, ySlot));
                return true;
            }
        });
        actions.add(new AbstractObjectAction<Activator, EntityId>("itemActions", new Class[]{EntityId.class}){

            public boolean run(ActionEnvironment<Activator, EntityId> env, ActionContext<Activator, EntityId> context, Object ... args) {
                log.info(context + "." + this.getName() + "(" + Arrays.asList(args) + ")");
                EntityId item = (EntityId)args[0];
                ContainedIn in = (ContainedIn)ed.getComponent(item, ContainedIn.class);
                if (!Objects.equals(in.getContainer(), context.getTarget())) {
                    return false;
                }
                ActionContext itemContext = objectTypes.getContext((Object)item);
                String name = TemporaryObjectSetup.name(ed, item, String.valueOf(item));
                ObjectType type = objectTypes.getType((Object)item);
                ArrayList<Option> options = new ArrayList<Option>();
                for (ObjectAction action : type.getContextActions()) {
                    if (!action.canRun(env, itemContext, new Object[0])) {
                        log.info("Skipping:" + action);
                        continue;
                    }
                    options.add(new Option(action.getName(), new Object[0]));
                }
                env.showPrompt((Object)item, PromptType.List, name);
                env.showOptions((Object)item, options);
                return true;
            }
        });
        objectTypes.registerType(new ObjectType("Backpack", actions));
    }
}

