/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.simsilica.fractal.Sampler;
import mythruna.world.WorldFractal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorldFractal
implements WorldFractal {
    static Logger log = LoggerFactory.getLogger(DefaultWorldFractal.class);
    private Sampler estimatedElevation;
    private Sampler elevation;
    private Sampler waterLevel;
    private Sampler temperature;
    private Sampler weather;
    private Sampler ecology;
    protected static double rescale = 1.0;
    private double xCenter = 1050240.0;
    private double zCenter = 1020515.0;
    int seaLevel = 128;

    public DefaultWorldFractal(Sampler estimatedElevation, Sampler elevation, Sampler waterLevel, Sampler temperature, Sampler weather, Sampler ecology) {
        this.estimatedElevation = estimatedElevation;
        this.elevation = elevation;
        this.waterLevel = waterLevel;
        this.temperature = temperature;
        this.weather = weather;
        this.ecology = ecology;
    }

    @Override
    public long getFractalHash() {
        String s = this.elevation + ", " + this.waterLevel + ", " + this.temperature + ", " + this.weather + ", " + this.ecology;
        log.info("Fractal hash basis:" + s);
        return s.hashCode();
    }

    private double xRescale(double x) {
        return this.xCenter + (x - this.xCenter) * rescale;
    }

    private double zRescale(double z) {
        return this.zCenter + (z - this.zCenter) * rescale;
    }

    private double yUnscale(double y) {
        return 128.0 + (y - 128.0) / rescale;
    }

    private double yRescale(double y) {
        return 128.0 + (y - 128.0) * rescale;
    }

    @Override
    public double getEstimatedElevation(double x, double z) {
        return this.yUnscale(this.estimatedElevation.getSample(this.xRescale(x), 0.0, this.zRescale(z)));
    }

    @Override
    public double getElevation(double x, double z) {
        return this.yUnscale(this.elevation.getSample(this.xRescale(x), 0.0, this.zRescale(z)));
    }

    @Override
    public double getWaterLevel(double x, double y, double z) {
        return this.waterLevel.getSample(this.xRescale(x), this.yRescale(y), this.zRescale(z));
    }

    @Override
    public double getTemperature(double x, double y, double z) {
        return this.temperature.getSample(this.xRescale(x), this.yRescale(y), this.zRescale(z));
    }

    @Override
    public double getWeather(double x, double y, double z) {
        return this.weather.getSample(this.xRescale(x), this.yRescale(y), this.zRescale(z));
    }

    @Override
    public double getEcology(double x, double y, double z) {
        return this.ecology.getSample(this.xRescale(x), this.yRescale(y), this.zRescale(z));
    }
}

