/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal.zone;

import com.simsilica.ethereal.zone.ZoneKey;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import java.util.ArrayList;
import java.util.List;

public class StateBlock {
    private final long time;
    private final ZoneKey zone;
    private List<StateEntry> updates;
    private List<Long> removes;

    public StateBlock(long time, ZoneKey zone) {
        this.time = time;
        this.zone = zone;
    }

    public ZoneKey getZone() {
        return this.zone;
    }

    public boolean isEmpty() {
        return this.updates == null && this.removes == null;
    }

    public void addUpdate(Long parent, Long entity, Vec3d pos, Quatd rot) {
        if (this.updates == null) {
            this.updates = new ArrayList<StateEntry>();
        }
        this.updates.add(new StateEntry(parent, entity, pos, rot));
    }

    public void removeEntity(Long entity) {
        if (this.removes == null) {
            this.removes = new ArrayList<Long>();
        }
        this.removes.add(entity);
    }

    public long getTime() {
        return this.time;
    }

    public List<StateEntry> getUpdates() {
        return this.updates;
    }

    public List<Long> getRemovals() {
        return this.removes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StateBlock[time=" + this.time + ", zone=" + this.zone);
        if (this.updates != null) {
            sb.append(", updates=" + this.updates);
        }
        if (this.removes != null) {
            sb.append(", removes=" + this.removes);
        }
        sb.append("]");
        return sb.toString();
    }

    public static class StateEntry {
        private final Long parent;
        private final Long entity;
        private final Vec3d pos;
        private final Quatd rot;

        public StateEntry(Long parent, Long entity, Vec3d pos, Quatd rot) {
            this.parent = parent;
            this.entity = entity;
            this.pos = pos;
            this.rot = rot;
        }

        public Long getParent() {
            return this.parent;
        }

        public Long getEntity() {
            return this.entity;
        }

        public Vec3d getPosition() {
            return this.pos;
        }

        public Quatd getRotation() {
            return this.rot;
        }

        public String toString() {
            return "StateEntry[" + (this.parent != null ? this.parent + ", " : "") + this.entity + ", " + this.pos + ", " + this.rot + "]";
        }
    }
}

