/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ext.mphys;

import com.google.common.reflect.TypeToken;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.DynArray;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeShapeFactory<S extends AbstractShape>
implements ShapeFactory<S> {
    static Logger log = LoggerFactory.getLogger(CompositeShapeFactory.class);
    private DynArray<ShapeFactory<S>> delegates = new DynArray(new TypeToken<ShapeFactory<S>>(){});

    @SafeVarargs
    public CompositeShapeFactory(ShapeFactory<S> ... delegates) {
        this.delegates.addAll(Arrays.asList(delegates));
    }

    public void addDelegate(ShapeFactory<S> delegate) {
        this.delegates.add(delegate);
    }

    public List<ShapeFactory<S>> getDelegates() {
        return this.delegates;
    }

    @Override
    public S createShape(ShapeInfo info, Mass mass) {
        for (ShapeFactory factory : (ShapeFactory[])this.delegates.getArray()) {
            Object result = factory.createShape(info, mass);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

