/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.trans.PositionTransition3d;
import java.util.ArrayList;
import java.util.List;
import mythruna.sim.PathBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathPlayer {
    static Logger log = LoggerFactory.getLogger(PathPlayer.class);
    private PathBuffer buffer;
    private List<PositionTransition3d> frames = new ArrayList<PositionTransition3d>();
    private PositionTransition3d currentFrame;
    private Long startTime = null;
    private long currentTime;
    private int currentIndex;

    public PathPlayer(PathBuffer buffer) {
        this.buffer = buffer;
        this.frames = buffer.getFrames();
        this.currentTime = 0L;
        this.currentIndex = 0;
        this.currentFrame = this.frames.get(this.currentIndex);
    }

    public void restart() {
        this.startTime = null;
        this.currentTime = 0L;
        this.currentIndex = 0;
        this.currentFrame = this.frames.get(this.currentIndex);
    }

    public void update(long time) {
        if (this.startTime == null) {
            this.startTime = time;
            time = 0L;
        } else {
            time -= this.startTime.longValue();
        }
        this.currentTime = time;
        if (this.currentFrame.containsTime(this.currentTime)) {
            return;
        }
        while (this.currentIndex < this.frames.size()) {
            this.currentFrame = this.frames.get(this.currentIndex);
            if (this.currentFrame.containsTime(this.currentTime)) break;
            ++this.currentIndex;
        }
    }

    public Vec3d getPosition() {
        return this.currentFrame == null ? null : this.currentFrame.getPosition(this.currentTime, true);
    }

    public Quatd getRotation() {
        return this.currentFrame == null ? null : this.currentFrame.getRotation(this.currentTime, true);
    }
}

