/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImageDb;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import java.io.File;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileManager {
    static Logger log = LoggerFactory.getLogger(TileManager.class);
    private File root;
    private boolean initialized;
    private TerrainImageDb terrainImageDb;
    private LoadingCache<EntryId, Tile> cache;
    private ListMultimap<Resolution, TileFunction> tileFunctions = MultimapBuilder.hashKeys().arrayListValues().build();

    public TileManager(TerrainImageDb terrainImageDb) {
        this.cache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<EntryId, Tile>(){

            public void onRemoval(RemovalNotification<EntryId, Tile> notification) {
                log.info("cacheRemoval(" + notification + ") reason:" + notification.getCause());
            }
        }).build((CacheLoader)new CacheLoader<EntryId, Tile>(){

            public Tile load(EntryId id) {
                return TileManager.this.loadTile(id.tileId, id.res);
            }
        });
        this.terrainImageDb = terrainImageDb;
        this.addTileFunction(terrainImageDb.getLoadFunction());
    }

    public void addTileFunction(TileFunction ... functions) {
        for (Resolution res : Resolution.values()) {
            this.addTileFunction(res, functions);
        }
    }

    public void addTileFunction(Resolution res, TileFunction ... functions) {
        for (TileFunction f : functions) {
            this.tileFunctions.put((Object)res, (Object)f);
        }
    }

    public <T> T getTileFunction(Resolution res, Class<T> tileFunctionType) {
        for (TileFunction f : this.tileFunctions.get((Object)res)) {
            if (!tileFunctionType.isInstance(f)) continue;
            return tileFunctionType.cast(f);
        }
        return null;
    }

    protected Tile loadTile(TileId id, Resolution res) {
        Tile result = new Tile(this, id, res);
        for (TileFunction f : this.tileFunctions.get((Object)res)) {
            f.accept(result);
        }
        return result;
    }

    public void initialize() {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        log.info("initialize()");
        this.terrainImageDb.initialize();
        this.initialized = true;
    }

    public void terminate() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
        log.info("terminate()");
        this.terrainImageDb.terminate();
        for (TileFunction f : this.tileFunctions.values()) {
            if (!(f instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)((Object)f)).close();
            }
            catch (Exception e) {
                log.error("Error closing:" + f, (Throwable)e);
            }
        }
        this.initialized = false;
    }

    public Tile getTile(TileId id, Resolution res) {
        return (Tile)this.cache.getUnchecked((Object)new EntryId(id, res));
    }

    private class EntryId {
        private TileId tileId;
        private Resolution res;

        public EntryId(TileId tileId, Resolution res) {
            this.tileId = tileId;
            this.res = res;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.tileId, this.res});
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            EntryId other = (EntryId)o;
            if (!Objects.equals(other.tileId, this.tileId)) {
                return false;
            }
            return Objects.equals((Object)other.res, (Object)this.res);
        }

        public String toString() {
            return "EntryId[tileId:" + this.tileId + ", res:" + (Object)((Object)this.res) + "]";
        }
    }
}

