/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.simsilica.es.EntityData;
import com.simsilica.ethereal.TimeSource;
import com.simsilica.ext.mphys.ShapeFactoryRegistry;
import com.simsilica.fsm.StateMachine;
import com.simsilica.fx.LightingState;
import com.simsilica.fx.sky.SkySettingsState;
import com.simsilica.fx.sky.SkyState;
import com.simsilica.input.MovementState;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.mblock.config.MaterialRegistry;
import com.simsilica.mblock.geom.GeometryFactory;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mworld.World;
import com.simsilica.mworld.view.FarTerrainState;
import com.simsilica.mworld.view.FogSettings;
import com.simsilica.mworld.view.PointCloudState;
import com.simsilica.mworld.view.TerrainState;
import com.simsilica.mworld.view.TreeState;
import com.simsilica.state.BlackboardState;
import com.simsilica.state.CameraState;
import com.simsilica.state.CompositeAppState;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import mythruna.client.GameSettingsState;
import mythruna.client.MainGameFunctions;
import mythruna.client.net.ConnectionState;
import mythruna.client.net.HostedGameState;
import mythruna.client.net.NetworkState;
import mythruna.client.ui.ContainerViewState;
import mythruna.client.ui.FlyOverState;
import mythruna.client.ui.HelpMenuState;
import mythruna.client.ui.InGameMenuState;
import mythruna.client.ui.PlayerMenuState;
import mythruna.client.ui.UserPromptState;
import mythruna.client.view.ActivationInputState;
import mythruna.client.view.AvatarState;
import mythruna.client.view.BlockTypeSelectionState;
import mythruna.client.view.CharacterAnimationState;
import mythruna.client.view.HudStatsState;
import mythruna.client.view.ModelViewState;
import mythruna.client.view.PhysicsDebugState;
import mythruna.client.view.ShellState;
import mythruna.client.view.TerrainMaterials;
import mythruna.client.view.WorldMarkerState;
import mythruna.client.view.WorldTimeState;
import mythruna.client.view.WorldViewState;
import mythruna.net.GameSession;
import mythruna.net.GameSessionListener;
import mythruna.net.client.GameSessionClientService;
import mythruna.shape.ShapeRegistryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameSessionState
extends CompositeAppState {
    static Logger log = LoggerFactory.getLogger(GameSessionState.class);
    private GameSessionClientService session;
    private Map<String, Material> materials;
    private GeometryFactory geomFactory;
    private GeometryFactory modelGeomFactory;
    private Set<String> uncarvable = new HashSet<String>();
    private Predicate<Geometry> carveIncludes = new Predicate<Geometry>(){

        @Override
        public boolean test(Geometry geom) {
            return !GameSessionState.this.uncarvable.contains(geom.getMaterial().getName());
        }
    };
    private ShapeFactoryRegistry<MBlockShape> shapeFactory;
    private StateMachine<String, String> uiFsm;
    public static final String T_EXIT = "exit";
    public static final String T_RETURN_TO_GAME = "returnToGame";
    public static final String T_OPEN_GAME_MENU = "openGameMenu";
    public static final String T_OPEN_PLAYER_BOOK = "openPlayerBook";
    public static final String T_OPEN_CONTAINER_VIEW = "openContainerView";
    public static final String T_OPEN_SETTINGS_MENU = "openSettingsMenu";
    public static final String T_SELECT_TYPE = "selectType";
    public static final String T_OPEN_HELP = "openHelp";
    public static final String T_OPEN_PROMPT = "openPrompt";
    public static final String T_CLOSE_PROMPT = "closePrompt";
    public static final String STATE_IN_GAME = "In Game";
    public static final String STATE_GAME_MENU = "Game Menu";
    public static final String STATE_PLAYER_BOOK = "Player Book";
    public static final String STATE_CONTAINER_VIEW = "Container View";
    public static final String STATE_SETTINGS = "Settings";
    public static final String STATE_SELECT_TYPE = "Select Type";
    public static final String STATE_HELP = "Help";
    public static final String STATE_PROMPT = "Prompt";

    public GameSessionState() {
        super(new AppState[]{new MovementState(), new CameraState(), new WorldTimeState(), new LightingState(), new SkyState(true), new SkySettingsState(), new BlackboardState()});
    }

    public GameSession getGameSession() {
        return this.session;
    }

    public GeometryFactory getGeometryFactory() {
        return this.geomFactory;
    }

    public GeometryFactory getModelGeometryFactory() {
        return this.modelGeomFactory;
    }

    public Predicate<Geometry> getCarveIncludes() {
        return this.carveIncludes;
    }

    public ShapeFactoryRegistry<MBlockShape> getShapeFactory() {
        return this.shapeFactory;
    }

    public Map<String, Material> getBlockMaterials() {
        return this.materials;
    }

    public World getWorld() {
        return ((ConnectionState)this.getState(ConnectionState.class, true)).getService(World.class);
    }

    public EntityData getEntityData() {
        return ((ConnectionState)this.getState(ConnectionState.class, true)).getEntityData();
    }

    public TimeSource getTimeSource() {
        return ((ConnectionState)this.getState(ConnectionState.class, true)).getRemoteTimeSource();
    }

    public void addGameSessionListener(GameSessionListener l) {
        this.session.addGameSessionListener(l);
    }

    public void removeGameSessionListener(GameSessionListener l) {
        this.session.removeGameSessionListener(l);
    }

    public void exit() {
        log.info("exit()");
        this.uiFsm.trigger((Object)T_EXIT);
        log.info("disabling self");
        this.setEnabled(false);
        log.info("Triggering network state EXIT");
        ((NetworkState)this.getState(NetworkState.class)).trigger(T_EXIT);
        log.info("detaching self");
        this.getApplication().getStateManager().detach((AppState)this);
    }

    protected void initialize(Application app) {
        log.info("initialize()");
        ((BlackboardState)this.getState(BlackboardState.class)).set(World.class, (Object)this.getWorld());
        FogSettings fogSettings = new FogSettings();
        ((BlackboardState)this.getState(BlackboardState.class)).set(FogSettings.class, (Object)fogSettings);
        fogSettings.setFogColor(new ColorRGBA(0.7f, 0.7f, 0.9f, 1.0f));
        fogSettings.setFogDistance(3072);
        this.addChild((AppState)new AvatarState());
        this.addChild((AppState)new ActivationInputState());
        this.addChild((AppState)new WorldViewState());
        this.addChild((AppState)new ModelViewState());
        this.addChild((AppState)new WorldMarkerState());
        this.addChild((AppState)new CharacterAnimationState());
        this.addChild((AppState)new TerrainState());
        this.addChild((AppState)new FarTerrainState());
        this.addChild((AppState)new TreeState());
        this.addChild((AppState)new PointCloudState(true).workerPoolId("backgroundWorkers"), true);
        this.addChild((AppState)new HudStatsState(), true);
        this.addChild((AppState)new InGameMenuState(), true);
        this.addChild((AppState)new PlayerMenuState(), true);
        this.addChild((AppState)new BlockTypeSelectionState(), true);
        this.addChild((AppState)new ShellState());
        this.addChild((AppState)new HelpMenuState(), true);
        this.addChild((AppState)new FlyOverState(), true);
        this.addChild((AppState)new ContainerViewState(), true);
        this.addChild((AppState)new UserPromptState(), true);
        ((CameraState)this.getState(CameraState.class)).setFieldOfView(60.0f);
        ((CameraState)this.getState(CameraState.class)).setNear(0.1f);
        ((CameraState)this.getState(CameraState.class)).setFar(8000.0f);
        ((MovementState)this.getState(MovementState.class)).setWalkSpeed(1.0);
        ((MovementState)this.getState(MovementState.class)).setRunSpeed(2.0);
        ((TerrainState)this.getChild(TerrainState.class)).setMaterialFactory(TerrainMaterials.terrainMaterial(app));
        ((FarTerrainState)this.getChild(FarTerrainState.class)).setMaterialFactory(TerrainMaterials.farTerrainMaterial(app));
        ((TreeState)this.getChild(TreeState.class)).setMaterialFactory(TerrainMaterials.treeBillboardMaterial(app));
        ((PointCloudState)this.getChild(PointCloudState.class)).setMaterialFactory(TerrainMaterials.pointCloudMaterial(app));
        ((TreeState)this.getChild(TreeState.class)).setClipDistance(3072.0f);
        ((PointCloudState)this.getChild(PointCloudState.class)).setClipDistance(3072.0f);
        LightingState lighting = (LightingState)this.getChild(LightingState.class);
        lighting.setSunColor(new ColorRGBA(1.2f, 1.2f, 1.1f, 1.0f));
        lighting.setTimeOfDay(0.16f);
        this.session = ((ConnectionState)this.getState(ConnectionState.class, true)).getService(GameSessionClientService.class);
        HostedGameState host = (HostedGameState)this.getState(HostedGameState.class);
        if (host != null) {
            this.addChild((AppState)new PhysicsDebugState(host), true);
        }
        try {
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/materials.mset");
            if (in == null) {
                throw new RuntimeException("Resource /materials.mset not found");
            }
            this.materials = MaterialRegistry.loadCompiledMaterials((AssetManager)app.getAssetManager(), (InputStream)in);
            for (String s : this.materials.keySet()) {
                if (!s.startsWith("light-")) continue;
                this.uncarvable.add(s);
            }
            this.uncarvable.add("leaves");
            this.uncarvable.add("leaves2");
            this.uncarvable.add("hay-framed");
            this.uncarvable.add("hay");
            this.uncarvable.add("pine-branch");
            this.uncarvable.add("glass");
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading /materials.mset", e);
        }
        this.geomFactory = new GeometryFactory(false, this.materials);
        this.modelGeomFactory = new GeometryFactory(true, this.materials);
        EntityData ed = ((ConnectionState)this.getState(ConnectionState.class, true)).getEntityData();
        this.shapeFactory = ShapeRegistryBuilder.clientRegistry((EntityData)ed, (GameSession)this.session);
        this.configureUiStateMachine();
    }

    protected void cleanup(Application app) {
        log.info("cleanup()");
    }

    protected void onEnable() {
        log.info("onEnable()");
        super.onEnable();
        this.uiFsm.start();
        log.info("uiFsm.isRunning():" + this.uiFsm.isRunning());
        log.info("uiFsm.currentState:" + this.uiFsm.getCurrentState());
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.activateGroup(STATE_IN_GAME);
        inputMapper.addDelegate(MainGameFunctions.F_IN_GAME_MENU, (Object)this, T_OPEN_GAME_MENU);
        inputMapper.addDelegate(MainGameFunctions.F_PLAYER_MENU, (Object)this, "openPlayerMenu");
        inputMapper.addDelegate(MainGameFunctions.F_INVENTORY, (Object)this, "openInventory");
        inputMapper.addDelegate(MainGameFunctions.F_PLAYER_EQUIPMENT, (Object)this, "selectBlockType");
        inputMapper.addDelegate(MainGameFunctions.F_IN_GAME_HELP, (Object)this, T_OPEN_HELP);
    }

    protected void onDisable() {
        log.info("onDisable()");
        super.onDisable();
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.deactivateGroup(STATE_IN_GAME);
        inputMapper.removeDelegate(MainGameFunctions.F_IN_GAME_MENU, (Object)this, T_OPEN_GAME_MENU);
        inputMapper.removeDelegate(MainGameFunctions.F_PLAYER_MENU, (Object)this, "openPlayerMenu");
        inputMapper.removeDelegate(MainGameFunctions.F_INVENTORY, (Object)this, "openInventory");
        inputMapper.removeDelegate(MainGameFunctions.F_PLAYER_EQUIPMENT, (Object)this, "selectBlockType");
        inputMapper.removeDelegate(MainGameFunctions.F_IN_GAME_HELP, (Object)this, T_OPEN_HELP);
    }

    public void trigger(String transition) {
        this.uiFsm.trigger((Object)transition);
    }

    public void openGameMenu() {
        this.trigger(T_OPEN_GAME_MENU);
    }

    public void openPlayerMenu() {
        log.info("openPlayerMenu() this:" + (Object)((Object)this) + "   isEnabled():" + this.isEnabled());
        this.trigger(T_OPEN_PLAYER_BOOK);
    }

    public void openInventory() {
        this.trigger(T_OPEN_CONTAINER_VIEW);
    }

    public void openPrompt() {
        this.trigger(T_OPEN_PROMPT);
    }

    public void closePrompt() {
        if (STATE_PROMPT.equals(this.uiFsm.getCurrentState().getId())) {
            this.trigger(T_CLOSE_PROMPT);
        }
    }

    public void selectBlockType() {
        this.trigger(T_SELECT_TYPE);
    }

    public void openHelp() {
        this.trigger(T_OPEN_HELP);
    }

    protected void configureUiStateMachine() {
        log.info("configureUiStateMachine()");
        this.uiFsm = new StateMachine();
        StateMachine<String, String> fsm = this.uiFsm;
        fsm.addDefaultTermination((Object)T_EXIT);
        fsm.addDefaultTransition((Object)T_RETURN_TO_GAME, (Object)STATE_IN_GAME);
        fsm.addDefaultTransition((Object)T_OPEN_GAME_MENU, (Object)STATE_GAME_MENU);
        fsm.addDefaultTransition((Object)T_OPEN_PLAYER_BOOK, (Object)STATE_PLAYER_BOOK);
        fsm.addDefaultTransition((Object)T_OPEN_CONTAINER_VIEW, (Object)STATE_CONTAINER_VIEW);
        fsm.addDefaultTransition((Object)T_OPEN_SETTINGS_MENU, (Object)STATE_SETTINGS);
        fsm.addDefaultTransition((Object)T_SELECT_TYPE, (Object)STATE_SELECT_TYPE);
        fsm.addDefaultTransition((Object)T_OPEN_HELP, (Object)STATE_HELP);
        fsm.addDefaultTransition((Object)T_OPEN_PROMPT, (Object)STATE_PROMPT);
        fsm.setStart((Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_GAME_MENU).addTransition((Object)T_OPEN_GAME_MENU, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_PLAYER_BOOK).addTransition((Object)T_OPEN_PLAYER_BOOK, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_CONTAINER_VIEW).addTransition((Object)T_OPEN_CONTAINER_VIEW, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_SETTINGS).addTransition((Object)T_OPEN_GAME_MENU, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_SELECT_TYPE).addTransition((Object)T_SELECT_TYPE, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_HELP).addTransition((Object)T_OPEN_HELP, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_PROMPT).addTransition((Object)T_CLOSE_PROMPT, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_IN_GAME).onEnter(() -> {
            ((MovementState)this.getState(MovementState.class)).setEnabled(true);
            ((ActivationInputState)this.getState(ActivationInputState.class)).setEnabled(true);
        }).onExit(() -> {
            ((MovementState)this.getState(MovementState.class)).setEnabled(false);
            ((ActivationInputState)this.getState(ActivationInputState.class)).setEnabled(false);
        });
        fsm.getState((Object)STATE_GAME_MENU).onEnter(() -> ((InGameMenuState)this.getState(InGameMenuState.class)).setEnabled(true)).onExit(() -> ((InGameMenuState)this.getState(InGameMenuState.class)).setEnabled(false));
        fsm.getState((Object)STATE_PLAYER_BOOK).onEnter(() -> ((PlayerMenuState)this.getState(PlayerMenuState.class)).setEnabled(true)).onExit(() -> ((PlayerMenuState)this.getState(PlayerMenuState.class)).setEnabled(false));
        fsm.getState((Object)STATE_CONTAINER_VIEW).onEnter(() -> {
            ((ContainerViewState)this.getState(ContainerViewState.class)).setEnabled(true);
            ((UserPromptState)this.getState(UserPromptState.class)).setEnabled(true);
        }).onExit(() -> {
            ((ContainerViewState)this.getState(ContainerViewState.class)).setEnabled(false);
            ((UserPromptState)this.getState(UserPromptState.class)).setEnabled(false);
        });
        fsm.getState((Object)STATE_SETTINGS).onEnter(() -> {
            ((GameSettingsState)this.getState(GameSettingsState.class)).setCentered(false);
            ((GameSettingsState)this.getState(GameSettingsState.class)).setEnabled(true);
        }).onExit(() -> {
            ((GameSettingsState)this.getState(GameSettingsState.class)).setEnabled(false);
            ((GameSettingsState)this.getState(GameSettingsState.class)).setCentered(true);
        });
        fsm.getState((Object)STATE_SELECT_TYPE).onEnter(() -> ((BlockTypeSelectionState)this.getState(BlockTypeSelectionState.class)).open()).onExit(() -> ((BlockTypeSelectionState)this.getState(BlockTypeSelectionState.class)).setEnabled(false));
        fsm.getState((Object)STATE_HELP).onEnter(() -> ((HelpMenuState)this.getState(HelpMenuState.class)).setEnabled(true)).onExit(() -> ((HelpMenuState)this.getState(HelpMenuState.class)).setEnabled(false));
        fsm.getState((Object)STATE_PROMPT).onEnter(() -> ((UserPromptState)this.getState(UserPromptState.class)).setEnabled(true)).onExit(() -> ((UserPromptState)this.getState(UserPromptState.class)).setEnabled(false));
    }
}

