/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.awt;

import com.jme3.cursors.plugins.JmeCursor;
import com.jme3.input.MouseInput;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class AwtMouseInput
implements MouseInput,
MouseListener,
MouseWheelListener,
MouseMotionListener {
    public static int WHEEL_AMP = 40;
    private static final Logger logger = Logger.getLogger(AwtMouseInput.class.getName());
    private boolean visible = true;
    private RawInputListener listener;
    private Component component;
    private final ArrayList<MouseButtonEvent> eventQueue = new ArrayList();
    private final ArrayList<MouseButtonEvent> eventQueueCopy = new ArrayList();
    private int lastEventX;
    private int lastEventY;
    private int lastEventWheel;
    private Cursor transparentCursor;
    private Robot robot;
    private int wheelPos;
    private Point location = new Point();
    private Point centerLocation = new Point();
    private Point centerLocationOnScreen = new Point();
    private Point lastKnownLocation = new Point();
    private boolean isRecentering;
    private boolean cursorMoved;
    private int eventsSinceRecenter;

    public AwtMouseInput() {
        try {
            this.robot = new Robot();
        }
        catch (AWTException e) {
            logger.log(Level.SEVERE, "Could not create a robot, so the mouse cannot be grabbed! ", e);
        }
    }

    public void setInputSource(Component comp) {
        if (this.component != null) {
            this.component.removeMouseListener(this);
            this.component.removeMouseMotionListener(this);
            this.component.removeMouseWheelListener(this);
            this.eventQueue.clear();
            this.wheelPos = 0;
            this.isRecentering = false;
            this.eventsSinceRecenter = 0;
            this.lastEventX = 0;
            this.lastEventY = 0;
            this.lastEventWheel = 0;
            this.location = new Point();
            this.centerLocation = new Point();
            this.centerLocationOnScreen = new Point();
            this.lastKnownLocation = new Point();
        }
        this.component = comp;
        this.component.addMouseListener(this);
        this.component.addMouseMotionListener(this);
        this.component.addMouseWheelListener(this);
    }

    public void initialize() {
    }

    public void destroy() {
    }

    public boolean isInitialized() {
        return true;
    }

    public void setInputListener(RawInputListener listener) {
        this.listener = listener;
    }

    public long getInputTimeNanos() {
        return System.nanoTime();
    }

    public void setCursorVisible(boolean visible) {
        if (this.visible != visible) {
            this.lastKnownLocation.y = 0;
            this.lastKnownLocation.x = 0;
            this.visible = visible;
            final boolean newVisible = visible;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AwtMouseInput.this.component.setCursor(newVisible ? null : AwtMouseInput.this.getTransparentCursor());
                    if (!newVisible) {
                        AwtMouseInput.this.recenterMouse(AwtMouseInput.this.component);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        if (this.cursorMoved) {
            int newX = this.location.x;
            int newY = this.location.y;
            int newWheel = this.wheelPos;
            int actualX = this.lastKnownLocation.x;
            int actualY = this.component.getHeight() - this.lastKnownLocation.y;
            MouseMotionEvent evt = new MouseMotionEvent(actualX, actualY, newX - this.lastEventX, this.lastEventY - newY, this.wheelPos, this.lastEventWheel - this.wheelPos);
            this.listener.onMouseMotionEvent(evt);
            this.lastEventX = newX;
            this.lastEventY = newY;
            this.lastEventWheel = newWheel;
            this.cursorMoved = false;
        }
        ArrayList<MouseButtonEvent> newX = this.eventQueue;
        synchronized (newX) {
            this.eventQueueCopy.clear();
            this.eventQueueCopy.addAll(this.eventQueue);
            this.eventQueue.clear();
        }
        int size = this.eventQueueCopy.size();
        for (int i = 0; i < size; ++i) {
            this.listener.onMouseButtonEvent(this.eventQueueCopy.get(i));
        }
    }

    private Cursor getTransparentCursor() {
        if (this.transparentCursor == null) {
            BufferedImage cursorImage = new BufferedImage(1, 1, 2);
            cursorImage.setRGB(0, 0, 0);
            this.transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, new Point(0, 0), "empty cursor");
        }
        return this.transparentCursor;
    }

    public int getButtonCount() {
        return 3;
    }

    @Override
    public void mouseClicked(MouseEvent awtEvt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent awtEvt) {
        int y = this.component.getHeight() - awtEvt.getY();
        MouseButtonEvent evt = new MouseButtonEvent(this.getJMEButtonIndex(awtEvt), true, awtEvt.getX(), y);
        evt.setTime(awtEvt.getWhen());
        ArrayList<MouseButtonEvent> arrayList = this.eventQueue;
        synchronized (arrayList) {
            this.eventQueue.add(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent awtEvt) {
        int y = this.component.getHeight() - awtEvt.getY();
        MouseButtonEvent evt = new MouseButtonEvent(this.getJMEButtonIndex(awtEvt), false, awtEvt.getX(), y);
        evt.setTime(awtEvt.getWhen());
        ArrayList<MouseButtonEvent> arrayList = this.eventQueue;
        synchronized (arrayList) {
            this.eventQueue.add(evt);
        }
    }

    @Override
    public void mouseEntered(MouseEvent awtEvt) {
        if (!this.visible) {
            this.recenterMouse(awtEvt.getComponent());
        }
    }

    @Override
    public void mouseExited(MouseEvent awtEvt) {
        if (!this.visible) {
            this.recenterMouse(awtEvt.getComponent());
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent awtEvt) {
        int dwheel = awtEvt.getUnitsToScroll();
        this.wheelPos += dwheel * WHEEL_AMP;
        this.cursorMoved = true;
    }

    @Override
    public void mouseDragged(MouseEvent awtEvt) {
        this.mouseMoved(awtEvt);
    }

    @Override
    public void mouseMoved(MouseEvent awtEvt) {
        if (this.isRecentering) {
            if (this.centerLocation.x == awtEvt.getX() && this.centerLocation.y == awtEvt.getY() || this.eventsSinceRecenter++ == 5) {
                this.lastKnownLocation.x = awtEvt.getX();
                this.lastKnownLocation.y = awtEvt.getY();
                this.isRecentering = false;
            }
        } else {
            int dx = awtEvt.getX() - this.lastKnownLocation.x;
            int dy = awtEvt.getY() - this.lastKnownLocation.y;
            this.location.x += dx;
            this.location.y += dy;
            if (!this.visible) {
                this.recenterMouse(awtEvt.getComponent());
            }
            this.lastKnownLocation.x = awtEvt.getX();
            this.lastKnownLocation.y = awtEvt.getY();
            this.cursorMoved = true;
        }
    }

    private void recenterMouse(Component component) {
        if (this.robot != null) {
            this.eventsSinceRecenter = 0;
            this.isRecentering = true;
            this.centerLocation.setLocation(component.getWidth() / 2, component.getHeight() / 2);
            this.centerLocationOnScreen.setLocation(this.centerLocation);
            SwingUtilities.convertPointToScreen(this.centerLocationOnScreen, component);
            this.robot.mouseMove(this.centerLocationOnScreen.x, this.centerLocationOnScreen.y);
        }
    }

    private int getJMEButtonIndex(MouseEvent awtEvt) {
        int index;
        switch (awtEvt.getButton()) {
            default: {
                index = 0;
                break;
            }
            case 2: {
                index = 2;
                break;
            }
            case 3: {
                index = 1;
            }
        }
        return index;
    }

    public void setNativeCursor(JmeCursor cursor) {
    }
}

