/*
 * $Id$
 * 
 * Copyright (c) 2022, Simsilica, LLC
 * All rights reserved.
 */
import mythruna.shell.*;
import mythruna.net.server.AccountHostedService;
import mythruna.net.server.GameSessionHostedService;

addShellCommand = { CommandShell target, String name, List help, Closure doIt ->
    ShellCommand cmd = new AbstractShellCommand(help as String[]) {
                public Object execute( CommandShell shell, String args ) {
                    int length = doIt.getParameterTypes().length;
                    if( length == 2 ) {
                        doIt(shell, args);
                    } else { 
                        doIt(args);
                    }                    
                    return null;
                }        
            }; 
    target.addCommand(name, cmd); 
    return cmd;           
} 

adminCommand = { String name, List help, Closure doIt ->
    addShellCommand(server.adminShell, name, help, doIt);
    //ShellCommand cmd = new AbstractShellCommand(help as String[]) {
    //            public Object execute( CommandShell shell, String args ) {
    //                int length = doIt.getParameterTypes().length;
    //                if( length == 2 ) {
    //                    doIt(shell, args);
    //                } else { 
    //                    doIt(args);
    //                }                    
    //                return null;
    //            }        
    //        }; 
    //server.adminShell.addCommand(name, cmd); 
    //return cmd;           
} 

// Add some standard shell commands
def help = [
    "<connection#> [message] - disconnects the specified connection.",
    "Where:",
    "  <connection#> - is the integer connection number.",
    "  [message] - is an optional message to send with the disconnect."
    ];
adminCommand("kick", help) { args ->
    def id;
    def message;
    int split = args.indexOf(' ');
    if( split < 0 ) {
        id = args as int;
        message = "The admin has closed your connection."
    } else {
        id = args.substring(0, split) as int;
        message = args.substring(split + 1);
    }
    def conn = server.server.getConnection(id);
    if( conn == null ) {
        throw new IllegalArgumentException("Invalid connection ID:" + id);
    }
    log.info("Disconnecting:" + conn);
    conn.close(message);
}    

getAccount = { String id ->
    if( id.isInteger() ) {
        def conn = server.server.getConnection(id as int);
        if( conn == null ) {
            throw new IllegalArgumentException("ID is not an active connection:" + id);
        }
        def account = AccountHostedService.getAccount(conn);
        if( account == null ) {
            throw new IllegalArgumentException("Connection is not logged in yet:" + id);
        }
        return account;      
    } else {
        def account = accountManager.getAccount(id);
        if( account == null ) {
            throw new IllegalArgumentException("User ID is not a valid user:" + id)
        }
        return account; 
    }
}

help = [
    "<connection#|userId> - bans the specified user from future logins.",
    "Where:",
    "  <connection#|userId> - is the connection number of the user to",
    "       ban or their user ID."
    ];
adminCommand("ban", help) { shell, args ->
    def account = getAccount(args);
    account.setProperty("banned", true);
    account.setProperty("bannedUpdateTime", System.currentTimeMillis());
    account.save();
    shell.getOutput().accept("Banned:" + account.getUserId());    
}

help = [
    "<connection#|userId> - unbans a player that was previously banned.",
    "Where:",
    "  <connection#|userId> - is the connection number of the user to",
    "       unban or their user ID."
    ];
adminCommand("unban", help) { shell, args ->
    def account = getAccount(args);
    account.setProperty("banned", false);
    account.setProperty("bannedUpdateTime", System.currentTimeMillis());
    account.save();
    shell.getOutput().accept("Unbanned:" + account.getUserId());    
}


on( playerEntityJoined ) { event ->
 
    def account = AccountHostedService.getAccount(event.connection);
    log.info("Entity joined for account:" + account);
    
    def perms = account.getProperty("permissions", List.class);    
    if( perms?.contains("admin") ) {
        log.info("Need to add admin commands to player:" + account.getName());
        
        def shell = GameSessionHostedService.getShell(event.connection);        
        server.adminShell.getCommands().entrySet().each {
            log.info("Adding command:" + it); 
            shell.addCommand(it.key, it.value);
        }               
    }
    
    

}
