/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.view;

import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FogSettings
implements VersionedObject<FogSettings> {
    static Logger log = LoggerFactory.getLogger(FogSettings.class);
    private long version;
    private ColorRGBA fogColor = new ColorRGBA(0.7f, 0.7f, 0.9f, 1.0f);
    private int fogDistance = 3072;

    public FogSettings() {
    }

    public FogSettings(ColorRGBA fogColor) {
        this.fogColor.set(fogColor);
    }

    public void setFogColor(ColorRGBA fogColor) {
        this.fogColor.set(fogColor);
        ++this.version;
    }

    public ColorRGBA getFogColor() {
        return this.fogColor;
    }

    public void setFogDistance(int fogDistance) {
        if (this.fogDistance == fogDistance) {
            return;
        }
        this.fogDistance = fogDistance;
        ++this.version;
    }

    public int getFogDistance() {
        return this.fogDistance;
    }

    public void apply(Material material) {
        if (this.fogDistance == 0) {
            material.setBoolean("UseFog", false);
        } else {
            material.setBoolean("UseFog", true);
            material.setColor("FogColor", this.fogColor);
            material.setFloat("ExpFog", 1.0f / (float)this.fogDistance);
        }
    }

    public long getVersion() {
        return this.version;
    }

    public FogSettings getObject() {
        return this;
    }

    public VersionedReference<FogSettings> createReference() {
        return new VersionedReference((VersionedObject)this);
    }
}

