/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.action;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.simsilica.action.ObjectAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectType<A, T> {
    static Logger log = LoggerFactory.getLogger(ObjectType.class);
    private String name;
    private ListMultimap<String, ObjectAction<A, T>> actionIndex;
    private Map<String, Object> vars = new HashMap<String, Object>();
    private Set<ObjectType<A, T>> superTypes = new LinkedHashSet<ObjectType<A, T>>();
    private Set<ObjectType<A, T>> flattenedTypes = null;
    private ListMultimap<String, ObjectAction<A, T>> flattenedIndex;

    @SafeVarargs
    public ObjectType(String name, ObjectAction<A, T> ... actions) {
        this(name, Arrays.asList(actions));
    }

    public ObjectType(String name, List<ObjectAction<A, T>> actions) {
        this.name = name;
        this.actionIndex = MultimapBuilder.linkedHashKeys().arrayListValues().build();
        for (ObjectAction<A, T> action : actions) {
            this.actionIndex.put((Object)action.getName(), action);
        }
    }

    public void addAction(ObjectAction<A, T> action) {
        this.actionIndex.put((Object)action.getName(), action);
    }

    public void addSuperType(ObjectType<A, T> type) {
        this.superTypes.add(type);
    }

    public String getName() {
        return this.name;
    }

    public Iterable<ObjectType<A, T>> getSuperTypes() {
        return this.superTypes;
    }

    protected Set<ObjectType<A, T>> getFlattenedTypes() {
        if (log.isTraceEnabled()) {
            log.trace("getFlattenedTypes()");
        }
        if (this.flattenedTypes != null) {
            return this.flattenedTypes;
        }
        log.info("Constructing flattened supertypes for:" + this.getName());
        this.flattenedTypes = new LinkedHashSet<ObjectType<A, T>>(this.superTypes);
        LinkedList<ObjectType<A, T>> queue = new LinkedList<ObjectType<A, T>>();
        queue.addAll(this.superTypes);
        ObjectType parent = null;
        while ((parent = (ObjectType)queue.poll()) != null) {
            log.info("  expanding:" + parent.getName());
            for (ObjectType<A, T> type : parent.superTypes) {
                if (!this.flattenedTypes.add(type)) continue;
                queue.addAll(parent.superTypes);
            }
            this.flattenedTypes.addAll(parent.superTypes);
            queue.addAll(parent.superTypes);
        }
        return this.flattenedTypes;
    }

    protected ListMultimap<String, ObjectAction<A, T>> getFlattenedIndex() {
        if (log.isTraceEnabled()) {
            log.trace("getFlattenedIndex()");
        }
        if (this.flattenedIndex != null) {
            return this.flattenedIndex;
        }
        log.info("Constructing flattened action index for:" + this.getName());
        this.flattenedIndex = MultimapBuilder.linkedHashKeys().arrayListValues().build();
        this.flattenedIndex.putAll(this.actionIndex);
        log.info("Existing actions:");
        for (ObjectAction objectAction : this.flattenedIndex.values()) {
            log.info("  :" + objectAction.getName() + Arrays.asList(objectAction.getParamTypes()));
        }
        for (ObjectType objectType : this.getFlattenedTypes()) {
            log.info("Grafting in actions from supertype:" + objectType.getName());
            for (Map.Entry e : objectType.actionIndex.entries()) {
                List existing = this.flattenedIndex.get(e.getKey());
                if (existing.isEmpty()) {
                    log.info("No overridden action with same name, deferring directly:" + (String)e.getKey());
                    this.flattenedIndex.put(e.getKey(), e.getValue());
                    continue;
                }
                List<Class> parms = Arrays.asList(((ObjectAction)e.getValue()).getParamTypes());
                boolean found = false;
                for (ObjectAction check : existing) {
                    List<Class> existingParms = Arrays.asList(check.getParamTypes());
                    if (!parms.equals(existingParms)) continue;
                    log.info("Action already exists in subtype:" + check.getName() + existingParms);
                    found = true;
                    break;
                }
                if (found) continue;
                log.info("No overridden action with same parameters, adding:" + (String)e.getKey() + parms);
                this.flattenedIndex.put(e.getKey(), e.getValue());
            }
        }
        log.info("Final actions:");
        for (ObjectAction objectAction : this.flattenedIndex.values()) {
            log.info("  :" + objectAction.getName() + Arrays.asList(objectAction.getParamTypes()));
        }
        return this.flattenedIndex;
    }

    public Set<String> getActionNames() {
        Set result = this.getFlattenedIndex().keySet();
        return Collections.unmodifiableSet(result);
    }

    public void setTypeVar(String name, Object value) {
        this.vars.put(name, value);
    }

    public <V> V getTypeVar(String name, V defaultValue) {
        Object result = this.vars.get(name);
        if (result != null) {
            return (V)result;
        }
        for (ObjectType<A, T> type : this.getFlattenedTypes()) {
            result = type.vars.get(name);
            if (result == null) continue;
            return (V)result;
        }
        return defaultValue;
    }

    public List<ObjectAction<A, T>> getContextActions() {
        ArrayList<ObjectAction<A, T>> results = new ArrayList<ObjectAction<A, T>>();
        Object[] noArgs = new Object[]{};
        for (ObjectAction action : this.getFlattenedIndex().values()) {
            if (!this.matches(action.getParamTypes(), noArgs) || !Character.isUpperCase(action.getName().charAt(0))) continue;
            results.add(action);
        }
        return results;
    }

    public ObjectAction<A, T> findAction(String name, Object ... args) {
        if (log.isTraceEnabled()) {
            log.trace("findAction(" + name + ", " + Arrays.asList(args) + ")");
        }
        for (ObjectAction action : this.getFlattenedIndex().get((Object)name)) {
            if (!this.matches(action.getParamTypes(), args)) continue;
            return action;
        }
        return null;
    }

    public List<ObjectAction<A, T>> findNamedActions(String name) {
        if (log.isTraceEnabled()) {
            log.trace("findNamedActions(" + name + ")");
        }
        List results = this.getFlattenedIndex().get((Object)name);
        return Collections.unmodifiableList(results);
    }

    public List<ObjectAction<A, T>> findTypedActions(Object ... args) {
        if (log.isTraceEnabled()) {
            log.trace("findTypedActions(" + Arrays.asList(args) + ")");
        }
        ArrayList<ObjectAction<A, T>> results = new ArrayList<ObjectAction<A, T>>();
        for (ObjectAction action : this.getFlattenedIndex().values()) {
            if (!this.matches(action.getParamTypes(), args)) continue;
            results.add(action);
        }
        return results;
    }

    protected boolean matches(Class[] types, Object[] args) {
        if (types.length != args.length) {
            return false;
        }
        int count = types.length;
        for (int i = 0; i < count; ++i) {
            if (args[i] == null || types[i].isInstance(args[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name:" + this.name + "]";
    }
}

