/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net.server;

import com.jme3.network.HostedConnection;
import com.jme3.network.service.AbstractHostedConnectionService;
import com.jme3.network.service.HostedServiceManager;
import com.jme3.network.service.ServiceManager;
import com.jme3.network.service.rmi.RmiHostedService;
import com.jme3.network.service.rmi.RmiRegistry;
import com.simsilica.action.ActionContext;
import com.simsilica.action.ActionEnvironment;
import com.simsilica.action.ObjectType;
import com.simsilica.action.ObjectTypeRegistry;
import com.simsilica.action.Option;
import com.simsilica.action.PromptProvider;
import com.simsilica.action.PromptType;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.bpos.net.BodyVisibility;
import com.simsilica.crig.es.AnimationConfig;
import com.simsilica.crig.es.LayerConfig;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.CreatedBy;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import com.simsilica.es.server.ComponentVisibility;
import com.simsilica.es.server.EntityDataHostedService;
import com.simsilica.es.server.HostedEntityData;
import com.simsilica.ethereal.EtherealHost;
import com.simsilica.event.EventBus;
import com.simsilica.event.EventType;
import com.simsilica.event.PlayerEntityEvent;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Rayd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.db.CellArrayId;
import com.simsilica.mblock.db.CellArrayStorage;
import com.simsilica.mblock.io.BlocksFileFormat;
import com.simsilica.mblock.phys.MBlockCollisionSystem;
import com.simsilica.mworld.BlockIterator;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.base.DefaultWorld;
import com.simsilica.mworld.io.CellArrayProtocol;
import com.simsilica.net.server.ChatHostedService;
import com.simsilica.sim.GameSystemManager;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import mythruna.GameConstants;
import mythruna.cmd.Command;
import mythruna.cmd.CommandSystem;
import mythruna.cmd.Context;
import mythruna.es.AttachedTo;
import mythruna.es.BlueprintInfo;
import mythruna.es.ContainedIn;
import mythruna.es.ContainerVolume;
import mythruna.es.Holding;
import mythruna.es.MovementInput;
import mythruna.es.ObjectName;
import mythruna.es.ObjectTypeInfo;
import mythruna.es.ObjectVolume;
import mythruna.net.BlueprintData;
import mythruna.net.GameSession;
import mythruna.net.GameSessionListener;
import mythruna.shell.CommandShell;
import mythruna.shell.ShellService;
import mythruna.sim.Activator;
import mythruna.sim.PathRecorderSystem;
import mythruna.world.WorldManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameSessionHostedService
extends AbstractHostedConnectionService {
    static Logger log = LoggerFactory.getLogger(GameSessionHostedService.class);
    private static final String ATTRIBUTE_SESSION = GameSessionHostedService.class.getName();
    private static final String ATTRIBUTE_SHELL = "playerShell";
    private GameSystemManager gameSystems;
    private EntityData ed;
    private CommandSystem<GameSessionImpl, EntityId> cmdProc;
    private RmiHostedService rmiService;
    private List<GameSessionImpl> players = new CopyOnWriteArrayList<GameSessionImpl>();
    private ObjectTypeRegistry<Activator, EntityId> objectTypes;
    private ObjectType<Activator, EntityId> wandType;

    public GameSessionHostedService(GameSystemManager gameSystems) {
        this.gameSystems = gameSystems;
        this.setAutoHost(false);
    }

    public static CommandShell getShell(HostedConnection conn) {
        return (CommandShell)conn.getAttribute(ATTRIBUTE_SHELL);
    }

    protected void setupObjectTypes() {
        this.objectTypes = (ObjectTypeRegistry)this.gameSystems.get(ObjectTypeRegistry.class);
        this.wandType = this.objectTypes.getType("BuildWand");
    }

    protected void onInitialize(HostedServiceManager s) {
        this.rmiService = (RmiHostedService)this.getService(RmiHostedService.class);
        if (this.rmiService == null) {
            throw new RuntimeException("GameSessionHostedService requires an RMI service.");
        }
    }

    public void terminate(HostedServiceManager serviceManager) {
        super.terminate((ServiceManager)serviceManager);
    }

    public void start() {
        super.start();
        EntityDataHostedService eds = (EntityDataHostedService)this.getService(EntityDataHostedService.class);
        if (eds == null) {
            throw new RuntimeException("AccountHostedService requires an EntityDataHostedService");
        }
        this.ed = eds.getEntityData();
        this.cmdProc = (CommandSystem)((Object)this.gameSystems.get(CommandSystem.class));
        this.cmdProc.registerCommand("record", new RecordCommand(), new Class[0]);
        this.cmdProc.registerCommand("play", new PlayCommand(), new Class[0]);
        this.cmdProc.registerCommand("stop", new StopCommand(), new Class[0]);
        ActivateCommand activate = new ActivateCommand();
        this.cmdProc.registerCommand("activatePrimary", activate, new Class[0]);
        this.cmdProc.registerCommand("activatePrimaryAlt", activate, new Class[0]);
        this.cmdProc.registerCommand("activateSecondary", activate, new Class[0]);
        this.cmdProc.registerCommand("activateSecondaryAlt", activate, new Class[0]);
        for (String s : this.cmdProc.getCommandNames()) {
            this.ed.getStrings().getStringId(s, true);
        }
        this.setupObjectTypes();
        for (ObjectType type : this.objectTypes) {
            for (String s : type.getActionNames()) {
                this.ed.getStrings().getStringId(s, true);
            }
        }
        ObjectType defaultType = this.objectTypes.getDefaultType();
        if (defaultType != null) {
            for (String s : defaultType.getActionNames()) {
                this.ed.getStrings().getStringId(s, true);
            }
        }
        this.createDefaultBlueprint("Chair", "Chair", "/Models/objects/chair.blocks", false, 0.25);
        this.createDefaultBlueprint("Desk", "Desk", "/Models/objects/desk.blocks", true, 0.25);
        this.createDefaultBlueprint("Stool", "Stool", "/Models/objects/stool.blocks", false, 0.25);
        this.createDefaultBlueprint("Table", "Table", "/Models/objects/table.blocks", false, 0.25);
    }

    public void startHostingOnConnection(HostedConnection conn) {
        throw new UnsupportedOperationException("Autohosting not supported");
    }

    public void startHostingOnConnection(HostedConnection conn, EntityId character) {
        log.debug("startHostingOnConnection(" + conn + ", " + character + ")");
        GameSessionImpl session = new GameSessionImpl(conn, character);
        conn.setAttribute(ATTRIBUTE_SESSION, (Object)session);
        RmiRegistry rmi = this.rmiService.getRmiRegistry(conn);
        rmi.share((Object)session, GameSession.class);
        this.players.add(session);
        session.initialize();
        ((ChatHostedService)this.getService(ChatHostedService.class)).startHostingOnConnection(conn, session.getPlayerName());
    }

    protected GameSessionImpl getGameSession(HostedConnection conn) {
        return (GameSessionImpl)conn.getAttribute(ATTRIBUTE_SESSION);
    }

    public void stopHostingOnConnection(HostedConnection conn) {
        log.debug("stopHostingOnConnection(" + conn + ")");
        GameSessionImpl session = this.getGameSession(conn);
        if (session != null) {
            session.close();
            this.players.remove(session);
            conn.setAttribute(ATTRIBUTE_SESSION, null);
        }
    }

    protected CellArray loadCells(String resource) {
        try {
            return BlocksFileFormat.loadCellArray((String)resource);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading:" + resource, e);
        }
    }

    protected Set<EntityId> findDefaultBlueprints() {
        EntityId parent = ((WorldManager)this.gameSystems.get(WorldManager.class, true)).getWorldEntity();
        ComponentFilter filter = Filters.fieldEquals(BlueprintInfo.class, (String)"parent", (Object)parent);
        return this.ed.findEntities(filter, new Class[]{BlueprintInfo.class});
    }

    protected EntityId copyBlueprint(EntityId bp, EntityId target) {
        BlueprintInfo bpInfo = (BlueprintInfo)this.ed.getComponent(bp, BlueprintInfo.class);
        ComponentFilter filter1 = Filters.fieldEquals(BlueprintInfo.class, (String)"parent", (Object)target);
        ComponentFilter filter2 = Filters.fieldEquals(BlueprintInfo.class, (String)"name", (Object)bpInfo.getName());
        ComponentFilter filter = Filters.and(BlueprintInfo.class, (ComponentFilter[])new ComponentFilter[]{filter1, filter2});
        EntityId entity = this.ed.findEntity(filter, new Class[]{BlueprintInfo.class});
        if (entity != null) {
            log.info("Player:" + target + " already has bp:" + bpInfo);
        } else {
            log.info("Creating:" + bpInfo + " on player:" + target);
            entity = this.ed.createEntity();
        }
        this.ed.setComponents(entity, new EntityComponent[]{bpInfo.changeParent(target), this.ed.getComponent(bp, ObjectName.class), this.ed.getComponent(bp, ShapeInfo.class), this.ed.getComponent(bp, CreatedBy.class)});
        return entity;
    }

    protected EntityId createDefaultBlueprint(String bpName, String objectName, String blocks, boolean carved, double scale) {
        EntityId parent = ((WorldManager)this.gameSystems.get(WorldManager.class, true)).getWorldEntity();
        ComponentFilter filter1 = Filters.fieldEquals(BlueprintInfo.class, (String)"parent", (Object)parent);
        ComponentFilter filter2 = Filters.fieldEquals(BlueprintInfo.class, (String)"name", (Object)bpName);
        ComponentFilter filter = Filters.and(BlueprintInfo.class, (ComponentFilter[])new ComponentFilter[]{filter1, filter2});
        EntityId entity = this.ed.findEntity(filter, new Class[]{BlueprintInfo.class});
        if (entity == null) {
            entity = this.ed.createEntity();
            log.info("Creating default blueprint for:" + bpName);
        } else {
            BlueprintInfo bpInfo = (BlueprintInfo)this.ed.getComponent(entity, BlueprintInfo.class);
            log.info("Found existing blueprint for:" + bpName + " : " + bpInfo);
        }
        CellArrayStorage storage = (CellArrayStorage)this.gameSystems.get(CellArrayStorage.class);
        CellArray cells = this.loadCells(blocks);
        CellArrayId cellId = storage.store(cells);
        Vec3i offset = new Vec3i();
        offset.x = 5 - cells.getSizeX() / 2;
        offset.z = 5 - cells.getSizeZ() / 2;
        String shapeName = cellId.toFileName();
        if (carved) {
            shapeName = "c_" + shapeName;
        }
        log.info("createing shapeId:" + shapeName);
        this.ed.setComponents(entity, new EntityComponent[]{new BlueprintInfo(parent, bpName, offset), ObjectName.create(objectName, this.ed), ShapeInfo.create((String)shapeName, (double)scale, (EntityData)this.ed), new CreatedBy(parent)});
        return entity;
    }

    protected EntityId findItem(EntityId root, String name) {
        log.info("findItem(" + root + ", " + name + ")");
        ComponentFilter filter = Filters.fieldEquals(ContainedIn.class, (String)"root", (Object)root);
        for (EntityId item : this.ed.findEntities(filter, new Class[]{ContainedIn.class})) {
            log.info("    Checking:" + item + "  name:" + this.ed.getComponent(item, Name.class) + "  on:" + this.ed.getComponent(item, ObjectName.class));
            Name n = (Name)this.ed.getComponent(item, Name.class);
            if (n != null && Objects.equals(n.getName(), name)) {
                return item;
            }
            ObjectName on = (ObjectName)this.ed.getComponent(item, ObjectName.class);
            if (on == null || !Objects.equals(on.getName(this.ed), name)) continue;
            return item;
        }
        return null;
    }

    protected EntityId createBuildWand(EntityId target) {
        EntityId existing = this.findItem(target, "Build Wand");
        if (existing != null) {
            log.info("Test entity already exists:" + existing);
            log.info("Removing it");
            this.ed.removeEntity(existing);
        }
        double itemScale = 0.0625;
        itemScale *= 0.5;
        Quatd rot = new Quatd().fromAngles(0.0, 1.5707963267948966, 0.0);
        Vec3d handle = new Vec3d(1.5, 1.5, 3.0);
        handle.multLocal(-(itemScale *= 0.5));
        rot.mult(handle, handle);
        EntityId item = this.ed.createEntity();
        this.ed.setComponents(item, new EntityComponent[]{ObjectName.create("Build Wand", this.ed), new Mass(0.01), new ObjectVolume(new Vec3d(3.0, 3.0, 13.0).multLocal(itemScale)), ShapeInfo.create((String)"/Models/items/wand1.blocks", (double)itemScale, (EntityData)this.ed), ObjectTypeInfo.create("BuildWand", this.ed)});
        log.info("Created test entity:" + item);
        return item;
    }

    protected EntityId createBackpack(EntityId target) {
        EntityId result = this.findItem(target, "Backpack");
        if (result != null) {
            log.info("Backpack already exists:" + result);
        } else {
            result = this.ed.createEntity();
        }
        double itemScale = 0.0625;
        Quatd rot = new Quatd().fromAngles(0.0, 0.0, 0.0);
        CellArray cells = this.loadCells("/Models/items/backpack2.blocks");
        log.info("backpack cells size:" + cells.getSize() + "  itemScale:" + (itemScale *= 0.5));
        Vec3d blockSize = cells.getSize().toVec3d();
        blockSize.x = 8.0;
        blockSize.z = 5.0;
        Vec3d innerBlockSize = new Vec3d(7.0, 9.0, 3.5);
        Vec3d size = blockSize.mult(itemScale);
        log.info("backpack physical size:" + size);
        Vec3d innerSize = innerBlockSize.mult(itemScale);
        Vec3d offset = size.subtract(innerSize).mult(0.5);
        offset.y = itemScale;
        this.ed.setComponents(result, new EntityComponent[]{ShapeInfo.create((String)"/Models/items/backpack2.blocks", (double)itemScale, (EntityData)this.ed), AttachedTo.create(target, "back", new Vec3d(-4.0 * itemScale, -5.0 * itemScale, 0.0), rot, this.ed), ObjectTypeInfo.create("Backpack", this.ed), ObjectName.create("Backpack", this.ed), new Mass(0.01), new ObjectVolume(size), new ContainerVolume(innerSize, offset), new ContainedIn(target, target, 0, 0), new CreatedBy(target)});
        EntityId item = this.createItem(target, "Sword", "Sword", "/Models/items/sword1.blocks", itemScale);
        this.ed.setComponents(item, new EntityComponent[]{new ContainedIn(target, result, 2, 0)});
        item = this.createItem(target, "Axe", "Axe", "/Models/items/axe1.blocks", itemScale);
        this.ed.setComponents(item, new EntityComponent[]{new ContainedIn(target, result, 6, 0)});
        item = this.createItem(target, "Book", "Book", "/Models/items/book.blocks", itemScale);
        this.ed.setComponents(item, new EntityComponent[]{new ContainedIn(target, result, 10, 0)});
        item = this.createItem(target, "Object Tool", "ObjectTool", "/Models/items/etcher.blocks", itemScale * 0.5);
        this.ed.setComponents(item, new EntityComponent[]{new ContainedIn(target, result, 16, 0)});
        return result;
    }

    protected EntityId createItem(EntityId creator, String name, String type, String shape, double scale) {
        EntityId result = this.findItem(creator, name);
        if (result != null) {
            log.info(name + " already exists:" + result);
            log.info(name + ":");
            log.info("     :" + this.ed.getComponent(result, ContainedIn.class));
            log.info("     :" + this.ed.getComponent(result, ObjectVolume.class));
            log.info("     :" + this.ed.getComponent(result, ShapeInfo.class));
            log.info("     :" + this.ed.getComponent(result, AttachedTo.class));
        } else {
            result = this.ed.createEntity();
            log.info("Created " + name + " as:" + result);
        }
        CellArray cells = this.loadCells(shape);
        Vec3d size = cells.getSize().toVec3d();
        if ("/Models/items/sword1.blocks".equals(shape)) {
            size.x = 3.0;
        }
        size.multLocal(scale);
        this.ed.setComponents(result, new EntityComponent[]{ObjectName.create(name, this.ed), new Mass(0.01), ShapeInfo.create((String)shape, (double)scale, (EntityData)this.ed), ObjectTypeInfo.create(type, this.ed), new ObjectVolume(size), new CreatedBy(creator)});
        log.info("After update:" + name + ":");
        log.info("     :" + this.ed.getComponent(result, ContainedIn.class));
        log.info("     :" + this.ed.getComponent(result, ObjectVolume.class));
        log.info("     :" + this.ed.getComponent(result, ShapeInfo.class));
        log.info("     :" + this.ed.getComponent(result, AttachedTo.class));
        return result;
    }

    private class RecordCommand
    implements Command<GameSessionImpl, EntityId> {
        private RecordCommand() {
        }

        @Override
        public void execute(Context<GameSessionImpl> context, String cmd, EntityId subject, Object ... parms) {
            try {
                ((PathRecorderSystem)((Object)GameSessionHostedService.this.gameSystems.get(PathRecorderSystem.class))).record(subject);
            }
            catch (Exception e) {
                log.error("Error running command", (Throwable)e);
                context.getSource().echo(String.valueOf(e));
            }
        }
    }

    private class PlayCommand
    implements Command<GameSessionImpl, EntityId> {
        private PlayCommand() {
        }

        @Override
        public void execute(Context<GameSessionImpl> context, String cmd, EntityId subject, Object ... parms) {
            try {
                ((PathRecorderSystem)((Object)GameSessionHostedService.this.gameSystems.get(PathRecorderSystem.class))).play(subject);
            }
            catch (Exception e) {
                log.error("Error running command", (Throwable)e);
                context.getSource().echo(String.valueOf(e));
            }
        }
    }

    private class StopCommand
    implements Command<GameSessionImpl, EntityId> {
        private StopCommand() {
        }

        @Override
        public void execute(Context<GameSessionImpl> context, String cmd, EntityId subject, Object ... parms) {
            try {
                long duration = ((PathRecorderSystem)((Object)GameSessionHostedService.this.gameSystems.get(PathRecorderSystem.class))).stop(subject);
                context.getSource().echo(String.format("%.02f", (double)duration / 1.0E9));
            }
            catch (Exception e) {
                log.error("Error running command", (Throwable)e);
                context.getSource().echo(String.valueOf(e));
            }
        }
    }

    private class ActivateCommand
    implements Command<GameSessionImpl, EntityId> {
        private ActivateCommand() {
        }

        @Override
        public void execute(Context<GameSessionImpl> context, String cmd, EntityId subject, Object ... parms) {
            log.info(this.getClass().getSimpleName() + "(" + cmd + ", " + Arrays.asList(parms) + ")");
            log.info("parms[0] class:" + parms[0].getClass());
            boolean pressed = Boolean.TRUE.equals(parms[0]);
            if ("activatePrimary".equals(cmd)) {
                throw new UnsupportedOperationException();
            }
            if ("activatePrimaryAlt".equals(cmd)) {
                log.info("**** activatePrimaryAlt ***");
                throw new UnsupportedOperationException();
            }
            if ("activateSecondary".equals(cmd)) {
                if (!pressed) {
                    return;
                }
                Iterator<BlockIterator.Intersection> it = context.getSource().activator.pick();
                if (it.hasNext()) {
                    BlockIterator.Intersection intersect = it.next();
                    DefaultWorld world = (DefaultWorld)GameSessionHostedService.this.gameSystems.get(World.class);
                    ColumnId colId = ColumnId.fromWorld((Vec3d)intersect.getPoint());
                    long start = System.nanoTime();
                    world.recalculateLighting(colId);
                    long end = System.nanoTime();
                    context.getSource().echo(String.format("reset lighting in: %.02f ms", (double)(end - start) / 1000000.0));
                    Vec3d point = intersect.getPoint();
                    int existing = world.getWorldCell(point);
                    world.setWorldCell(point, 1);
                    world.setWorldCell(point, existing);
                }
            } else {
                context.getSource().echo("Unknown command:" + cmd);
            }
        }
    }

    private class GameSessionImpl
    implements GameSession {
        private HostedConnection conn;
        private GameSessionListener callback;
        private EntityId characterEntity;
        private EntityId avatarEntity;
        private CommandShell shell;
        private Vec3d spawnLoc;
        private Quatd spawnRot;
        private Context<GameSessionImpl> commandContext;
        private ActivatorImpl activator;
        private ActionContext<Activator, EntityId> backpack;
        private ActionEnvironment<Activator, EntityId> actionEnv;
        private ActionContext<Activator, EntityId> buildWand;

        public GameSessionImpl(HostedConnection conn, EntityId characterEntity) {
            this.conn = conn;
            this.characterEntity = characterEntity;
            this.avatarEntity = characterEntity;
            this.shell = ((ShellService)GameSessionHostedService.this.gameSystems.get(ShellService.class)).createChildShell(this.avatarEntity);
            this.shell.setOutput(line -> this.callback.newConsoleMessage((String)line));
            conn.setAttribute(GameSessionHostedService.ATTRIBUTE_SHELL, (Object)this.shell);
            this.shell.put("avatar", this.avatarEntity);
            this.commandContext = new Context<GameSessionImpl>(this);
            this.activator = new ActivatorImpl(this.avatarEntity, GameSessionHostedService.this.gameSystems);
            WorldManager world = (WorldManager)GameSessionHostedService.this.gameSystems.get(WorldManager.class, true);
            SpawnPosition pos = (SpawnPosition)GameSessionHostedService.this.ed.getComponent(characterEntity, SpawnPosition.class);
            if (pos == null) {
                log.info("Player has no previous spawn position, getting it from the world...");
                this.spawnLoc = world.getInfo().getSpawnPoint();
                log.info("spawnLoc:" + this.spawnLoc);
                this.spawnLoc.y += 20.0;
                pos = new SpawnPosition(GameConstants.PHYSICS_GRID, this.spawnLoc, new Quatd());
                GameSessionHostedService.this.ed.setComponent(characterEntity, (EntityComponent)pos);
            }
            this.spawnLoc = pos.getLocation();
            this.spawnRot = pos.getOrientation();
            if (Math.floor(this.spawnLoc.x) == this.spawnLoc.x && Math.floor(this.spawnLoc.z) == this.spawnLoc.z) {
                log.info("Adjusting spawn loc to block center");
                this.spawnLoc.x += 0.5;
                this.spawnLoc.z += 0.5;
                pos = new SpawnPosition(GameConstants.PHYSICS_GRID, this.spawnLoc, this.spawnRot);
                GameSessionHostedService.this.ed.setComponent(characterEntity, (EntityComponent)pos);
            }
            pos = new SpawnPosition(GameConstants.PHYSICS_GRID, this.spawnLoc, this.spawnRot);
            GameSessionHostedService.this.ed.setComponent(characterEntity, (EntityComponent)pos);
            int elevation = world.getElevation((int)this.spawnLoc.x, (int)this.spawnLoc.z);
            log.info("spawn loc:" + this.spawnLoc + "  real elevation:" + elevation);
            ShapeInfo femaleShape = ShapeInfo.create((String)"human/female/human-female.rig", (double)1.0, (EntityData)GameSessionHostedService.this.ed);
            GameSessionHostedService.this.ed.setComponents(this.avatarEntity, new EntityComponent[]{new Mass(60.0), femaleShape});
            log.info("Adding animation config to:" + this.avatarEntity);
            EntityId anim = GameSessionHostedService.this.ed.createEntity();
            GameSessionHostedService.this.ed.setComponents(anim, new EntityComponent[]{new AnimationConfig(this.avatarEntity, new LayerConfig[]{new LayerConfig(null, new String[]{"Idle", "Walk", "Jog"})})});
            this.backpack = GameSessionHostedService.this.objectTypes.getContext((Object)GameSessionHostedService.this.createBackpack(this.avatarEntity));
            EntityId test = GameSessionHostedService.this.createBuildWand(this.avatarEntity);
            GameSessionHostedService.this.ed.setComponents(test, new EntityComponent[]{new ContainedIn(this.avatarEntity, (EntityId)this.backpack.getTarget(), 0, 0)});
            this.actionEnv = GameSessionHostedService.this.objectTypes.createEnvironment((Object)this.activator);
            this.actionEnv.setPromptProvider((PromptProvider)new UserPrompts(this));
            this.shell.setVariables(this.actionEnv.getVariables());
            this.activator.vars = this.actionEnv.getVariables();
            this.buildWand = GameSessionHostedService.this.objectTypes.getContext((Object)test);
            GameSessionHostedService.this.ed.setComponents(this.avatarEntity, new EntityComponent[]{Holding.create(test, "Digger", GameSessionHostedService.this.ed)});
            for (EntityId bp : GameSessionHostedService.this.findDefaultBlueprints()) {
                GameSessionHostedService.this.copyBlueprint(bp, this.avatarEntity);
            }
        }

        public String getPlayerName() {
            Name name = (Name)GameSessionHostedService.this.ed.getComponent(this.characterEntity, Name.class);
            return name.getName();
        }

        public void initialize() {
            log.info("GameSessionImpl.initialize()");
            if (this.getCallback(false) != null) {
                this.getCallback(true).setAvatar(this.avatarEntity);
            } else {
                log.warn("No game session callback registered so can't send avatar entity.");
            }
            log.info("Spawning user at:" + this.spawnLoc);
            EtherealHost ethereal = (EtherealHost)GameSessionHostedService.this.getService(EtherealHost.class);
            ethereal.startHostingOnConnection(this.conn);
            ethereal.setConnectionObject(this.conn, Long.valueOf(this.characterEntity.getId()), this.spawnLoc);
            EntityDataHostedService eds = (EntityDataHostedService)GameSessionHostedService.this.getService(EntityDataHostedService.class);
            HostedEntityData hed = eds.getHostedEntityData(this.conn);
            if (hed == null) {
                throw new RuntimeException("Can't get hosted entity data for:" + this.conn);
            }
            hed.registerComponentVisibility((ComponentVisibility)new BodyVisibility(ethereal.getStateListener(this.conn)));
            EventBus.publish((EventType)PlayerEntityEvent.playerEntityJoined, (Object)new PlayerEntityEvent(this.avatarEntity, this.conn));
            log.info("GameSessionImpl.initialized()");
        }

        public void close() {
            log.debug("Closing game session for:" + this.conn);
            EventBus.publish((EventType)PlayerEntityEvent.playerEntityLeaving, (Object)new PlayerEntityEvent(this.avatarEntity, this.conn));
            ((ShellService)GameSessionHostedService.this.gameSystems.get(ShellService.class)).removeShell(this.avatarEntity);
            GameSessionHostedService.this.ed.removeComponent(this.avatarEntity, ShapeInfo.class);
            EventBus.publish((EventType)PlayerEntityEvent.playerEntityLeaving, (Object)new PlayerEntityEvent(this.avatarEntity, this.conn));
        }

        @Override
        public EntityId getCharacter() {
            return this.characterEntity;
        }

        @Override
        public EntityId getAvatar() {
            return this.avatarEntity;
        }

        @Override
        public void setMovementInput(MovementInput input) {
            GameSessionHostedService.this.ed.setComponent(this.avatarEntity, (EntityComponent)input);
        }

        @Override
        public void executeShell(String cmd) {
            this.shell.execute(cmd);
        }

        @Override
        public void executeCommand(int cmdId, EntityId subject, Object ... parms) {
            String cmd = GameSessionHostedService.this.ed.getStrings().getString(cmdId);
            GameSessionHostedService.this.cmdProc.execute(this.commandContext, cmd, subject, parms);
        }

        @Override
        public void executeCommand(String cmd, EntityId subject, Object ... parms) {
            GameSessionHostedService.this.cmdProc.execute(this.commandContext, cmd, subject, parms);
        }

        @Override
        public void runAction(EntityId target, int actionId, Object ... parms) {
            String cmd = GameSessionHostedService.this.ed.getStrings().getString(actionId);
            this.runAction(target, cmd, parms);
        }

        @Override
        public void runAction(EntityId target, String actionName, Object ... parms) {
            this.actionEnv.runAction((Object)target, actionName, parms);
        }

        @Override
        public byte[] getCellArrayBytes(long id) {
            CellArray array = ((CellArrayStorage)GameSessionHostedService.this.gameSystems.get(CellArrayStorage.class)).get(new CellArrayId(id));
            return CellArrayProtocol.toBytes((CellArray)array);
        }

        @Override
        public CellArray getCellArray(CellArrayId id) {
            return ((CellArrayStorage)GameSessionHostedService.this.gameSystems.get(CellArrayStorage.class)).get(id);
        }

        @Override
        public void saveBlueprintData(BlueprintData bpData, byte[] cellArray) {
            BlueprintInfo info;
            EntityId bpEntity;
            bpData.array = CellArrayProtocol.fromBytes((byte[])cellArray);
            log.info("Need to save:" + bpData + "  bytes:" + cellArray.length);
            if (bpData.blueprintId == null) {
                bpEntity = GameSessionHostedService.this.ed.createEntity();
                info = new BlueprintInfo(this.avatarEntity, bpData.name, bpData.offset);
            } else {
                bpEntity = bpData.blueprintId;
                info = (BlueprintInfo)GameSessionHostedService.this.ed.getComponent(bpEntity, BlueprintInfo.class);
                if (info == null) {
                    log.error("BlueprintData refers to non-blueprint ID:" + bpData);
                    return;
                }
                if (!Objects.equals(info.getParent(), this.avatarEntity)) {
                    log.error("BlueprintData does not belong to this player:" + this.avatarEntity + " data:" + bpData);
                    return;
                }
                info = info.changeOffset(bpData.offset);
                info = info.changeName(bpData.name);
            }
            CellArrayStorage storage = (CellArrayStorage)GameSessionHostedService.this.gameSystems.get(CellArrayStorage.class);
            CellArrayId cellId = storage.store(bpData.array);
            String shapeName = cellId.toFileName();
            if (bpData.carved) {
                shapeName = "c_" + shapeName;
            }
            GameSessionHostedService.this.ed.setComponents(bpEntity, new EntityComponent[]{info, ObjectName.create(bpData.objectName, GameSessionHostedService.this.ed), ShapeInfo.create((String)shapeName, (double)bpData.scale, (EntityData)GameSessionHostedService.this.ed), new CreatedBy(this.avatarEntity)});
        }

        @Override
        public void saveBlueprintData(BlueprintData bpData) {
            byte[] bytes = CellArrayProtocol.toBytes((CellArray)bpData.array);
            this.saveBlueprintData(bpData, bytes);
        }

        protected void echo(String val) {
            this.shell.getOutput().accept(val);
        }

        protected GameSessionListener getCallback(boolean failFast) {
            if (this.callback == null) {
                RmiRegistry rmi = GameSessionHostedService.this.rmiService.getRmiRegistry(this.conn);
                this.callback = (GameSessionListener)rmi.getRemoteObject(GameSessionListener.class);
                if (this.callback == null) {
                    if (failFast) {
                        throw new RuntimeException("Unable to locate client callback for GameSessionListener");
                    }
                    log.warn("Unable to locate client callback for GameSessionListener");
                }
            }
            return this.callback;
        }
    }

    public static class ActivatorImpl
    implements Activator {
        private EntityData ed;
        private EntityId entity;
        private BodyPosition bPos;
        private MBlockCollisionSystem collisionSystem;
        private Map<String, Object> vars;

        public ActivatorImpl(EntityId entity, GameSystemManager gameSystems) {
            this.entity = entity;
            this.collisionSystem = (MBlockCollisionSystem)((MPhysSystem)gameSystems.get(MPhysSystem.class, true)).getCollisionSystem();
            this.ed = (EntityData)gameSystems.get(EntityData.class, true);
        }

        public ActivatorImpl(EntityId entity, GameSystemManager gameSystems, MBlockCollisionSystem collisionSystem) {
            this.entity = entity;
            this.collisionSystem = collisionSystem;
            this.ed = (EntityData)gameSystems.get(EntityData.class, true);
        }

        @Override
        public EntityId getId() {
            return this.entity;
        }

        private BodyPosition getBodyPosition() {
            if (this.bPos == null) {
                this.bPos = this.getAt(BodyPosition.class);
            }
            return this.bPos;
        }

        @Override
        public Vec3d getEyePos() {
            Vec3d pos = this.getPos();
            return pos.add(0.0, 1.5, 0.0);
        }

        @Override
        public Vec3d getPos() {
            return this.getBodyPosition().getLastLocation();
        }

        @Override
        public Vec3d getLookDir() {
            return this.getLookOrientation().mult(Vec3d.UNIT_Z);
        }

        @Override
        public Vec3d getDir() {
            return this.getOrientation().mult(Vec3d.UNIT_Z);
        }

        @Override
        public Quatd getLookOrientation() {
            MovementInput mi = this.getAt(MovementInput.class);
            if (mi == null) {
                return null;
            }
            return mi.getFacing();
        }

        @Override
        public Quatd getOrientation() {
            return this.getBodyPosition().getLastOrientation();
        }

        @Override
        public Iterator<BlockIterator.Intersection> pick() {
            Rayd ray = new Rayd(this.getEyePos(), this.getLookDir());
            return this.collisionSystem.rayIterator(ray, 10.0);
        }

        @Override
        public Iterator<BlockIterator.Intersection> pick(Rayd ray, double limit) {
            return this.collisionSystem.rayIterator(ray, limit);
        }

        @Override
        public <T extends EntityComponent> T getAt(Class<T> type) {
            return (T)((EntityComponent)type.cast(this.ed.getComponent(this.entity, type)));
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.entity.getId() + "]";
        }

        @Override
        public Object getProperty(String name) {
            log.info("getProperty(" + name + ")");
            return this.vars.get(name);
        }

        @Override
        public void setProperty(String name, Object newValue) {
            log.info("setProperty(" + name + ", " + newValue + ")");
            this.vars.put(name, newValue);
        }
    }

    private class UserPrompts
    implements PromptProvider<Activator, EntityId> {
        private GameSessionImpl session;

        public UserPrompts(GameSessionImpl session) {
            this.session = session;
        }

        public void showPrompt(EntityId target, PromptType type, String prompt) {
            this.session.getCallback(true).showPrompt(target, type, prompt);
        }

        public void showOptions(EntityId target, List<Option<EntityId>> options) {
            this.session.getCallback(true).showOptions(target, options);
        }
    }
}

