/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.state;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.simsilica.sim.GameLoop;
import com.simsilica.sim.GameSystem;
import com.simsilica.sim.GameSystemManager;
import com.simsilica.sim.SimTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameSystemsState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(GameSystemsState.class);
    private GameSystemManager systems = new GameSystemManager();
    private GameLoop loop;
    private boolean background;
    private long updateRateNanos = 16666667L;

    public GameSystemsState() {
        this(true);
    }

    public GameSystemsState(boolean background) {
        this.background = background;
    }

    public void setUpdateRate(long nanos) {
        this.updateRateNanos = nanos;
    }

    public long getUpdateRate() {
        return this.updateRateNanos;
    }

    public SimTime getStepTime() {
        return this.systems.getStepTime();
    }

    public long getGameTime() {
        return this.systems.getStepTime().getTime();
    }

    public void addSystem(GameSystem system) {
        this.systems.addSystem(system);
    }

    public void removeSystem(GameSystem system) {
        this.systems.removeSystem(system);
    }

    public <T> T get(Class<T> type) {
        return this.systems.get(type);
    }

    public <T, S extends T> T register(Class<T> type, S object) {
        return this.systems.register(type, object);
    }

    protected void initialize(Application app) {
        if (this.background) {
            if (this.loop == null) {
                this.loop = new GameLoop(this.systems, this.updateRateNanos);
            }
        } else {
            this.systems.initialize();
        }
    }

    protected void cleanup(Application app) {
        if (!this.background) {
            this.systems.terminate();
        }
    }

    protected void onEnable() {
        if (this.background) {
            this.loop.start();
        } else {
            this.systems.start();
        }
    }

    public void update(float tpf) {
        if (!this.background) {
            this.systems.update();
        }
    }

    protected void onDisable() {
        if (this.background) {
            this.loop.stop();
        } else {
            this.systems.stop();
        }
    }
}

