/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.environment.util;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class BoundingSphereDebug
extends Mesh {
    protected int vertCount;
    protected int triCount;
    protected int radialSamples = 32;
    protected boolean useEvenSlices;
    protected boolean interior;
    public float radius;

    public float getRadius() {
        return this.radius;
    }

    public BoundingSphereDebug() {
        this.setGeometryData();
        this.setIndexData();
    }

    private void setGeometryData() {
        int iR;
        this.setMode(Mesh.Mode.Lines);
        FloatBuffer posBuf = BufferUtils.createVector3Buffer((this.radialSamples + 1) * 3);
        FloatBuffer colBuf = BufferUtils.createVector3Buffer((this.radialSamples + 1) * 4);
        this.setBuffer(VertexBuffer.Type.Position, 3, posBuf);
        this.setBuffer(VertexBuffer.Type.Color, 4, colBuf);
        float fInvRS = 1.0f / (float)this.radialSamples;
        float[] afSin = new float[this.radialSamples + 1];
        float[] afCos = new float[this.radialSamples + 1];
        for (iR = 0; iR < this.radialSamples; ++iR) {
            float fAngle = (float)Math.PI * 2 * fInvRS * (float)iR;
            afCos[iR] = FastMath.cos(fAngle);
            afSin[iR] = FastMath.sin(fAngle);
        }
        afSin[this.radialSamples] = afSin[0];
        afCos[this.radialSamples] = afCos[0];
        for (iR = 0; iR <= this.radialSamples; ++iR) {
            posBuf.put(afCos[iR]).put(afSin[iR]).put(0.0f);
            colBuf.put(ColorRGBA.Blue.r).put(ColorRGBA.Blue.g).put(ColorRGBA.Blue.b).put(ColorRGBA.Blue.a);
        }
        for (iR = 0; iR <= this.radialSamples; ++iR) {
            posBuf.put(afCos[iR]).put(0.0f).put(afSin[iR]);
            colBuf.put(ColorRGBA.Green.r).put(ColorRGBA.Green.g).put(ColorRGBA.Green.b).put(ColorRGBA.Green.a);
        }
        for (iR = 0; iR <= this.radialSamples; ++iR) {
            posBuf.put(0.0f).put(afCos[iR]).put(afSin[iR]);
            colBuf.put(ColorRGBA.Yellow.r).put(ColorRGBA.Yellow.g).put(ColorRGBA.Yellow.b).put(ColorRGBA.Yellow.a);
        }
        this.updateBound();
        this.setStatic();
    }

    private void setIndexData() {
        int nbSegments = this.radialSamples * 3;
        ShortBuffer idxBuf = BufferUtils.createShortBuffer(2 * nbSegments);
        this.setBuffer(VertexBuffer.Type.Index, 2, idxBuf);
        int idx = 0;
        int segDone = 0;
        while (segDone < nbSegments) {
            idxBuf.put((short)idx);
            idxBuf.put((short)(idx + 1));
            ++idx;
            if (++segDone != this.radialSamples && segDone != this.radialSamples * 2) continue;
            ++idx;
        }
    }

    public static Geometry createDebugSphere(AssetManager assetManager) {
        BoundingSphereDebug b = new BoundingSphereDebug();
        Geometry geom = new Geometry("BoundingDebug", b);
        Material mat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setBoolean("VertexColor", true);
        mat.getAdditionalRenderState().setWireframe(true);
        geom.setMaterial(mat);
        return geom;
    }
}

