/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.fsm;

import com.google.common.base.MoreObjects;
import com.simsilica.fsm.StateMachine;

public class TransitionEvent<T> {
    private StateMachine fsm;
    private StateMachine.State from;
    private StateMachine.State to;
    private T trigger;
    private Object payload;

    public TransitionEvent(StateMachine fsm, StateMachine.State from, StateMachine.State to, T trigger, Object payload) {
        this.fsm = fsm;
        this.from = from;
        this.to = to;
        this.trigger = trigger;
        this.payload = payload;
    }

    public StateMachine getStateMachine() {
        return this.fsm;
    }

    public StateMachine.State getFrom() {
        return this.from;
    }

    public StateMachine.State getTo() {
        return this.to;
    }

    public T getTrigger() {
        return this.trigger;
    }

    public <P> P getPayload(Class<P> type) {
        if (!type.isInstance(this.payload)) {
            return null;
        }
        return type.cast(this.payload);
    }

    public Object getPayload() {
        return this.payload;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).omitNullValues().add("from", (Object)this.from).add("to", (Object)this.to).add("trigger", this.trigger).add("payload", this.payload).toString();
    }
}

