/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post.filters;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import java.io.IOException;

public class ToneMapFilter
extends Filter {
    private static final Vector3f DEFAULT_WHITEPOINT = new Vector3f(11.2f, 11.2f, 11.2f);
    private Vector3f whitePoint = DEFAULT_WHITEPOINT.clone();

    public ToneMapFilter() {
        super("ToneMapFilter");
    }

    public ToneMapFilter(Vector3f whitePoint) {
        this();
        this.whitePoint = whitePoint.clone();
    }

    protected boolean isRequiresDepthTexture() {
        return false;
    }

    protected void initFilter(AssetManager manager, RenderManager renderManager, ViewPort vp, int w, int h) {
        this.material = new Material(manager, "Common/MatDefs/Post/ToneMap.j3md");
        this.material.setVector3("WhitePoint", this.whitePoint);
    }

    protected Material getMaterial() {
        return this.material;
    }

    public void setWhitePoint(Vector3f whitePoint) {
        if (this.material != null) {
            this.material.setVector3("WhitePoint", whitePoint);
        }
        this.whitePoint = whitePoint;
    }

    public Vector3f getWhitePoint() {
        return this.whitePoint;
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write((Savable)this.whitePoint, "whitePoint", (Savable)DEFAULT_WHITEPOINT.clone());
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        this.whitePoint = (Vector3f)ic.readSavable("whitePoint", (Savable)DEFAULT_WHITEPOINT.clone());
    }
}

