/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mod;

import com.simsilica.mod.ModInfo;
import com.simsilica.mod.ModInfoJson;
import com.simsilica.mod.ModPack;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModManager {
    static Logger log = LoggerFactory.getLogger(ModManager.class);
    private Set<ModPack> mods = new LinkedHashSet<ModPack>();
    private Map<String, ModPack> index = new HashMap<String, ModPack>();
    private boolean initialized;
    private List<String> imports = new ArrayList<String>();
    private List<String> staticImports = new ArrayList<String>();
    private Map<String, Object> bindings = new HashMap<String, Object>();
    private List<ModPack> sorted;
    private URL[] roots;

    public ModManager() {
        this.bindings.put("modManager", this);
    }

    protected void checkInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("ModManager already initialized");
        }
    }

    public void addGlobalImport(String s) {
        log.info("addGlobalImport(" + s + ")");
        this.imports.add(s);
    }

    public List<String> getGlobalImports() {
        return this.imports;
    }

    public void addGlobalStaticImport(String s) {
        log.info("addStaticGlobalImport(" + s + ")");
        if (s.lastIndexOf(46) < 0) {
            throw new IllegalArgumentException("Invalid static import format:" + s);
        }
        this.staticImports.add(s);
    }

    public List<String> getGlobalStaticImports() {
        return this.staticImports;
    }

    public void setGlobalBinding(String name, Object value) {
        this.bindings.put(name, value);
    }

    public Map<String, Object> getGlobalBindings() {
        return this.bindings;
    }

    public void removeGlobalBinding(String name) {
        this.bindings.remove(name);
    }

    public Object getGlobalBinding(String name) {
        return this.bindings.get(name);
    }

    public void initialize() {
        this.checkInitialized();
        Collection<ModPack> sort = this.topologicalSort();
        this.sorted = new ArrayList<ModPack>(sort);
        LinkedHashSet<URL> roots = new LinkedHashSet<URL>();
        for (ModPack mod : sort) {
            log.info("preparing mod:" + mod.getId() + "  root:" + mod.getRoot());
            try {
                URL u = mod.getRoot().toURL();
                if (!roots.add(u)) continue;
                log.info("root:" + mod.getRoot());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Error resolving root to URL:" + mod.getRoot(), e);
            }
        }
        for (ModPack mod : this.sorted) {
            log.info("Initializing:" + mod.getId());
            mod.initialize(this);
        }
        this.initialized = true;
    }

    public void terminate() {
        ArrayList<ModPack> reversed = new ArrayList<ModPack>(this.sorted);
        Collections.reverse(reversed);
        for (ModPack mod : reversed) {
            mod.terminate();
        }
    }

    protected Collection<ModPack> topologicalSort() {
        LinkedHashSet<ModPack> sort = new LinkedHashSet<ModPack>();
        HashSet<ModPack> visited = new HashSet<ModPack>();
        for (ModPack mod : this.mods) {
            this.addToTopoSort(mod, sort, visited);
        }
        return sort;
    }

    protected void addToTopoSort(ModPack mod, Set<ModPack> sort, Set<ModPack> visited) {
        if (sort.contains(mod)) {
            return;
        }
        if (!visited.add(mod)) {
            throw new RuntimeException("Cycle detected at:" + mod);
        }
        for (String d : mod.getDependencies()) {
            ModPack dep = this.index.get(d);
            if (dep == null) {
                throw new RuntimeException("Dependency not found:" + d);
            }
            this.addToTopoSort(dep, sort, visited);
        }
        sort.add(mod);
    }

    public ModPack add(ModPack pack) {
        this.checkInitialized();
        ModPack existing = this.index.put(pack.getId(), pack);
        if (existing != null) {
            log.warn("Overrode existing:" + existing + " with:" + pack);
            this.mods.remove(existing);
        }
        this.mods.add(pack);
        return pack;
    }

    protected URI getParent(URI u) {
        URI parent = u.resolve(".");
        if (!parent.toString().equals(".")) {
            return parent;
        }
        String s = u.toString();
        int split = s.endsWith("json") ? s.lastIndexOf(47) : (s.endsWith("/") ? s.substring(0, s.length() - 1).lastIndexOf(47) : s.lastIndexOf(47));
        if (split < 0) {
            throw new IllegalArgumentException("Error finding parent for:" + u);
        }
        String p = s.substring(0, split) + "/";
        try {
            return new URI(p);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Error constructing parent URI from:" + p + " extracted from:" + u, e);
        }
    }

    public ModPack loadModPack(URI infoLocation) {
        log.info("loadModPack(" + infoLocation + ")");
        URI parent = this.getParent(infoLocation);
        ModInfo info = ModInfoJson.load(infoLocation);
        ModPack result = new ModPack(parent, info);
        return this.add(result);
    }

    public ModPack loadFromResource(String resource) {
        URI uri;
        URL u = this.getClass().getResource(resource);
        if (u == null) {
            throw new IllegalArgumentException("Resource not found for:" + resource);
        }
        try {
            uri = u.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Error resolving URL:" + u, e);
        }
        return this.loadModPack(uri);
    }

    public ModPack loadModPack(File modInfo) {
        return this.loadModPack(modInfo.toURI());
    }
}

