/*
 * Decompiled with CFR 0.152.
 */
package mythruna.shape;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.simsilica.crig.RigProtocol;
import com.simsilica.crig.RigType;
import com.simsilica.es.EntityData;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mblock.phys.MBlockShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RigShapeFactory
implements ShapeFactory<MBlockShape> {
    static Logger log = LoggerFactory.getLogger(RigShapeFactory.class);
    private EntityData ed;
    private LoadingCache<String, RigType> rigTypes;

    public RigShapeFactory(EntityData ed) {
        this.ed = ed;
        this.rigTypes = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<String, RigType>(){

            public RigType load(String key) {
                return RigShapeFactory.this.loadRigType(key);
            }
        });
    }

    public MBlockShape createShape(ShapeInfo info, Mass mass) {
        log.info("createShape(" + info.toString(this.ed) + ", " + mass + ")");
        String name = info.getShapeName(this.ed);
        if (!name.endsWith(".rig")) {
            return null;
        }
        RigType rigType = (RigType)this.rigTypes.getUnchecked((Object)name);
        if (rigType == null) {
            throw new RuntimeException("Rig not found:" + name);
        }
        return rigType.createShape(info, mass);
    }

    protected String rigNameToType(String name) {
        return "/rigs/" + name + ".rt";
    }

    protected RigType loadRigType(String name) {
        String rtName = this.rigNameToType(name);
        try {
            log.info("Loading rig type:" + rtName);
            return RigProtocol.loadRigType((String)rtName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading rig type:" + rtName, e);
        }
    }
}

