/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.Texture;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.VAlignment;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.text.DocumentModel;
import com.simsilica.lemur.text.DocumentModelFilter;
import com.simsilica.lemur.text.TextFilters;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import mythruna.client.GuiState;
import mythruna.client.ProgressState;
import mythruna.client.WorldListState;
import mythruna.world.WorldInfo;
import mythruna.world.WorldLibrary;
import mythruna.world.WorldManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateWorldState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(CreateWorldState.class);
    private Container window;
    private TextField nameField;
    private TextField seedField;
    private Label preview;

    public CreateWorldState() {
        this.setEnabled(false);
    }

    protected void generate() {
        String name = this.getName();
        if (name == null) {
            return;
        }
        Long seed = this.getSeed();
        if (seed == null) {
            return;
        }
        WorldLibrary library = ((WorldListState)this.getState(WorldListState.class, true)).getWorldLibrary();
        final WorldInfo info = library.createWorldInfo(name, seed.longValue());
        final ProgressState progress = (ProgressState)this.getState(ProgressState.class);
        ((JobState)this.getState(JobState.class)).execute(new Job(){
            private WorldManager world;

            public void runOnWorker() {
                progress.createTracker("world", "Creating world...");
                this.world = WorldManager.createWorld((WorldInfo)info);
            }

            public double runOnUpdate() {
                progress.closeTracker("world");
                ((WorldListState)CreateWorldState.this.getState(WorldListState.class)).startWorld(this.world);
                CreateWorldState.this.setEnabled(false);
                return 1.0;
            }
        });
    }

    public void cancel() {
        this.setEnabled(false);
    }

    protected void preview() {
        final Long seed = this.getSeed();
        if (seed == null) {
            return;
        }
        final float scale = ((GuiState)this.getState(GuiState.class)).getStandardScale() * this.window.getLocalScale().x;
        this.preview.setText("Generating " + seed + "...");
        ((JobState)this.getState(JobState.class)).execute(new Job(){
            private QuadBackgroundComponent map;

            public void runOnWorker() {
                this.map = WorldListState.createPreview(seed, (int)(256.0f * scale), 65536.0);
            }

            public double runOnUpdate() {
                CreateWorldState.this.preview.setIcon((GuiComponent)this.map);
                CreateWorldState.this.preview.setText(null);
                return 1.0;
            }
        });
    }

    protected String getName() {
        String s = this.nameField.getText();
        if (Strings.isNullOrEmpty((String)s)) {
            return null;
        }
        return s;
    }

    protected Long getSeed() {
        String s = this.seedField.getText();
        if (Strings.isNullOrEmpty((String)s)) {
            return null;
        }
        return Long.parseLong(s);
    }

    protected void initialize(Application app) {
        this.window = new Container(new ElementId("window"));
        this.window.addChild((Node)new Label("Create New World", new ElementId("window.title")), new Object[0]);
        Container properties = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Even, FillMode.Last)), new Object[0]);
        DocumentModelFilter nameModel = new DocumentModelFilter(TextFilters.charFilter((Predicate)Predicates.or((Predicate)TextFilters.isLetterOrDigit(), (Predicate)TextFilters.isInChars((char[])new char[]{'_', '-', '.', ' '}))), null);
        properties.addChild((Node)new Label("Name:"), new Object[0]);
        this.nameField = (TextField)properties.addChild((Node)new TextField((DocumentModel)nameModel), new Object[]{1});
        this.nameField.setInsets(new Insets3f(2.0f, 2.0f, 2.0f, 2.0f));
        properties.addChild((Node)new Label("Seed:"), new Object[0]);
        Container seedPanel = (Container)properties.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.First, FillMode.Even)), new Object[]{1});
        seedPanel.setBackground(null);
        DocumentModelFilter numeric = new DocumentModelFilter(TextFilters.numeric(), null);
        this.seedField = (TextField)seedPanel.addChild((Node)new TextField((DocumentModel)numeric), new Object[0]);
        this.seedField.setInsets(new Insets3f(2.0f, 2.0f, 2.0f, 2.0f));
        seedPanel.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "preview")), new Object[0]);
        Texture paper = app.getAssetManager().loadTexture("Interface/paper.jpg");
        this.preview = (Label)this.window.addChild((Node)new Label("Preview", new ElementId("spinner.value")), new Object[0]);
        this.preview.setBackground((GuiComponent)new QuadBackgroundComponent(paper));
        this.preview.setPreferredSize(new Vector3f(384.0f, 384.0f, 1.0f));
        this.preview.setTextHAlignment(HAlignment.Center);
        this.preview.setTextVAlignment(VAlignment.Center);
        this.preview.setInsets(new Insets3f(15.0f, 15.0f, 15.0f, 15.0f));
        this.preview.setColor(new ColorRGBA(0.7f, 0.4f, 0.2f, 1.0f));
        this.preview.setShadowColor(ColorRGBA.Black);
        Container buttons = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "generate")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "cancel")), new Object[0]);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        ((GuiState)this.getState(GuiState.class)).center((Panel)this.window);
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.window, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.75f));
    }

    protected void onDisable() {
        this.window.removeFromParent();
    }
}

