/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.BillboardControl;
import com.jme3.scene.control.Control;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.bpos.ChildPositionTransition3d;
import com.simsilica.bpos.LargeGridCell;
import com.simsilica.bpos.LargeObject;
import com.simsilica.crig.RigShape;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import com.simsilica.ethereal.TimeSource;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeFactoryRegistry;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mathd.trans.TransitionBuffer;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.geom.ColliderlessMesh;
import com.simsilica.mblock.geom.GeometryFactory;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.DynArray;
import com.simsilica.state.DebugHudState;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import mythruna.GameConstants;
import mythruna.client.GameSessionState;
import mythruna.client.view.AvatarState;
import mythruna.client.view.Model;
import mythruna.client.view.PickedObject;
import mythruna.client.view.SpatialFactory;
import mythruna.client.view.WorldViewState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ModelViewState.class);
    private static final long VIS_DELAY = 100000000L;
    private static final ColorRGBA NAME_LABEL_COLOR = ColorRGBA.Cyan;
    private static final ColorRGBA NAME_SHADOW_COLOR = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f);
    private WorldViewState worldState;
    private EntityData ed;
    private VersionedReference<Vec3d> posRef;
    private Grid grid = GameConstants.PHYSICS_GRID;
    private ShapeFactoryRegistry<MBlockShape> shapeFactory;
    private SpatialFactory modelFactory;
    private GeometryFactory geomFactory;
    private ObjectRootNode objectRoot;
    private Vec3i centerCell = new Vec3i(0, -10000, 0);
    private Vec3i centerWorld;
    private TimeSource timeSource;
    private MobContainer mobs;
    private ModelContainer models;
    private LargeModelContainer largeModels;
    private NameContainer names;
    private DynArray<ModelImpl> standIns = new DynArray(ModelImpl.class);
    private LinkedList<MarkVisible> markerQueue = new LinkedList();
    private Vec3i modelCenter = new Vec3i();
    private Vec3i largeModelCenter = new Vec3i();
    private int modelGridRadius = 1;
    private int nameGridRadius = 1;
    private int lobGridRadius = 1;
    private ComponentFilter[][] gridFilters;
    private ComponentFilter[][] largeGridFilters;
    private Map<EntityId, ModelImpl> modelIndex = new HashMap<EntityId, ModelImpl>();
    private VersionedHolder<String> mobCount;
    private VersionedHolder<String> modelCount;
    private VersionedHolder<String> largeModelCount;
    private VersionedHolder<String> spatialCount;

    public Model getStandIn(EntityId entityId, boolean create) {
        ModelImpl model = this.modelIndex.get(entityId);
        if (model == null && create) {
            model = this.getModel(entityId, create);
            model.markVisible();
            this.standIns.add((Object)model);
        }
        return model;
    }

    public Model releaseStandIn(EntityId entityId) {
        ModelImpl model = this.releaseModel(entityId);
        if (model != null && model.useCount <= 0) {
            this.standIns.remove((Object)model);
        }
        return model;
    }

    public Spatial getModel(EntityId entityId) {
        ModelImpl model = this.modelIndex.get(entityId);
        return model == null ? null : model.spatial;
    }

    public Spatial createSpatial(EntityId entityId) {
        Spatial model = this.getModel(entityId);
        if (model != null) {
            return model.clone();
        }
        ShapeInfo shape = (ShapeInfo)this.ed.getComponent(entityId, ShapeInfo.class);
        if (shape == null) {
            log.warn("Entity has no shape:" + entityId);
            return null;
        }
        Mass mass = (Mass)this.ed.getComponent(entityId, Mass.class);
        if (mass == null) {
            mass = new Mass(0.0);
        }
        return this.createModel(entityId, shape, (MBlockShape)this.shapeFactory.createShape(shape, mass), mass);
    }

    public Vec3d getModelPosition(EntityId entityId) {
        ModelImpl model = this.modelIndex.get(entityId);
        return model == null ? null : model.worldPos;
    }

    public Quatd getModelRotation(EntityId entityId) {
        ModelImpl model = this.modelIndex.get(entityId);
        return model == null ? null : model.worldRot;
    }

    protected Spatial findPickedSpatial(Spatial spatial) {
        Long oid = (Long)spatial.getUserData("oid");
        if (oid != null) {
            return spatial;
        }
        if (spatial.getParent() != null) {
            return this.findPickedSpatial((Spatial)spatial.getParent());
        }
        return null;
    }

    public PickedObject pickObject(EntityId skip, Vec3d dir, double limit) {
        return this.pickObject(skip, this.centerWorld.toVec3d(), limit);
    }

    public PickedObject pickObject(EntityId skip, Vec3d world, Vec3d dir, double limit) {
        log.info("pickObject(" + skip + ", " + world + ", " + dir + ", " + limit + ")");
        log.info("centerCell:" + this.centerCell + "  centerWorld:" + this.centerWorld + "  modelCenter:" + this.modelCenter);
        Vec3d start = world.subtract(this.centerWorld.toVec3d());
        log.info("start:" + start);
        Ray ray = new Ray(start.toVector3f(), dir.toVector3f());
        ray.setLimit((float)limit);
        CollisionResults crs = new CollisionResults();
        int count = this.objectRoot.pick((Collidable)ray, crs);
        for (CollisionResult cr : crs) {
            Long oid;
            EntityId entityId;
            log.info("pickObject() cr:" + cr);
            Spatial picked = this.findPickedSpatial((Spatial)cr.getGeometry());
            log.info("pickObject()  picked:" + picked);
            if (picked == null || Objects.equals(skip, entityId = new EntityId((oid = (Long)picked.getUserData("oid")).longValue()))) continue;
            Vector3f cp = cr.getContactPoint();
            log.info("pickObject() cp:" + cp + "  id:" + entityId);
            Vec3d pos = new Vec3d(cp).add(this.centerWorld);
            Vec3d normal = new Vec3d(cr.getContactNormal());
            double dist = cr.getDistance();
            return new PickedObject(entityId, pos, normal, dist);
        }
        return null;
    }

    protected Node getRoot() {
        return ((SimpleApplication)this.getApplication()).getRootNode();
    }

    protected Node getObjectRoot() {
        return this.objectRoot;
    }

    protected void initialize(Application app) {
        this.geomFactory = ((GameSessionState)this.getState(GameSessionState.class, true)).getModelGeometryFactory();
        this.modelFactory = new SpatialFactory(this.geomFactory, ((GameSessionState)this.getState(GameSessionState.class)).getCarveIncludes());
        this.ed = ((GameSessionState)this.getState(GameSessionState.class)).getEntityData();
        this.timeSource = ((GameSessionState)this.getState(GameSessionState.class)).getTimeSource();
        this.objectRoot = new ObjectRootNode("objectRoot");
        this.worldState = (WorldViewState)this.getState(WorldViewState.class, true);
        DebugHudState debug = (DebugHudState)this.getState(DebugHudState.class);
        if (debug != null) {
            this.mobCount = debug.createDebugValue("Mobs", DebugHudState.Location.Right);
            this.modelCount = debug.createDebugValue("Statics", DebugHudState.Location.Right);
            this.largeModelCount = debug.createDebugValue("Lobs", DebugHudState.Location.Right);
            this.spatialCount = debug.createDebugValue("Spatials", DebugHudState.Location.Right);
        }
        this.shapeFactory = ((GameSessionState)this.getState(GameSessionState.class)).getShapeFactory();
        this.mobs = new MobContainer(this.ed);
        this.models = new ModelContainer(this.ed);
        this.names = new NameContainer(this.ed);
        this.largeModels = new LargeModelContainer(this.ed);
        this.resetModelFilter();
        this.posRef = ((AvatarState)this.getState(AvatarState.class)).createPositionReference();
        this.updateViewPosition((Vec3d)this.posRef.get(), true);
    }

    protected void cleanup(Application app) {
        DebugHudState debug = (DebugHudState)this.getState(DebugHudState.class);
        if (debug != null) {
            debug.removeDebugValue("Mobs");
            debug.removeDebugValue("Statics");
            debug.removeDebugValue("Spatials");
        }
    }

    protected void onEnable() {
        this.getRoot().attachChild((Spatial)this.objectRoot);
        this.mobs.start();
        this.models.start();
        this.names.start();
        this.largeModels.start();
    }

    public void update(float tpf) {
        if (this.posRef.update()) {
            this.updateViewPosition((Vec3d)this.posRef.get(), false);
        }
        this.mobs.update();
        this.models.update();
        this.names.update();
        this.largeModels.update();
        long time = this.timeSource.getTime();
        for (Mob mob : this.mobs.getArray()) {
            mob.update(time);
        }
        while (!this.markerQueue.isEmpty()) {
            MarkVisible marker = this.markerQueue.peek();
            if (marker.visibleTime > time) break;
            marker = this.markerQueue.poll();
            marker.update();
        }
        if (this.mobCount != null) {
            this.mobCount.setObject((Object)String.valueOf(this.mobs.size()));
            this.modelCount.setObject((Object)String.valueOf(this.models.size()));
            this.largeModelCount.setObject((Object)String.valueOf(this.largeModels.size()));
            this.spatialCount.setObject((Object)String.valueOf(this.modelIndex.size()));
        }
    }

    protected void onDisable() {
        log.info("shutting down");
        this.objectRoot.removeFromParent();
        this.mobs.stop();
        this.models.stop();
        this.names.stop();
        this.largeModels.stop();
    }

    protected void updateViewPosition(Vec3d center, boolean forceUpdate) {
        Vec3i newCenter = this.grid.worldToCell(center);
        if (!forceUpdate && newCenter.equals((Object)this.centerCell)) {
            return;
        }
        this.centerCell.set(newCenter);
        this.centerWorld = this.grid.cellToWorld(this.centerCell);
        log.info("centerWorld:" + this.centerWorld);
        this.resetRelativeCoordinates();
        if (this.modelCenter.x != this.centerCell.x || this.modelCenter.z != this.centerCell.z) {
            this.modelCenter.x = this.centerCell.x;
            this.modelCenter.z = this.centerCell.z;
            this.resetModelFilter();
            this.resetNameFilter();
        }
        Vec3i largeCenter = GameConstants.LARGE_OBJECT_GRID.worldToCell(this.centerWorld.toVec3d());
        if (this.largeModelCenter.x != largeCenter.x || this.largeModelCenter.z != largeCenter.z) {
            this.largeModelCenter.x = largeCenter.x;
            this.largeModelCenter.z = largeCenter.z;
            this.resetLargeModelFilter();
        }
    }

    protected void resetRelativeCoordinates() {
        for (ModelImpl m : this.models.getArray()) {
            m.updateRelativePosition();
        }
        for (ModelImpl m : this.largeModels.getArray()) {
            m.updateRelativePosition();
        }
        for (ModelImpl m : (ModelImpl[])this.standIns.getArray()) {
            m.updateRelativePosition();
        }
    }

    protected void resetModelFilter() {
        int size = this.modelGridRadius * 2 + 1;
        this.gridFilters = new ComponentFilter[size][size];
        ComponentFilter[] filters = new ComponentFilter[size * size];
        int xOffset = this.modelCenter.x - this.modelGridRadius;
        int zOffset = this.modelCenter.z - this.modelGridRadius;
        int index = 0;
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                ComponentFilter filter;
                long id = this.grid.cellToId(xOffset + x, 0, zOffset + z);
                this.gridFilters[x][z] = filter = Filters.fieldEquals(SpawnPosition.class, (String)"binId", (Object)id);
                filters[index++] = filter;
            }
        }
        this.models.setFilter(Filters.or(SpawnPosition.class, (ComponentFilter[])filters));
    }

    protected void resetNameFilter() {
        int size = this.nameGridRadius * 2 + 1;
        this.gridFilters = new ComponentFilter[size][size];
        ComponentFilter[] filters = new ComponentFilter[size * size];
        int xOffset = this.modelCenter.x - this.nameGridRadius;
        int zOffset = this.modelCenter.z - this.nameGridRadius;
        int index = 0;
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                ComponentFilter filter;
                long id = this.grid.cellToId(xOffset + x, 0, zOffset + z);
                this.gridFilters[x][z] = filter = Filters.fieldEquals(SpawnPosition.class, (String)"binId", (Object)id);
                filters[index++] = filter;
            }
        }
        this.models.setFilter(Filters.or(SpawnPosition.class, (ComponentFilter[])filters));
    }

    protected void resetLargeModelFilter() {
        int size = this.lobGridRadius * 2 + 1;
        this.largeGridFilters = new ComponentFilter[size][size];
        ComponentFilter[] filters = new ComponentFilter[size * size];
        int xOffset = this.largeModelCenter.x - this.lobGridRadius;
        int zOffset = this.largeModelCenter.z - this.lobGridRadius;
        int index = 0;
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                ComponentFilter filter;
                long id = GameConstants.LARGE_OBJECT_GRID.cellToId(xOffset + x, 0, zOffset + z);
                this.largeGridFilters[x][z] = filter = Filters.fieldEquals(LargeGridCell.class, (String)"cellId", (Object)id);
                filters[index++] = filter;
            }
        }
        this.largeModels.setFilter(Filters.or(LargeGridCell.class, (ComponentFilter[])filters));
    }

    protected Spatial createModel(EntityId id, ShapeInfo shapeInfo, MBlockShape shape, Mass mass) {
        if (shape instanceof RigShape) {
            String name = shapeInfo.getShapeName(this.ed);
            name = name + ".j3o";
            Spatial result = this.getApplication().getAssetManager().loadModel(name);
            result.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
            result.setUserData("oid", (Object)id.getId());
            return result;
        }
        return this.modelFactory.createModel(id, shapeInfo.getShapeName(this.ed), shapeInfo, shape, mass);
    }

    protected ModelImpl getModel(EntityId entityId, boolean create) {
        log.info("getModel(" + entityId + ")");
        ModelImpl result = this.modelIndex.get(entityId);
        if (result == null && create) {
            result = new ModelImpl(entityId);
            this.modelIndex.put(entityId, result);
        }
        result.acquire();
        return result;
    }

    protected ModelImpl releaseModel(EntityId entityId) {
        log.info("releaseModel(" + entityId + ")");
        ModelImpl result = this.modelIndex.get(entityId);
        if (result == null) {
            log.warn("Releasing model that has not been acquired:" + entityId);
        } else if (result.release()) {
            this.modelIndex.remove(entityId);
        }
        return result;
    }

    public static float getOffset(BoundingVolume bv) {
        if (bv instanceof BoundingBox) {
            return ((BoundingBox)bv).getYExtent();
        }
        if (bv instanceof BoundingSphere) {
            return ((BoundingSphere)bv).getRadius();
        }
        return 0.0f;
    }

    private class ModelImpl
    implements Model {
        private EntityId entityId;
        private Spatial spatial;
        private ShapeInfo shapeInfo;
        private int useCount;
        private boolean dynamic;
        private SpawnPosition pos;
        private int visibleCount;
        private Vec3d worldPos;
        private Quatd worldRot;
        private Vec3i worldCell;
        private int lighting = LightUtils.DIRECT_SUN;
        private Node nameNode;
        private String name;
        private Label nameLabel;

        public ModelImpl(EntityId entityId) {
            this.entityId = entityId;
        }

        @Override
        public EntityId getEntityId() {
            return this.entityId;
        }

        public void setName(String name) {
            if (Objects.equals(this.name, name)) {
                return;
            }
            if (this.nameNode == null && name == null) {
                return;
            }
            if (name == null) {
                this.nameNode.removeFromParent();
                this.nameNode = null;
                return;
            }
            float nameScale = 0.01f;
            if (this.nameNode == null) {
                this.nameLabel = new Label(name, new ElementId("object.label"));
                this.nameLabel.setLocalScale(nameScale);
                this.nameLabel.setColor(NAME_LABEL_COLOR);
                this.nameLabel.setShadowColor(NAME_SHADOW_COLOR);
                this.nameNode = new Node("name:" + this.entityId);
                this.nameNode.attachChild((Spatial)this.nameLabel);
                this.nameNode.addControl((Control)new BillboardControl());
                ModelViewState.this.getObjectRoot().attachChild((Spatial)this.nameNode);
            } else {
                this.nameLabel.setText(name);
            }
            Vector3f pref = this.nameLabel.getPreferredSize();
            this.nameLabel.setLocalTranslation(-pref.x * 0.5f * nameScale, pref.y * nameScale, 0.0f);
            this.updateLabelLocation();
        }

        public void acquire() {
            ++this.useCount;
        }

        public boolean release() {
            --this.useCount;
            if (this.useCount <= 0) {
                if (this.spatial != null) {
                    this.spatial.removeFromParent();
                }
                return true;
            }
            return false;
        }

        @Override
        public void setShape(ShapeInfo shapeInfo) {
            if (Objects.equals(this.shapeInfo, shapeInfo)) {
                return;
            }
            this.shapeInfo = shapeInfo;
            if (this.spatial != null) {
                this.spatial.removeFromParent();
            }
            Mass mass = (Mass)ModelViewState.this.ed.getComponent(this.entityId, Mass.class);
            this.spatial = ModelViewState.this.createModel(this.entityId, shapeInfo, (MBlockShape)ModelViewState.this.shapeFactory.createShape(shapeInfo, mass), mass);
            if (this.spatial != null) {
                ModelViewState.this.getObjectRoot().attachChild(this.spatial);
                this.resetVisibility();
            }
        }

        @Override
        public void setPosition(SpawnPosition pos) {
            this.pos = pos;
            this.updateRelativePosition();
            this.setWorldPosition(pos.getLocation(), pos.getOrientation());
        }

        public void setWorldPosition(Vec3d worldPos, Quatd worldRot) {
            this.worldPos = worldPos;
            this.worldRot = worldRot;
            if (!this.dynamic && this.spatial != null) {
                Vector3f center = this.spatial.getWorldBound().getCenter();
                Vec3i loc = new Vec3i(((ModelViewState)ModelViewState.this).centerWorld.x + (int)Math.floor(center.x), ((ModelViewState)ModelViewState.this).centerWorld.y + (int)Math.floor(center.y), ((ModelViewState)ModelViewState.this).centerWorld.z + (int)Math.floor(center.z));
                if (!Objects.equals(loc, this.worldCell)) {
                    this.worldCell = loc;
                    this.checkLighting();
                }
            }
        }

        public void updateRelativePosition() {
            if (!this.dynamic) {
                if (this.pos == null) {
                    log.info("dynamic=false, pos=null, useCount=" + this.useCount);
                } else {
                    Vec3d loc = this.pos.getLocation();
                    loc = loc.subtract(ModelViewState.this.centerWorld.toVec3d());
                    this.spatial.setLocalTranslation(loc.toVector3f());
                    this.spatial.setLocalRotation(this.pos.getOrientation().toQuaternion());
                }
                this.updateLabelLocation();
            }
        }

        protected void updateLabelLocation() {
            if (this.nameLabel == null || this.worldPos == null) {
                return;
            }
            if (this.spatial == null) {
                Vector3f pos = this.worldPos.subtract(ModelViewState.this.centerWorld).toVector3f();
                this.nameNode.setLocalTranslation(pos);
            } else if (this.nameNode != null) {
                BoundingVolume bounds = this.spatial.getWorldBound();
                float yOffset = -1.5f;
                this.nameNode.setLocalTranslation(bounds.getCenter());
                this.nameNode.move(0.0f, yOffset, 0.0f);
            }
        }

        public void setDynamic(boolean dynamic) {
            if (this.dynamic == dynamic) {
                return;
            }
            this.dynamic = dynamic;
            if (!dynamic) {
                this.updateRelativePosition();
            }
        }

        protected void markVisible() {
            ++this.visibleCount;
            this.resetVisibility();
        }

        protected void markInvisible() {
            --this.visibleCount;
            this.resetVisibility();
        }

        protected void resetVisibility() {
            log.info("resetVisibility():" + this.visibleCount);
            if (this.spatial == null) {
                log.info("spatial is null");
                return;
            }
            if (this.visibleCount > 0) {
                log.info("visible:" + this.entityId);
                this.spatial.setCullHint(Spatial.CullHint.Inherit);
            } else {
                log.info("invisible:" + this.entityId);
                this.spatial.setCullHint(Spatial.CullHint.Always);
            }
        }

        protected void checkLighting() {
            int light = ModelViewState.this.worldState.getWorldLight(this.worldCell.x, this.worldCell.y, this.worldCell.z);
            this.setLighting(light);
        }

        protected void setLighting(int lighting) {
            if (this.lighting == lighting) {
                return;
            }
            log.info("Reset lighting to:" + Integer.toHexString(lighting));
            final int red = LightUtils.red((int)lighting);
            final int green = LightUtils.green((int)lighting);
            final int blue = LightUtils.blue((int)lighting);
            final int sun = LightUtils.sun((int)lighting);
            this.spatial.depthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(){

                public void visit(Geometry geom) {
                    Mesh mesh = geom.getMesh();
                    if (mesh instanceof ColliderlessMesh) {
                        ModelImpl.this.relight(mesh, red, green, blue, sun);
                    }
                }
            });
        }

        protected void relight(Mesh mesh, int red, int green, int blue, int sun) {
            VertexBuffer buff = mesh.getBuffer(VertexBuffer.Type.Color);
            FloatBuffer cb = (FloatBuffer)buff.getData();
            cb.rewind();
            int size = mesh.getVertexCount();
            for (int i = 0; i < size; ++i) {
                cb.put((float)red / 15.0f);
                cb.put((float)green / 15.0f);
                cb.put((float)blue / 15.0f);
                cb.put((float)sun / 15.0f);
            }
            buff.updateData((Buffer)cb);
        }
    }

    private class ObjectRootNode
    extends Node {
        public ObjectRootNode(String name) {
            super(name);
        }

        public int collideWith(Collidable other, CollisionResults results) {
            return 0;
        }

        public int pick(Collidable other, CollisionResults results) {
            return super.collideWith(other, results);
        }
    }

    private class MobContainer
    extends EntityContainer<Mob> {
        public MobContainer(EntityData ed) {
            super(ed, new Class[]{BodyPosition.class, ShapeInfo.class});
        }

        public Mob[] getArray() {
            return (Mob[])super.getArray();
        }

        protected Mob addObject(Entity e) {
            log.info("add mob for:" + e.getId());
            Mob object = new Mob(e);
            this.updateObject(object, e);
            return object;
        }

        protected void updateObject(Mob object, Entity e) {
            object.setShape((ShapeInfo)e.get(ShapeInfo.class));
            object.setPosition((BodyPosition)e.get(BodyPosition.class));
        }

        protected void removeObject(Mob object, Entity e) {
            log.info("remove mob for:" + e.getId());
            object.release();
        }
    }

    private class ModelContainer
    extends EntityContainer<ModelImpl> {
        public ModelContainer(EntityData ed) {
            super(ed, new Class[]{SpawnPosition.class, ShapeInfo.class});
        }

        public void setFilter(ComponentFilter filter) {
            super.setFilter(filter);
        }

        public ModelImpl[] getArray() {
            return (ModelImpl[])super.getArray();
        }

        protected ModelImpl addObject(Entity e) {
            log.info("add model for:" + e.getId() + "   at time:" + ModelViewState.this.timeSource.getTime());
            ModelImpl object = ModelViewState.this.getModel(e.getId(), true);
            this.updateObject(object, e);
            ModelViewState.this.markerQueue.add(new MarkVisible(object, ModelViewState.this.timeSource.getTime() + 100000000L));
            return object;
        }

        protected void updateObject(ModelImpl object, Entity e) {
            object.setShape((ShapeInfo)e.get(ShapeInfo.class));
            object.setPosition((SpawnPosition)e.get(SpawnPosition.class));
        }

        protected void removeObject(ModelImpl object, Entity e) {
            log.info("remove model for:" + e.getId());
            ModelViewState.this.releaseModel(e.getId());
        }
    }

    private class NameContainer
    extends EntityContainer<ModelImpl> {
        public NameContainer(EntityData ed) {
            super(ed, new Class[]{Name.class, SpawnPosition.class, ShapeInfo.class});
        }

        public void setFilter(ComponentFilter filter) {
            super.setFilter(filter);
        }

        protected ModelImpl addObject(Entity e) {
            log.info("add name indicator for:" + e);
            ModelImpl object = ModelViewState.this.getModel(e.getId(), true);
            this.updateObject(object, e);
            return object;
        }

        protected void updateObject(ModelImpl object, Entity e) {
            Name name = (Name)e.get(Name.class);
            if (name == null) {
                object.setName(null);
            } else {
                object.setName(name.getName());
            }
        }

        protected void removeObject(ModelImpl object, Entity e) {
            log.info("remove name indicator for:" + e.getId());
            object.setName(null);
            ModelViewState.this.releaseModel(e.getId());
        }
    }

    private class LargeModelContainer
    extends EntityContainer<ModelImpl> {
        public LargeModelContainer(EntityData ed) {
            super(ed, new Class[]{SpawnPosition.class, ShapeInfo.class, LargeObject.class, LargeGridCell.class});
        }

        public void setFilter(ComponentFilter filter) {
            super.setFilter(filter);
        }

        public ModelImpl[] getArray() {
            return (ModelImpl[])super.getArray();
        }

        protected ModelImpl addObject(Entity e) {
            log.info("LargeObject add model for:" + e.getId() + "   at time:" + ModelViewState.this.timeSource.getTime());
            ModelImpl object = ModelViewState.this.getModel(e.getId(), true);
            this.updateObject(object, e);
            ModelViewState.this.markerQueue.add(new MarkVisible(object, ModelViewState.this.timeSource.getTime() + 100000000L));
            return object;
        }

        protected void updateObject(ModelImpl object, Entity e) {
            object.setShape((ShapeInfo)e.get(ShapeInfo.class));
            object.setPosition((SpawnPosition)e.get(SpawnPosition.class));
        }

        protected void removeObject(ModelImpl object, Entity e) {
            log.info("LargeObject remove model for:" + e.getId());
            ModelViewState.this.releaseModel(e.getId());
        }
    }

    private class Mob {
        private Entity entity;
        private ModelImpl model;
        private BodyPosition pos;
        private TransitionBuffer<? extends ChildPositionTransition3d> buffer;
        private EntityId lastParent;
        boolean visible;
        boolean forceInvisible;

        public Mob(Entity entity) {
            this.entity = entity;
            this.model = ModelViewState.this.getModel(entity.getId(), true);
            this.model.setDynamic(true);
        }

        public void setShape(ShapeInfo shapeInfo) {
            this.model.setShape(shapeInfo);
        }

        public void setPosition(BodyPosition pos) {
            if (this.pos == pos) {
                return;
            }
            pos.initialize(this.entity.getId(), 12);
            this.buffer = pos.getBuffer();
        }

        public void update(long time) {
            ChildPositionTransition3d trans = (ChildPositionTransition3d)this.buffer.getTransition(time);
            if (trans != null) {
                Vec3d pos = trans.getPosition(time, true);
                if (this.model.spatial.getParent() == ModelViewState.this.getObjectRoot()) {
                    pos = pos.subtract(ModelViewState.this.centerWorld.toVec3d());
                }
                Quatd rot = trans.getRotation(time, true);
                this.model.setWorldPosition(pos, rot);
                this.model.spatial.setLocalTranslation(pos.toVector3f());
                this.model.spatial.setLocalRotation(rot.toQuaternion());
                this.model.updateLabelLocation();
                this.setVisible(trans.getVisibility(time));
                EntityId parentId = trans.getParentId(time, true);
                if (!Objects.equals(parentId, this.lastParent)) {
                    if (parentId == null) {
                        ModelViewState.this.getObjectRoot().attachChild(this.model.spatial);
                        this.lastParent = parentId;
                    } else {
                        ModelImpl parent = (ModelImpl)ModelViewState.this.modelIndex.get(parentId);
                        if (parent != null) {
                            ((Node)parent.spatial).attachChild(this.model.spatial);
                        }
                        this.lastParent = parentId;
                    }
                }
            }
        }

        protected void setVisible(boolean f) {
            if (this.visible == f) {
                return;
            }
            log.info("setVisible(" + this.entity.getId() + ", " + f + ")");
            this.visible = f;
            if (this.visible) {
                this.model.markVisible();
            } else {
                this.model.markInvisible();
            }
        }

        public void release() {
            ModelViewState.this.releaseModel(this.entity.getId());
            this.model.setDynamic(false);
        }
    }

    private class MarkVisible {
        ModelImpl model;
        long visibleTime;

        public MarkVisible(ModelImpl model, long visibleTime) {
            this.model = model;
            this.visibleTime = visibleTime;
        }

        public void update() {
            log.info("MarkVisible.update() useCount:" + this.model.useCount + "  dynamic:" + this.model.dynamic);
            if (this.model.useCount == 1 && this.model.dynamic) {
                log.info("only dynamic... should already be visible.");
                return;
            }
            if (this.model.useCount == 0) {
                log.info("not used anymore");
                return;
            }
            log.info("Marking static object visible:" + this.model.entityId);
            this.model.markVisible();
        }
    }
}

